<?

class Embargos extends APP {
	PRIVATE $APP;

	PUBLIC $embargos;
	PUBLIC $cert_positiva;
	PUBLIC $cert_negativa;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getStatus();
	}

	function getCertidao($codigo) {
		$this->db->where('codigo', $codigo);
		$cert = $this->db->ObjectBuilder()->getOne('embargos_certidoes');
		$cert->e = json_decode($cert->info);
		return $cert;
	}

	function getUrl($url) {
		$curl = curl_init();
		curl_setopt_array($curl,
			array(
			    CURLOPT_URL => $url,
			    CURLOPT_HEADER => false,
			    CURLOPT_RETURNTRANSFER => true,
			    CURLOPT_NOBODY => false,
			    CURLOPT_SSL_VERIFYHOST => 0,
			    CURLOPT_SSL_VERIFYPEER => 0
			)
		);
		$return = curl_exec($curl);
		curl_close($curl);
		return $return;
	}

	function validaCertidao($doc, $retry = false) {
		$padrao = $this::getStatusPadrao();
		$this->db->where('documento', $doc);
		$this->db->where('status', $padrao);
		if($this->cert_positiva = $this->db->ObjectBuilder()->get('embargos', null)) {
			return true;

		} else if($this->cert_negativa = $this::consultaCertidao($doc)) {
			return true;

		} else {
			$setup = $this::getSetup();
			$info = (object) array(
				'prazo' => $setup->prazo,
				'texto' => str_replace('%documento%', $tipo.' nº '.$doc, $setup->texto_negativa),
			);
			$insert = array(
				'embargo' => 0,
				'documento' => $doc,
				'info' => json_encode($info),
				'data' => date('Y-m-d H:i:s'),
				'vencimento' => date('Y-m-d', strtotime('+ '.$setup->prazo)),
				'codigo' => strtoupper(geraSenha(10)),
				'entidade' => 0
			);
			$this->db->insert('embargos_certidoes', $insert);
			if(!$retry) {
				return $this::validaCertidao($doc, true);
			} else {
				return false;
			}
		}
	}

	function consultaCertidao($doc) {
		$this->db->where('documento', $doc);
		$this->db->where('vencimento', date('Y-m-d'), '>=');
		$this->db->orderBy('vencimento', 'DESC');
		if($c = $this->db->ObjectBuilder()->getOne('embargos_certidoes')) {
			$c->info = json_decode($c->info);
		}
		return $c;
	}

	function consultaCC($codigo) {
		$this->db->where('codigo', $codigo);
		if($c = $this->db->ObjectBuilder()->getOne('embargos_certidoes')) {
			$c->info = json_decode($c->info);
		}
		return $c;
	}

	function salvarCertidao($info) {
		return $this->db->insert('embargos_certidoes', $infos);
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('embargos_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('embargos_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('embargos_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getSetup() {
		$this->db->orderBy('id', 'DESC');
		return $this->setup = $this->db->ObjectBuilder()->getOne('embargos_setup');
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('embargos_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('embargos_arquivos');
	}

	function consultaEmbargo($id = false, $doc = false) {
		if($id) { $this->db->where('id', $id); }
		if($doc) { $this->db->where('documento', $doc); }
		return $this->db->ObjectBuilder()->getValue('embargos', 'id', 1);
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('embargos_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('embargos_arquivos');
	}

	function setStatus($ID, $status, $depto = false) {
		$this->db->where('id', $ID);
		$dados['status'] = $status;
		$this->db->update('embargos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('embargos_arquivos', $legenda);
	}

	function addResposta($dados) {
		if ( $this->db->insert('embargos_respostas', $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function excluirResposta($ID) {
		if ($r = $this::getRespostaID($ID) ) {
			if ($A = $this::getArquivosCodigo($r->codigo)) {
				foreach ($A as $a) {
					$this::excluirArquivo($a->id);
				}
				$path = $A[0]->path;
				@rmdir($path);
				$from = array('arquivos/', 'imagens/'); $to = array('', '');
				@rmdir(str_replace($from, $to, $path));
			}
		}
		$this->db->where('id' ,$ID);
		if ( $this->db->delete('embargos_respostas') ) {
			return true;
		} else {
			return false;
		}
	}

	function editarResposta($ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('embargos_respostas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function getRespostas($p) {
		$this->db->where('embargo', $p);
		$this->db->where('resposta', 'Embargos recebido.', '!=');
		return $this->db->ObjectBuilder()->get('embargos_respostas') ?? false;
	}

	function getRespostaID($r) {
		$this->db->where('id', $r);
		return $this->db->ObjectBuilder()->getOne('embargos_respostas');
	}
	
	function getEmbargos($limitador = 100, $busca = false) {
		if(!$limitador) { $limitador = 100; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->where('p.entidade', $this->_auth->entidade->id);

		$this->db->join('embargos_status s', 's.id = p.status', 'LEFT');
		$this->db->OrderBy('p.data', 'DESC');

		if ($busca) {
			$this->db->where("(p.documento = '$busca' OR p.nome LIKE '%$busca%')");
		}

		if ($embargos = $this->db->ObjectBuilder()->get('embargos p', $limitador, 'p.*, s.nome as status, s.id as status_id')) {
			foreach($embargos as $p) {
				$p->{'respostas'} = $this::getRespostas($p->id);
				$EMBARGOS[] = $p;
			}
			return $this->embargos = $EMBARGOS;
		} else {
			return null;
		}
			
	}

	function getEmbargosCodigo($codigo) {
		$this->db->join('embargos_departamentos d', 'd.id = p.departamento', 'LEFT');
		$this->db->join('embargos_status s', 's.id = p.status', 'LEFT');
		$this->db->where('p.codigo', $codigo);
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$embargo = $this->db->ObjectBuilder()->get('embargos p', null, 'p.*, d.nome as departamento, p.departamento as departamento_id, s.nome as status, s.id as status_id')[0];
		return $embargo;
	}

	function getEmbargoID($ID) {
		$this->db->join('embargos_status s', 's.id = p.status', 'LEFT');
		if(is_array($ID)) {
			$this->db->where('p.id', $ID, 'IN');
		} else {
			$this->db->where('p.id', $ID);
		}
		if( $embargo = $this->db->ObjectBuilder()->get('embargos p', null, 'p.*, s.nome as status, s.id as status_id')[0] ) {
			$embargo->{'respostas'} = $this::getRespostas($embargo->id);
		}
		return $embargo;
	}

	function consultaAcessoEmbargos($usuario, $embargo) {
		$this->db->where('usuario', $usuario);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('nivel', 1);
		if ( $this->db->getOne('embargos_acessos') ) {
			return true;
		
		} else {
			$this->db->join('embargos_departamentos d', 'd.id = p.departamento', 'INNER');
			$this->db->join('embargos_departamentos_acesso a', "a.departamento = d.id AND a.usuario = '".$this->_auth->usuario->ID."'", 'INNER');
			$this->db->where('p.id', $embargo->id);

			if ( $this->db->get('embargos p', null, 'p.*') ) {
				return true;

			} else {
				return $embargo->departamento;

			}
		}
	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('embargos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$o = $this::getEmbargosID($ID);

		if ($r = $o->respostas) {
			foreach($r as $r) {
				if ($A = $this::getArquivosCodigo($r->codigo)) {
					foreach ($A as $a) {
						$this::excluirArquivo($a->id);
					}
					$path = $A[0]->path;
					@rmdir($path);
					$from = array($r->codigo); $to = array('', '');
					@rmdir(str_replace($from, $to, $path));
				}
				$R[] = $r->id;
			}
			$this->db->where('id', $R, 'IN');
			$this->db->delete('embargos_respostas');
		}
		if ($A = $this::getArquivosCodigo($o->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path);
			$from = array('arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('embargos');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('embargos', $dados)){
			$ID = $this->db->getInsertID();
			if($dados['email']) {
				//$this::enviarEmail('criar', $ID);
			}
			return $ID;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getDepartamentos() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->departamentos = $this->db->ObjectBuilder()->get('embargos_departamentos');
		return $this->departamentos;
	}

	function getDepartamentoID($ID) {
		$this->db->where('id', $ID);
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$departamento = $this->db->ObjectBuilder()->get('embargos_departamentos');
		return $departamento;
	}

	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('embargos_status');
		return $this->status;
	}

	function getStatusPadrao($entidade = false) {
		if($entidade) {
			$this->db->where('entidade', $entidade);
		}
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->status_padrao = $this->db->ObjectBuilder()->getValue('embargos_status', 'id', 1);
		return $this->status_padrao ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->update('embargos_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->update('embargos_status', $dados);
		return true;
	}

	function getEmbargosView($limitador, $busca = false, $orderBy = false, $pagina = 1) {
		$padrao = $this::getStatusPadrao($this->_auth->entidade->id);

		$this->db->join('embargos_status s', 's.id = e.status', 'LEFT');
		if ($busca) {
			$this->db->where("(e.documento = '$busca' OR e.nome LIKE '%$busca%')");
		}
		$this->db->where('e.status', $padrao);
		//$this->db->where('e.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy($orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('data', 'DESC');
		}
		$this->db->pageLimit = $limitador;
		if ($embargos = $this->db->ObjectBuilder()->paginate('embargos e', $pagina, 'e.*, s.nome as status, s.id as status_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($embargos as $e) { 
				$e->{'respostas'} = $this::getRespostas($e->id);
			}
			return $embargos;
		} else {
			return false;
		}
	}
}

return $EMBARGOS = new Embargos($isView);


function mascara($val, $mask) {
  $maskared = '';
  $k = 0;
  for($i = 0; $i<=strlen($mask)-1; $i++)
  {
     if($mask[$i] == '#')
     {
        if(isset($val[$k]))
        $maskared .= $val[$k++];
     }
     else
     {
        if(isset($mask[$i]))
           $maskared .= $mask[$i];
     } 
  }
  return $maskared;
}


?>