<?

include('aplicativos/ead/core/google.php');

$aula = $_POST['aula'];
$titulo = $_POST['titulo'];
$descricao = $_POST['descricao'];

if(isset($_FILES['video'])){
	// Video info
	$title = $_POST['titulo'];
	$desc = $_POST['descricao'];
	$tags = $_POST['tags'];
	$privacy = 'public';
	
	// Check whether file field is not empty
	if($_FILES["video"]["name"] != ''){
		// File upload path
		$pathName = HD."_videos/";
		$fileName = str_shuffle('codexworld').'-'.basename($_FILES["video"]["name"]);
		$filePath = $pathName.$fileName;
		if (!is_dir($pathName)) { @mkdir($pathName, 0777, true);}

		// Check the file type
		$allowedTypeArr = array("video/mp4", "video/avi", "video/mpeg", "video/mpg", "video/mov", "video/wmv", "video/rm");
		if(in_array($_FILES['video']['type'], $allowedTypeArr)){
			// Upload file to local server
			if(move_uploaded_file($_FILES['video']['tmp_name'], $filePath)){
				// Insert video data in the database
				$vdata = array(
					'title' => $title,
					'description' => $desc,
					'tags' => $tags,
					'privacy' => $privacy,
					'file_name' => $fileName
				);
				$insertID = $APP->db->insert('ead_temp_videos', $vdata);
				$_SESSION['uploadedFileId'] = $insertID;
			} else {
				header("Location:".BASE_URL."index.php?err=ue");
				exit;
			}
		}else{
			header("Location:".BASE_URL."index.php?err=fe");
			exit;
		}
	} else {
		header('Location:'.BASE_URL.'index.php?err=bf');
		exit;
	}
}

// Get uploaded video data from database
$APP->db->where('id', ($youtube_video_id ?? $_SESSION['uploadedFileId']));
$videoData = $APP->db->getOne('ead_temp_videos');

// Check if an auth token exists for the required scopes
$tokenSessionKey = 'token-' . $client->prepareScopes();
if (isset($_GET['code'])) {
	if (strval($_SESSION['state']) !== strval($_GET['state'])) {
		die('The session state did not match.');
	}

	$client->authenticate($_GET['code']);
	$_SESSION[$tokenSessionKey] = $client->getAccessToken();
	header('Location: ' . REDIRECT_URL);
}

if (isset($_SESSION[$tokenSessionKey])) {
	$client->setAccessToken($_SESSION[$tokenSessionKey]);
}

// Check to ensure that the access token was successfully acquired.
if ($client->getAccessToken()) {
	$htmlBody = '';
	try{
		// REPLACE this value with the path to the file you are uploading.
		$pathName = HD."_videos/";
		$videoPath = $pathName.$videoData['file_name'];
		
		if(!empty($videoData['youtube_video_id'])){
			// Uploaded video data
			$videoTitle = $videoData['title'];
			$videoDesc = $videoData['description'];
			$videoTags = $videoData['tags'];
			$videoId = $videoData['youtube_video_id'];
		}else{
			// Create a snippet with title, description, tags and category ID
			// Create an asset resource and set its snippet metadata and type.
			// This example sets the video's title, description, keyword tags, and
			// video category.
			$snippet = new Google_Service_YouTube_VideoSnippet();
			$snippet->setTitle($videoData['title']);
			$snippet->setDescription($videoData['description']);
			$snippet->setTags(explode(",", $videoData['tags']));
	
			// Numeric video category. See
			// https://developers.google.com/youtube/v3/docs/videoCategories/list
			$snippet->setCategoryId("22");
	
			// Set the video's status to "public". Valid statuses are "public",
			// "private" and "unlisted".
			$status = new Google_Service_YouTube_VideoStatus();
			$status->privacyStatus = $videoData['privacy'];
	
			// Associate the snippet and status objects with a new video resource.
			$video = new Google_Service_YouTube_Video();
			$video->setSnippet($snippet);
			$video->setStatus($status);
	
			// Specify the size of each chunk of data, in bytes. Set a higher value for
			// reliable connection as fewer chunks lead to faster uploads. Set a lower
			// value for better recovery on less reliable connections.
			$chunkSizeBytes = 1 * 1024 * 1024;
	
			// Setting the defer flag to true tells the client to return a request which can be called
			// with ->execute(); instead of making the API call immediately.
			$client->setDefer(true);
	
			// Create a request for the API's videos.insert method to create and upload the video.
			$insertRequest = $youtube->videos->insert("status,snippet", $video);
	
			// Create a MediaFileUpload object for resumable uploads.
			$media = new Google_Http_MediaFileUpload(
				$client,
				$insertRequest,
				'video/*',
				null,
				true,
				$chunkSizeBytes
			);
			$media->setFileSize(filesize($videoPath));
	
	
			// Read the media file and upload it chunk by chunk.
			$status = false;
			$handle = fopen($videoPath, "rb");
			while (!$status && !feof($handle)) {
				$chunk = fread($handle, $chunkSizeBytes);
				$status = $media->nextChunk($chunk);
			}
			fclose($handle);
	
			// If you want to make other calls after the file upload, set setDefer back to false
			$client->setDefer(false);
			
			// Update youtube video id to database
			$APP->db->where('id', $videoData['id']);
			$APP->db->update('ead_temp_videos', array('youtube_video_id' => $status['id']));

			// Delete video file from local server
			@unlink($videoPath);
			
			// uploaded video data
			$videoTitle = $status['snippet']['title'];
			$videoDesc = $status['snippet']['description'];
			$videoTags = implode(",",$status['snippet']['tags']);
			$videoId = $status['id'];

			if($videoId) {
				$aula = $EAD->getAulas($aula);
				$data = array(
					'codigo' => $aula->codigo,
					'titulo' => $titulo,
					'link' => $videoId,
				);
				if ($EAD->addVideo($data)) {
					$return = array(
						'success' => true,
						'ID' => $ID,
						'msg' => 'Cadastrado com sucesso!',
						'reset' => 'form',
						'modal' => '#modal-upload-video',
						'mtipo' => 'info',
					);
				} else {
					$return = array(
						'success' => false,
						'msg' => 'Não foi possível confirmar algumas informações. Atualize a página e tente novamente.',
						'mtipo' => 'error',
					);
				}
			}
		}

	} catch (Google_Service_Exception $e) {
		$return = array(
			'success' => false,
			'titulo' => 'Houve um erro:',
			'msg' => $e->getMessage(),
			'mtipo' => 'error',
			'debug' => 'Google_Service_Exception'
		);
	} catch (Google_Exception $e) {
		$return = array(
			'success' => false,
			'titulo' => 'Houve um erro:',
			'msg' => $e->getMessage(),
			'mtipo' => 'error',
			'debug' => 'Google_Exception'
		);
	}
	$_SESSION[$tokenSessionKey] = $client->getAccessToken();

} elseif (OAUTH_CLIENT_ID == '') {

	$return = array(
		'success' => false,
		'titulo' => 'Credenciais requerida',
		'msg' => 'You need to set $oauthClientID and $oauthClientSecret before proceeding.',
		'mtipo' => 'error',
		'debug' => 'OAUTH_CLIENT_ID'
	);

} else {

	$state = mt_rand();
	$client->setState($state);
	$_SESSION['state'] = $state;

	$authUrl = $client->createAuthUrl();

	$return = array(
		'success' => false,
		'titulo' => 'Autenticação Requerida.',
		'msg' => 'Entre em contato com o suporte',
		'mtipo' => 'error',
		'debug' => 'OAUTH_CLIENT_ID',
		'url_AUTH' => $authUrl,
	);
}

header("Content-Type: application/json; charset=utf-8");
echo json_encode($return);