<?
class Downloads extends APP {
	PRIVATE $APP;

	PUBLIC $downloads;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getDownloads();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
			$this->entidade = $this->_auth->entidade;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('downloads_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('downloads_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('downloads_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('downloads_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('downloads_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('downloads_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('downloads_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('downloads_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('downloads_arquivos');
	}
	
	function getDownloads() {
		$this->db->join('downloads_secoes s', 's.id = d.secao', 'LEFT');
		$this->db->where('d.entidade', $this->_auth->entidade->id);
		$this->downloads = $this->db->ObjectBuilder()->get('downloads d', null, 'd.*, s.nome as secao');
		return $this->downloads;
	}

	function getDownloadID($ID) {
		$this->db->where('id', $ID);
		$download = $this->db->ObjectBuilder()->getOne('downloads');
		return $download;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('downloads', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$d = $this::getDownloadID($ID);

		if ($A = $this::getArquivosCodigo($d->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('downloads');
	}


	function criar($dados) {
		if ($this->db->insert('downloads', $dados)){
			return $this->db->getInsertID();
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('downloads a', 'a.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('downloads_secoes s', null, 's.*');
		return $this->secoes;
	}

	function getDownloadsNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1, $titulo = null) {
		$this->db->join('downloads a', 'a.codigo = ar.codigo', 'INNER');
		$this->db->join('downloads_secoes s', 'a.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if(strlen($titulo) > 2) {
			$this->db->where('a.titulo', $titulo);
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
			if ($orderBy->campo != 'legenda') {
				$this->db->OrderBy('ar.data', 'DESC');
			}
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('downloads_arquivos ar', $pagina, 'ar.*, a.titulo, s.nome as secao'))  {
			$this->totalCount = $this->db->totalCount;
			return $arquivos;
		} else {
			return false;
		}
	}

	function getDownloadsList($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1, $titulo = null) {
		$this->db->join('downloads a', 'a.codigo = ar.codigo', 'INNER');
		$this->db->join('downloads_secoes s', 'a.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if(strlen($titulo) > 2) {
			$this->db->where('a.titulo', $titulo);
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
			if ($orderBy->campo != 'legenda') {
				$this->db->OrderBy('ar.legenda', 'ASC');
			}
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->groupBy('a.id');
		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('downloads_arquivos ar', $pagina, 'a.*'))  {
			foreach($arquivos as $a) {
				$a->arquivos = $this::getArquivosCodigo($a->codigo);
			}
			$this->totalCount = $this->db->totalCount;
			return $arquivos;
		} else {
			return false;
		}
	}

	function getDownloadsCadastro($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1, $titulo = null) {
		$this->db->join('downloads_secoes s', 'a.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if(strlen($titulo) > 2) {
			$this->db->where('a.titulo', $titulo);
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->groupBy('a.id');
		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('downloads a', $pagina, 'a.*'))  {
			foreach($arquivos as $a) {
				$a->arquivos = $this::getArquivosCodigo($a->codigo);
			}
			return $arquivos;
		} else {
			return false;
		}
	}
}

return $DOWNLOADS = new Downloads($isView);

?>