<?
class DiarioOficial extends APP {
	PRIVATE $APP;

	PUBLIC $diarios;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getDiarios();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('diariooficial_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('diariooficial_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('diariooficial_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('diariooficial_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $degenda) {
		$this->db->where('id', $ID);
		return $this->db->update('diariooficial_arquivos', $degenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('diariooficial_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('diariooficial_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('diariooficial_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('diariooficial_arquivos');
	}
	
	function getDiarios() {
		$this->db->join('diariooficial_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->diarios = $this->db->ObjectBuilder()->get('diariooficial t', 250, 't.*, g.nome as secao');
		return $this->diarios;
	}

	function getDiarioTag($TAG) {
		$this->db->join('diariooficial_secoes g', 'g.id = secao', 'LEFT');
		$this->db->where('t.tag', $TAG);
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$diariooficial = $this->db->ObjectBuilder()->get('diariooficial t', null, 't.*, g.nome as secao')[0];
		return $diariooficial;
	}

	function getDiarioID($ID) {
		$this->db->where('id', $ID);
		$diariooficial = $this->db->ObjectBuilder()->getOne('diariooficial');
		return $diariooficial;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('diariooficial'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('diariooficial', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getDiarioID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('diariooficial');
	}


	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('diariooficial'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('diariooficial', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('diariooficial_secoes');
		return $this->secoes;
	}

	function viewCategoriasArquivos($filtros = false, $ordem = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(d.data)', $filtros->ano);
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('d.entidade', $filtros->ent);
		} else {
			$this->db->where('d.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("d.titulo LIKE '%$filtros->b%'");
		}

		$this->db->join('diariooficial_secoes s', 's.id = d.secao', 'LEFT');
		$this->db->OrderBy('MONTH(d.data)', 'DESC');
		if($ordem) {
			$this->db->orderBy('d.'.$ordem->campo, $ordem->ordem);
		} else {
			$this->db->OrderBy('d.data', 'DESC');
			$this->db->OrderBy('d.titulo', 'ASC');
		}
		if ( $d = $this->db->ObjectBuilder()->get('diariooficial d', null, 'd.*, s.nome as secao_nome') ) {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getArquivosCodigo($d->codigo);
				$this->return->{date('m', strtotime($d->data))}->{$d->id} = $d;
			}
			return $this->return;
		} else {
			return null;
		}		
	}

	function getSecoesCat($cat, $filtros = false) {
		$this->db->where('MONTH(l.data)', $cat);
		$this->db->join('diariooficial_secoes c', 'l.secao = c.id', 'INNER');
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(l.data)', $filtros->ano);
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('l.entidade', $filtros->ent);
		} else {
			$this->db->where('l.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("l.titulo LIKE '%$filtros->b%'");
		}
		$this->db->groupBy('c.id');
		$m =  $this->db->ObjectBuilder()->get('diariooficial l', null, 'c.*');
		return $m;
	}

}

return $DIARIOOFICIAL = new DiarioOficial($isView);

?>