<?
class Contatos extends APP {
	PRIVATE $APP;

	PUBLIC $contatos;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getContatos();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('contatos_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ($this->db->insert('contatos_'.$tabela, $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ($this->db->delete('contatos_'.$tabela)) {
			return true;
		} else {
			return false;
		}
	}
	
	function getContatos() {
		$this->db->join('contatos_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->contatos = $this->db->ObjectBuilder()->get('contatos t', null, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->contatos;
	}

	function getContatoTag($TAG) {
		$this->db->join('contatos_secoes g', 'g.id = secao AND g.id = '.$TAG, 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$contato = $this->db->ObjectBuilder()->get('contatos t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $contato;
	}

	function getContatoID($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->getOne('contatos');
	}
	function getContatoSecao($ID) {
		$this->db->where('secao', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->getOne('contatos');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('contatos', $dados) ) {
			return $dados['secao'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getContatoID($ID);

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('contatos');
	}


	function criar($dados) {
		if ($this->db->insert('contatos', $dados)){
			return $dados['secao'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('contatos_secoes');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('contatos c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL OR c.secao = '$ID')");
		} else {
			$this->db->join('contatos c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->db->having('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('contatos_secoes s', null, 's.*');
		return $this->secoes;
	}

}

return $CONTATOS = new Contatos($isView);

?>