var crop_max_width = 800;
var crop_max_height = 600;
var jcrop_api;
var canvas;
var context;
var image;

var prefsize;

$("#file-crop").change(function() {
    
    loadImage(this);

});
// Inicializa quando carrega
$("#view-crop").change(function() { applyCrop(); })

function loadImage(input) {
  

  // LIMITA TAMANHO DO UPLOAD
  if (input.files[0].size > 4100000) {
    $toast = toastr['error']('Ela supera o limite máximo <b>(4mb)</b>. Escolha uma nova imagem para continuar', 'Esta Imagem é muito Grande!');
    return false;
  } else {

    valor = $(input).val();
    if(valor.length) {
        $('#view-crop').show();
        $('#capa').addClass('hidden');
        $('#label-crop').hide()
        $('#submit-crop').removeClass('hidden').attr('disabled', true).html('<i class="fa fa-spinner fa-pulse"></i> Carregando');
        setTimeout(function(){
          $('#submit-crop').removeAttr('disabled').html('<i class="fa fa-save"></i> Salvar');
        }, 1500);
    } else {
        if($('#capa').attr('src').length > 2) { $('#capa').removeClass('hidden') }
        $('#submit-crop').addClass('hidden');
        $('#label-crop').show()
    }
  }

  if (input.files && input.files[0]) {
    var reader = new FileReader();
    canvas = null;
    reader.onload = function(e) {
      image = new Image();
      image.onload = validateImage;
      image.src = e.target.result;
    }
    reader.readAsDataURL(input.files[0]);
  }
}

function dataURLtoBlob(dataURL) {
  var BASE64_MARKER = ';base64,';
  if (dataURL.indexOf(BASE64_MARKER) == -1) {
    var parts = dataURL.split(',');
    var contentType = parts[0].split(':')[1];
    var raw = decodeURIComponent(parts[1]);

    return new Blob([raw], {
      type: contentType
    });
  }
  var parts = dataURL.split(BASE64_MARKER);
  var contentType = parts[0].split(':')[1];
  var raw = window.atob(parts[1]);
  var rawLength = raw.length;
  var uInt8Array = new Uint8Array(rawLength);
  for (var i = 0; i < rawLength; ++i) {
    uInt8Array[i] = raw.charCodeAt(i);
  }

  return new Blob([uInt8Array], {
    type: contentType
  });
}

function validateImage() {
  if (canvas != null) {
    image = new Image();
    image.onload = restartJcrop;
    image.src = canvas.toDataURL('image/jpg');
  } else restartJcrop();
}

function restartJcrop() {
  if (jcrop_api != null) {
    jcrop_api.destroy();
  }

  $("#view-crop").empty();
  $("#view-crop").append("<canvas id=\"canvas\">");
  canvas = $("#canvas")[0];
  context = canvas.getContext("2d");
  canvas.width = image.width;
  canvas.height = image.height;
  context.drawImage(image, 0, 0);
  $("#canvas").Jcrop({
    onSelect: selectcanvas,
    onChange: selectcanvas,
    onRelease: clearcanvas,
    boxWidth: crop_max_width,
    boxHeight: crop_max_height,
    aspectRatio: 192/40,
    setSelect: [0, 0, 1920, 400],
  }, function() {
    jcrop_api = this;
  });
  clearcanvas();
}

function clearcanvas() {
  prefsize = {
    x: 0,
    y: 0,
    w: canvas.width,
    h: canvas.height,
  };
}

function selectcanvas(coords) {
  prefsize = {
    x: Math.round(coords.x),
    y: Math.round(coords.y),
    w: Math.round(coords.w),
    h: Math.round(coords.h)
  };
  $('#crop-x').attr('value', prefsize.x);
  $('#crop-y').attr('value', prefsize.y);
  $('#crop-w').attr('value', prefsize.w);
  $('#crop-h').attr('value', prefsize.h);
}

function applyCrop() {
  canvas.width = prefsize.w;
  canvas.height = prefsize.h;
  context.drawImage(image, prefsize.x, prefsize.y, prefsize.w, prefsize.h, 0, 0, canvas.width, canvas.height);
  validateImage();
}

$("#form-crop").submit(function(e) {
  e.preventDefault();
  formData = new FormData($(this)[0]);
  var blob = dataURLtoBlob(canvas.toDataURL('image/jpg'));
  //---Add file blob to the form data
  formData.append("cropped_image", blob);

  $.ajax({
    url: $(this).attr('action'),
    type: "POST",
    data: formData,
    dataType: "json",
    contentType: false,
    cache: false,
    processData: false,
    success: function(data) {
      retornoAjax(data);
      if(data.success == true) {
        $('#capa').removeClass('hidden');
        $('#capa-img').hide();
        $('#label-crop').html('Carregar nova imagem').show();
        $('#submit-crop').addClass('hidden');
        $('#label-crop').removeClass('hidden');
        $('#view-crop').hide();
      }
    },
    error: function(data) {
      $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
    },
  });
});