var TableDatatablesEditable = function () {

    var handleTable = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('ID');
            if(ID) {
                secoes = secao[ID];
            } else {
                secoes = secaoGeral;
            }
            jqTds[0].innerHTML = '<select required name="secao" maxlength="50" class="form-control select2">' + secoes + '</select>';
            jqTds[1].innerHTML = '<input type="text" required name="titulo" maxlength="100" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<div class="text-center font-s13"></div>';
            jqTds[3].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[4].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
            mascaras();
            select2();
        }

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 3, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 4, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao,
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('ID', data.ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                        oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 3, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 4, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });

        }

        /*
        function inverteData(alvo, toBR = false) {
            if(toBR) {
                alvo = $(alvo).val();
                var d = alvo.split("-");
                volta = d[2]+'/'+d[1]+'/'+d[0];
                return volta;
            } else {
                var d = alvo.split("/");
                volta = d[2]+'-'+d[1]+'-'+d[0]
                return volta;
            }
        }
        */

        var table = $('#sample_editable_1');


        var oTable = table.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'copy',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'pdf',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'excel',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'csv',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                //'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "asc"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#sample_editable_1_wrapper");

        var nEditing = null;
        var nNew = false;

        $('#sample_editable_1_new').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        table.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('ID');

            swal({
                title: "Tem certeza que deseja excluir este carrossel?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });
        });

        table.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        table.on('click', '.edit', function (e) {
            $('#controle-ajax').attr('acao', 'editar');
            e.preventDefault();
            nNew = false;

            var ID = $(this).closest('tr').attr('ID');

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });

        table.on('click', '[status]', function (e) {
            e.preventDefault();
            var action = $('#controle-ajax').attr('action');
            var tipo = $(this).attr('tipo');
            var ID = $(this).attr('status');
            var secao = $(this).attr('secao');
            var btn = $(this)
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: 'ID='+ID+'&tipo='+tipo+'&acao=status',
                success: function( data ) {
                    retornoAjax(data);
                    if (data.success == true) {
                        $('[status][btninativo][secao='+secao+']').show();
                        $('[status][btnativo][secao='+secao+']').hide();
                        if(data.acao == 0) {
                            $('[btninativo='+ID+']').show();
                            $('[btnativo='+ID+']').hide();
                        } else if (data.acao == 1) {
                            $('[btninativo='+ID+']').hide();
                            $('[btnativo='+ID+']').show();
                        }
                    }
                },
                error: function( data ) {
                    console.log(data)
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });            
        });
    }

    var DatetimePicker = function () {
        if (!$().datetimepicker) { return false; }

        $(".form_datetime").datetimepicker({
            autoclose: true,
            isRTL: App.isRTL(),
            format: "dd MM yyyy - hh:ii",
            fontAwesome: true,
            pickerPosition: (App.isRTL() ? "bottom-right" : "bottom-left")
        });
    }

    return {

        //main function to initiate the module
        init: function () {
            handleTable();
            DatetimePicker();
        }

    };

}();
jQuery(document).ready(function() {
    TableDatatablesEditable.init();
});

function mascaras() {
    $(".data").inputmask("d/m/y", {
        placeHolder: '_ ',
        keepStatic: true
    });
    $(".hora").inputmask("99:99", {
        placeHolder: '_ ',
        keepStatic: true
    });
}

function select2() {
    $.fn.select2.defaults.set("theme", "bootstrap");
    $.fn.select2.defaults.set('language', 'pt-BR');
    $(".select2").select2({
        selectOnClose: true,
        placeholder: 'Selecione ou digite uma seção',
        selectOnBlur: true,
        tags: true,

    });
} select2();