<?
class Blocos extends APP {
	PRIVATE $APP;

	PUBLIC $blocos;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getBlocos();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('blocos_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('blocos_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('blocos_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function getBlocos() {
		$this->db->join('blocos_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->blocos = $this->db->ObjectBuilder()->get('blocos t', null, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->blocos;
	}

	function getBlocoID($ID) {
		$this->db->where('g.id', $ID);
		$this->db->join('blocos_secoes g', 'g.id = t.secao', 'INNER');
		$bloco = $this->db->ObjectBuilder()->get('blocos t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $bloco;
	}

	function getBlocoSecao($ID, $_entidade = false) {
		$this->db->where('g.nome', $ID);
		$this->db->join('blocos_secoes g', 'g.id = t.secao', 'INNER');
		if($_entidade) {
			$this->db->where('t.entidade', $_entidade);
		} else if($this->entidade->id)  {
			$this->db->where('t.entidade', $this->entidade->id);
		} else {
			$this->db->where('t.entidade', $this->_auth->entidade->id);
		}
		$bloco = $this->db->ObjectBuilder()->get('blocos t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $bloco;
	}
	
	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('blocos', $dados) ) {
			return $dados['secao'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getBlocoID($ID);

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('blocos');
	}


	function criar($dados) {
		if ($this->db->insert('blocos', $dados)){
			return $dados['secao'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('blocos_secoes');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('blocos c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL OR c.secao = '$ID')");
		} else {
			$this->db->join('blocos c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->having('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('blocos_secoes s', null, 's.*');
		return $this->secoes;
	}

}

return $BLOCOS = new Blocos($isView);

?>