<?
class Audios extends APP {
	PRIVATE $APP;

	PUBLIC $galerias;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getAudios();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('audios_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('audios_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('audios_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getAudios() {
		$this->db->join('audios_secoes s', 's.id = a.secao', 'LEFT');
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->audios = $this->db->ObjectBuilder()->get('audios a', null, 'a.*, s.nome as secao, s.id as secao_id');
		return $this->audios;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('audios_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('audios_arquivos');
	}

	function getArquivos($id) {
		$this->db->where('audio', $id);
		return $this->db->ObjectBuilder()->get('audios_arquivos');
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('audios_arquivos', $legenda);
	}


	function getAudio($ID) {
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('id', $ID);
		$audio = $this->db->ObjectBuilder()->getOne('audios');
		return $audio;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('audios', $dados);
	}

	function excluir($ID) {
		if ($A = $this::getArquivos($ID)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('audios');
	}

	function adicionar($dados) {
		if ($this->db->insert('audios', $dados)){
			return $this->db->getInsertId();
		} else {
			return false;
		}
	}

    function getSecoes($check = false, $filtros = false) {
        if($check) {
            $this->db->join('audios a', 'a.secao = s.id', 'INNER');
        } 

        if (is_object($filtros) && isset($filtros->ent)) {
            $this->db->where('s.entidade', $filtros->ent);
        } else {
            $this->db->where('s.entidade', $this->_auth->entidade->id);
        }

        $this->db->OrderBy('s.nome', 'ASC');
        $this->db->groupBy('s.nome');
        $this->secoes = $this->db->ObjectBuilder()->get('audios_secoes s', null, 's.*');

        return $this->secoes;
    }

	
	function viewCategoriasArquivos($filtros = false) {
		$this->db->join('audios_secoes s', 's.id = a.secao', 'LEFT');
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('a.entidade', $filtros->ent);
		} else {
			$this->db->where('a.entidade', $this->_auth->entidade->id);
		}
		# SEÇÃO
		if($filtros->s) {
			$this->db->where("s.nome", $filtros->s);
		}

		$this->db->OrderBy('a.data', 'DESC');
		$this->db->OrderBy('a.titulo', 'ASC');
		if ( $d = $this->db->ObjectBuilder()->get('audios a', null, 'a.*, s.nome as secao, s.id as secao_id') ) {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getArquivos($d->id);
				$this->return[$d->id] = $d;
			};
			return $this->return;
		} else {
			return null;
		}
	}

	function getAudiosNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('audios_secoes s', 's.id = a.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->pageLimit = $limitador;
        if ($d = $this->db->ObjectBuilder()->paginate('audios a', $pagina, 'a.*, s.nome as secao, s.id as secao_id'))  {
            $this->return = [];  // <<< inicializa como array
            foreach($d as $item) {   // evita sobrescrever $d
                $item->{'arquivos'} = $this::getArquivos($item->id);
                $this->return[$item->id] = $item;
            }
            return $this->return;
        } else {
            return [];
        }

	}
}

return $AUDIOS = new Audios($isView);

?>