<?php
class Notificacoes extends APP {
    private $APP;

    public $tokens;

    function __construct($isView = false) {
        if ($isView) { $this->isView = true; }
        parent::__construct($isView);
    }

    // Salva ou atualiza um token de dispositivo
    function saveToken($token, $entidade) {
        $this->db->where('token', $token);
        $existe = $this->db->getOne('notificacoes_tokens');

        $dados = [
            'token' => $token,
            'entidade' => $entidade,
            'data' => date('Y-m-d H:i:s')
        ];

        if ($existe) {
            $this->db->where('id', $existe->id);
            $this->db->update('notificacoes_tokens', $dados);
            return $existe->id;
        } else {
            $this->db->insert('notificacoes_tokens', $dados);
            return $this->db->getInsertId();
        }
    }

    // Retorna todos os tokens
    function getTokens() {
        $this->tokens = $this->db->ObjectBuilder()->get('notificacoes_tokens');
        return $this->tokens;
    }

    // Envia notificação (apenas simulação por enquanto)
    function sendNotification($titulo, $mensagem) {
        $tokens = $this::getTokens();
        foreach ($tokens as $t) {
            // Aqui futuramente você envia via webpush
            $log[] = "Enviado para {$t->token}: {$titulo} - {$mensagem}";
        }
        return $log ?? ['Nenhum token encontrado'];
    }
}

return $NOTIFICACOES = new Notificacoes($isView);
?>
