<?
class Agenda extends APP {
	PRIVATE $APP;

	PUBLIC $agendas;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getAgendas();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('agenda_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('agenda_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('agenda_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('agenda_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $degenda) {
		$this->db->where('id', $ID);
		return $this->db->update('agenda_arquivos', $degenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('agenda_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('agenda_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('agenda_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('agenda_arquivos');
	}
	
	function getAgendas() {
		$this->db->join('agenda_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->agendas = $this->db->ObjectBuilder()->get('agenda t', null, 't.*, g.nome as secao');
		return $this->agendas;
	}

	function getAgendaTag($TAG) {
		$this->db->join('agenda_secoes g', 'g.id = secao', 'LEFT');
		$this->db->where('t.tag', $TAG);
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$agenda = $this->db->ObjectBuilder()->get('agenda t', null, 't.*, g.nome as secao')[0];
		return $agenda;
	}

	function getAgendaID($ID) {
		$this->db->where('id', $ID);
		$agenda = $this->db->ObjectBuilder()->getOne('agenda');
		return $agenda;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('agenda'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('agenda', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getAgendaID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('agenda');
	}


	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('agenda'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('agenda', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('agenda a', 'a.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('agenda_secoes s', null, 's.*');
		return $this->secoes;
	}

	function viewCategoriasArquivos($filtros = false) {
		# ENTIDADE
		if ($filtros->ent) {
			$this->db->where('d.entidade', $filtros->ent);
		} else {
			$this->db->where('d.entidade', $this->_auth->entidade->id);
		}
		# SEÇÃO
		if($filtros->s) {
			$this->db->where("s.nome", $filtros->s);
		}

		$meses = array('01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril', '05' => 'Maio', '06' => 'Junho', '07' => 'Julho', '08' => 'Agosto', '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro',);

		$this->db->join('agenda_secoes s', 's.id = d.secao', 'LEFT');
		$this->db->OrderBy('d.data', 'DESC');
		$this->db->OrderBy('d.titulo', 'ASC');
		if ( $d = $this->db->ObjectBuilder()->get('agenda d', null, 'd.*, s.nome as secao_nome') ) {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getArquivosCodigo($d->codigo);
				$mes = $meses[date('m', strtotime($d->data))];
				$this->return->{$d->id} = $d;
			};
			return $this->return;
		} else {
			return null;
		}		
	}

	function getSecoesCat($cat, $filtros = false) {
		$this->db->where('MONTH(l.data)', $cat);
		$this->db->join('agenda_secoes c', 'l.secao = c.id', 'INNER');
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('l.entidade', $filtros->ent);
		} else {
			$this->db->where('l.entidade', $this->_auth->entidade->id);
		}
		$this->db->groupBy('c.id');
		$m =  $this->db->ObjectBuilder()->get('agenda l', null, 'c.*');
		return $m;
	}

	function getAgendaNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('agenda_secoes s', 'a.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->pageLimit = $limitador;
		if ($agendas = $this->db->ObjectBuilder()->paginate('agenda a', $pagina, 'a.*, s.nome as secao'))  {
			$this->return = false;
			$this->totalCount = $this->db->totalCount;
			$meses = array('01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril', '05' => 'Maio', '06' => 'Junho', '07' => 'Julho', '08' => 'Agosto', '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro',);
			foreach($agendas as $d) {
				$d->{'arquivos'} = $this::getArquivosCodigo($d->codigo);
				$mes = $meses[date('m', strtotime($d->data))];
				$this->return->{$d->id} = $d;
			};
			return $this->return;
		} else {
			return false;
		}
	}

}

return $AGENDA = new Agenda($isView);

?>