<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * The "versions" collection of methods.
 * Typical usage is:
 *  <code>
 *   $dialogflowService = new Google_Service_Dialogflow(...);
 *   $versions = $dialogflowService->versions;
 *  </code>
 */
class Google_Service_Dialogflow_Resource_ProjectsLocationsAgentsFlowsVersions extends Google_Service_Resource
{
  /**
   * Creates a Version in the specified Flow. (versions.create)
   *
   * @param string $parent Required. The Flow to create an Version for. Format:
   * `projects//locations//agents//flows/`.
   * @param Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_Dialogflow_GoogleLongrunningOperation
   */
  public function create($parent, Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version $postBody, $optParams = array())
  {
    $params = array('parent' => $parent, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('create', array($params), "Google_Service_Dialogflow_GoogleLongrunningOperation");
  }
  /**
   * Deletes the specified Version. (versions.delete)
   *
   * @param string $name Required. The name of the Version to delete. Format:
   * `projects//locations//agents//flows//versions/`.
   * @param array $optParams Optional parameters.
   * @return Google_Service_Dialogflow_GoogleProtobufEmpty
   */
  public function delete($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('delete', array($params), "Google_Service_Dialogflow_GoogleProtobufEmpty");
  }
  /**
   * Retrieves the specified Version. (versions.get)
   *
   * @param string $name Required. The name of the Version. Format:
   * `projects//locations//agents//flows//versions/`.
   * @param array $optParams Optional parameters.
   * @return Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version
   */
  public function get($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('get', array($params), "Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version");
  }
  /**
   * Returns the list of all versions in the specified Flow.
   * (versions.listProjectsLocationsAgentsFlowsVersions)
   *
   * @param string $parent Required. The Flow to list all versions for. Format:
   * `projects//locations//agents//flows/`.
   * @param array $optParams Optional parameters.
   *
   * @opt_param int pageSize The maximum number of items to return in a single
   * page. By default 20 and at most 100.
   * @opt_param string pageToken The next_page_token value returned from a
   * previous list request.
   * @return Google_Service_Dialogflow_GoogleCloudDialogflowCxV3ListVersionsResponse
   */
  public function listProjectsLocationsAgentsFlowsVersions($parent, $optParams = array())
  {
    $params = array('parent' => $parent);
    $params = array_merge($params, $optParams);
    return $this->call('list', array($params), "Google_Service_Dialogflow_GoogleCloudDialogflowCxV3ListVersionsResponse");
  }
  /**
   * Loads resources in the specified version to the draft flow. (versions.load)
   *
   * @param string $name Required. The Version to be loaded to draft flow. Format:
   * `projects//locations//agents//flows//versions/`.
   * @param Google_Service_Dialogflow_GoogleCloudDialogflowCxV3LoadVersionRequest $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_Dialogflow_GoogleLongrunningOperation
   */
  public function load($name, Google_Service_Dialogflow_GoogleCloudDialogflowCxV3LoadVersionRequest $postBody, $optParams = array())
  {
    $params = array('name' => $name, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('load', array($params), "Google_Service_Dialogflow_GoogleLongrunningOperation");
  }
  /**
   * Updates the specified Version. (versions.patch)
   *
   * @param string $name Format: projects//locations//agents//flows//versions/.
   * Version ID is a self-increasing number generated by Dialogflow upon version
   * creation.
   * @param Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string updateMask Required. The mask to control which fields get
   * updated. Currently only `description` and `display_name` can be updated.
   * @return Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version
   */
  public function patch($name, Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version $postBody, $optParams = array())
  {
    $params = array('name' => $name, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('patch', array($params), "Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version");
  }
}
