<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <title>Editor de Gradientes - Mestre</title>
  <style>
    body {
      margin: 0;
      background: #111;
      color: white;
      font-family: sans-serif;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .carousel-overlay {
      width: 100%;
      max-width: 1920px;
      height: 700px;
      background-size: cover;
      background-position: top center;
      background-repeat: no-repeat;
      background-image: url('img-banner.jpg');
      position: relative;
      margin-top: 20px;
      border: none;
    }

    .painel {
      width: 100%;
      max-width: 1400px;
      background: #222;
      padding: 20px;
      box-sizing: border-box;
      display: flex;
      flex-direction: column;
      gap: 30px;
      margin: 0 auto;
    }

    .bloco {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 40px;
    }

    label {
      font-size: 14px;
      display: flex;
      flex-direction: column;
      gap: 5px;
    }

    input[type="color"],
    input[type="range"],
    select {
      width: 100%;
      padding: 5px;
      border-radius: 4px;
      border: none;
      outline: none;
    }

    h3 {
      margin: 0 0 10px 0;
      border-bottom: 1px solid #444;
      padding-bottom: 5px;
    }
  </style>
</head>
<body>

  <div class="carousel-overlay" id="banner"></div>

  <div class="painel">

    <div class="bloco">
      <label>Radial 1 Posição X
        <input type="range" id="r1x" min="0" max="100" value="35" />
      </label>
      <label>Radial 1 Posição Y
        <input type="range" id="r1y" min="0" max="100" value="80" />
      </label>
      <label>Radial 1 Cor
        <input type="color" id="r1color" value="#0055ff" />
      </label>
      <label>Radial 1 Opacidade
        <input type="range" id="r1opacity" min="0" max="1" step="0.01" value="0.8" />
      </label>
      <label>Radial 1 Alcance (%)
        <input type="range" id="r1stop" min="1" max="100" value="40" />
      </label>
    </div>


    <div class="bloco">
      <label>Radial 2 Posição X
        <input type="range" id="r2x" min="0" max="100" value="85" />
      </label>
      <label>Radial 2 Posição Y
        <input type="range" id="r2y" min="0" max="100" value="100" />
      </label>
      <label>Radial 2 Cor
        <input type="color" id="r2color" value="#0055ff" />
      </label>
      <label>Radial 2 Opacidade
        <input type="range" id="r2opacity" min="0" max="1" step="0.01" value="0.8" />
      </label>
      <label>Radial 2 Alcance (%)
        <input type="range" id="r2stop" min="1" max="100" value="40" />
      </label>
    </div>


    <div>
      <div class="bloco">
        <label>Forma
          <select id="shape">
            <option value="circle">Circle</option>
            <option value="ellipse">Ellipse</option>
          </select>
        </label>
        <label>Direção
          <select id="linearDirection">
            <option value="to bottom">To bottom</option>
            <option value="to top">To top</option>
            <option value="to left">To left</option>
            <option value="to right">To right</option>
          </select>
        </label>
        <label>Cor
          <input type="color" id="linearColor" value="#000000" />
        </label>
        <label>Opacidade
          <input type="range" id="linearOpacity" min="0" max="1" step="0.01" value="0.9" />
        </label>
        <label>Stop (%)
          <input type="range" id="linearStop" min="0" max="100" value="40" />
        </label>
      </div>
    </div>

  </div>

<script>
function atualizarBackground() {
  const shape = document.getElementById('shape').value;
  const r1x = document.getElementById('r1x').value;
  const r1y = document.getElementById('r1y').value;
  const r1color = document.getElementById('r1color').value;
  const r1opacity = document.getElementById('r1opacity').value;
  const r1stop = document.getElementById('r1stop').value;

  const r2x = document.getElementById('r2x').value;
  const r2y = document.getElementById('r2y').value;
  const r2color = document.getElementById('r2color').value;
  const r2opacity = document.getElementById('r2opacity').value;
  const r2stop = document.getElementById('r2stop').value;

  const linearDir = document.getElementById('linearDirection').value;
  const linearColor = document.getElementById('linearColor').value;
  const linearOpacity = document.getElementById('linearOpacity').value;
  const linearStop = document.getElementById('linearStop').value;

  const radial1 = `radial-gradient(${shape} at ${r1x}% ${r1y}%, rgba(${hexToRgb(r1color)}, ${r1opacity}) 0%, transparent ${r1stop}%)`;
  const radial2 = `radial-gradient(${shape} at ${r2x}% ${r2y}%, rgba(${hexToRgb(r2color)}, ${r2opacity}) 0%, transparent ${r2stop}%)`;
  const linear = `linear-gradient(${linearDir}, rgba(0, 0, 0, 0) 0%, rgba(${hexToRgb(linearColor)}, ${linearOpacity}) ${linearStop}%)`;

  document.getElementById('banner').style.backgroundImage = `${radial1}, ${radial2}, ${linear}, url('img-banner.jpg')`;
}

function hexToRgb(hex) {
  const bigint = parseInt(hex.replace("#", ""), 16);
  const r = (bigint >> 16) & 255;
  const g = (bigint >> 8) & 255;
  const b = bigint & 255;
  return `${r}, ${g}, ${b}`;
}

document.querySelectorAll("input, select").forEach(el => {
  el.addEventListener("input", atualizarBackground);
});

atualizarBackground();
</script>

</body>
</html>
