const SW_VERSION = 'v9'; // muda sempre que houver atualização
const CACHE_NAME = `jp-cache-${SW_VERSION}`;
const FILES_TO_CACHE = [
  '/notificacoes/index.php',
  '/notificacoes/manifest.json?v=9',
  '/notificacoes/img_icon_192.png',
  '/notificacoes/img_icon_512.png',
  // outros arquivos essenciais
];

// Instala e cacheia arquivos
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(FILES_TO_CACHE))
  );
  self.skipWaiting();
});

// Ativa e limpa caches antigos
self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(keys => {
      return Promise.all(
        keys.filter(key => key !== CACHE_NAME).map(key => caches.delete(key))
      );
    })
  );
  self.clients.claim();
});

// Intercepta fetch: serve do cache ou da rede
self.addEventListener('fetch', event => {
  event.respondWith(
    caches.match(event.request).then(response => {
      return response || fetch(event.request);
    })
  );
});

// Recebe push notifications
self.addEventListener('push', event => {
  const data = event.data?.json() || { title: 'Notificação', body: '' };
  event.waitUntil(
    self.registration.showNotification(data.title, {
      body: data.body,
      icon: '/notificacoes/img_icon_192.png',
      badge: '/notificacoes/img_icon_192.png'
    })
  );
});
