const CACHE_NAME = 'jp-cache-v1'; // incrementa quando houver atualização
const FILES_TO_CACHE = [
  '/notificacoes/index.php',
  '/notificacoes/manifest.json',
  '/notificacoes/img_icon_192.png',
  '/notificacoes/img_icon_512.png',
  '/notificacoes/imagens/hero.jpg',
  '/notificacoes/register.js'
];

// Instalando SW e cacheando arquivos
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(FILES_TO_CACHE))
  );
  self.skipWaiting();
});

// Ativando SW e removendo caches antigos
self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(keys =>
      Promise.all(keys.filter(key => key !== CACHE_NAME).map(key => caches.delete(key)))
    )
  );
  self.clients.claim();
});

// Intercepta fetch: serve do cache ou da rede
self.addEventListener('fetch', event => {
  event.respondWith(
    caches.match(event.request).then(response => response || fetch(event.request))
  );
});

// Recebe push notifications
self.addEventListener('push', event => {
  const data = event.data?.json() || { title: 'Notificação', body: '' };
  event.waitUntil(
    self.registration.showNotification(data.title, {
      body: data.body,
      icon: '/notificacoes/img_icon_192.png',
      badge: '/notificacoes/img_icon_192.png'
    })
  );
});
