<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Aplicativo da Prefeitura</title>
<link rel="manifest" href="/notificacoes/manifest.json">
<link rel="icon" sizes="192x192" href="/notificacoes/img_icon_192.png">
<link rel="icon" sizes="512x512" href="/notificacoes/img_icon_512.png">
<meta name="theme-color" content="#0078ff">

<style>
html, body {margin:0; padding:0; height:100%; font-family: Arial, sans-serif;}
.hero { display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center; height: 100vh; background-image: url('/notificacoes/imagens/hero.jpg'); background-size: cover; background-position: center; color: #fff}
button { padding: 12px 20px; border: none; border-radius: 8px; background: #0078ff; color: #fff; font-size: 16px; cursor: pointer; margin: 8px 0; }
button:hover { background: #005fcc; }
</style>
</head>
<body>
<div class="hero">
  <h1>📱 Aplicativo da Prefeitura</h1>
  <p>Instale este app na tela inicial para acessar rapidamente.</p>

  <button id="installButton" hidden>Instalar App</button>
  <button id="openSiteButton">Abrir Site</button>
  <button id="btnEnablePush">Ativar Notificações</button>
</div>

<script src="/notificacoes/register.js" defer></script>

<script>
// ===================== PWA & SW =====================
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('/notificacoes/sw.js')
    .then(() => console.log('✅ SW registrado e ativo'))
    .catch(err => console.error('❌ Erro ao registrar SW', err));
}

// ===================== DOM e instalação =====================
document.addEventListener('DOMContentLoaded', () => {
  let deferredPrompt;
  const installButton = document.getElementById('installButton');
  const openSiteButton = document.getElementById('openSiteButton');
  const btnEnablePush = document.getElementById('btnEnablePush');

  window.addEventListener('beforeinstallprompt', e => {
    e.preventDefault();
    deferredPrompt = e;
    installButton.hidden = false;
  });

  if (installButton) {
    installButton.addEventListener('click', async () => {
      installButton.hidden = true;
      if (!deferredPrompt) return;
      deferredPrompt.prompt();
      deferredPrompt = null;
    });
  }

  if (openSiteButton) {
    openSiteButton.addEventListener('click', () => {
      window.location.href = '/web/index.php';
    });
  }

  if (btnEnablePush) {
    btnEnablePush.addEventListener('click', async () => {
      if (!('serviceWorker' in navigator) || !('PushManager' in window)) return;

      try {
        const registration = await navigator.serviceWorker.register('/notificacoes/sw.js');
        const permission = await Notification.requestPermission();
        if (permission !== 'granted') return;

        const vapidPublicKey = 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A';
        const subscription = await registration.pushManager.subscribe({
          userVisibleOnly: true,
          applicationServerKey: urlBase64ToUint8Array(vapidPublicKey)
        });

        await fetch('/notificacoes/save_token.php', {
          method: 'POST',
          headers: {'Content-Type': 'application/json'},
          body: JSON.stringify(subscription)
        });

        btnEnablePush.textContent = 'Notificações Ativadas ✅';
        btnEnablePush.disabled = true;

      } catch (err) {
        console.error('❌ Erro ao ativar notificações:', err);
      }
    });
  }

  function urlBase64ToUint8Array(base64String) {
    const padding = '='.repeat((4 - base64String.length % 4) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
    const rawData = atob(base64);
    return Uint8Array.from([...rawData].map(c => c.charCodeAt(0)));
  }
});
</script>
</body>
</html>
