<?php
require 'vendor/autoload.php'; // Minishlink/WebPush

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Mostrar todos os erros PHP
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Conexão MySQL
$mysqli = new mysqli('localhost', 'jpwebapp_prefeitura', 'JWIR0365#@pPzyUkPR', 'jpwebapp_prefeituras');
if ($mysqli->connect_error) {
    die("❌ Falha na conexão: " . $mysqli->connect_error . "\n");
}
echo "✅ Conexão MySQL OK\n";

// Pega todos os tokens
$result = $mysqli->query("SELECT * FROM notificacoes_tokens");
if (!$result->num_rows) {
    die("❌ Nenhum token encontrado no banco.\n");
}

$tokens = [];
while($row = $result->fetch_assoc()) {
    $tokens[] = $row;
}
echo "✅ Tokens encontrados: ".count($tokens)."\n";

// Suas chaves VAPID
$auth = [
    'VAPID' => [
        'subject' => 'mailto:jpweb@jpweb.com.br',
        'publicKey' => 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A',
        'privateKey' => 'l6eT5A3fSKKFkvq4U0XWN3H2pBoBPfq01-mUy7QhFZ0'
    ],
];

$webPush = new WebPush($auth);

// Payload da notificação
$payload = json_encode([
    'title' => '🔥 Mestre, Notificação Chegou!',
    'body'  => 'Aqui está um teste completo com título, corpo, link e imagem!',
    'icon'  => 'https://jpweb.app.br/imagens/logo.png',
    'image' => 'https://jpweb.app.br/imagens/banner.jpg',
    'url'   => 'https://jpweb.app.br/'
]);

echo "📡 Iniciando envio do payload...\n";

// Enviar para todos os tokens
foreach ($tokens as $token) {
    echo "\n📌 Preparando token:\n";
    echo "Endpoint: ".$token['endpoint']."\n";
    echo "p256dh: ".$token['p256dh']."\n";
    echo "auth: ".$token['auth']."\n";

    $subscription = Subscription::create([
        'endpoint' => $token['endpoint'],
        'keys' => [
            'p256dh' => $token['p256dh'],
            'auth' => $token['auth']
        ]
    ]);

    echo "📡 Enviando payload para este token...\n";
    $report = $webPush->sendOneNotification($subscription, $payload);

    if ($report->isSuccess()) {
        echo "✅ Notificação enviada com sucesso!\n";
    } else {
        echo "❌ Falha ao enviar notificação:\n";
        echo "Endpoint: ".$report->getEndpoint()."\n";
        echo "Razão: ".$report->getReason()."\n";
    }
}

echo "\n🏁 Envio finalizado.\n";
