<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Meu App PWA</title>
<link rel="manifest" href="/notificacoes/manifest.json?v=8">
<link rel="icon" sizes="192x192" href="/notificacoes/img_icon_192.png">
<link rel="icon" sizes="512x512" href="/notificacoes/img_icon_512.png">
<meta name="theme-color" content="#0078ff">
<script>
  if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/notificacoes/sw.js?v=8')
      .then(() => console.log('✅ SW atualizado e registrado'))
      .catch(err => console.error('❌ Erro ao registrar SW', err));
  }
</script>
<style>
body {
  font-family: Arial, sans-serif;
  background: #f2f2f2;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  height: 100vh;
  text-align: center;
  margin: 0;
}
button {
  padding: 12px 20px;
  border: none;
  border-radius: 8px;
  background: #0078ff;
  color: #fff;
  font-size: 16px;
  cursor: pointer;
  margin: 8px 0;
}
button:hover { background: #005fcc; }
</style>
</head>
<body>

<h1>📱 Meu App PWA</h1>
<p>Instale este app na tela inicial para acessar rapidamente.</p>

<!-- Botões -->
<button id="installButton" hidden>Instalar App</button>
<button id="openSiteButton">Abrir Site</button>
<button id="btnEnablePush">Ativar Notificações</button>

<script>
// Espera o DOM carregar
document.addEventListener('DOMContentLoaded', () => {

  let deferredPrompt;
  const installButton = document.getElementById('installButton');
  const openSiteButton = document.getElementById('openSiteButton');
  const btnEnablePush = document.getElementById('btnEnablePush');

  // Evento de instalação do PWA
  window.addEventListener('beforeinstallprompt', e => {
    e.preventDefault();
    deferredPrompt = e;
    installButton.hidden = false;
  });

  // Botão instalar
  if (installButton) {
    installButton.addEventListener('click', async () => {
      installButton.hidden = true;
      if (!deferredPrompt) return;
      deferredPrompt.prompt();
      const { outcome } = await deferredPrompt.userChoice;
      console.log('Instalação:', outcome);
      deferredPrompt = null;
    });
  }

  // Botão abrir site
  if (openSiteButton) {
    openSiteButton.addEventListener('click', () => {
      window.location.href = '/web/index.php';
    });
  }

  // Botão ativar notificações
  if (btnEnablePush) {
    btnEnablePush.addEventListener('click', async () => {
      if (!('serviceWorker' in navigator) || !('PushManager' in window)) {
        console.warn('Navegador não suporta PWA Push');
        return;
      }

      try {
        // Registrar SW
        const registration = await navigator.serviceWorker.register('/sw.js?v=5');
        console.log('✅ Service Worker registrado.');

        // Permissão
        const permission = await Notification.requestPermission();
        if (permission !== 'granted') {
          console.warn('⚠️ Permissão de notificação negada.');
          return;
        }

        // Subscription
        const vapidPublicKey = 'BJBGCVUQp28727mD6UkncQ4v0hXngLMa1Tn8ksS8VnLHyfOS3n3QdqzUd6QoysjKmKnQl-gtFwit5h6rIZeGi5A';
        const subscription = await registration.pushManager.subscribe({
          userVisibleOnly: true,
          applicationServerKey: urlBase64ToUint8Array(vapidPublicKey)
        });

        console.log('📡 Subscription a enviar:', subscription);

        const res = await fetch('/notificacoes/save_token.php', {
          method: 'POST',
          headers: {'Content-Type': 'application/json'},
          body: JSON.stringify(subscription)
        });

        const result = await res.json();
        console.log('🔹 Token salvo:', result);

        // Feedback visual
        btnEnablePush.textContent = 'Notificações Ativadas ✅';
        btnEnablePush.disabled = true;

      } catch (err) {
        console.error('❌ Erro ao ativar notificações:', err);
      }
    });
  }

  // Função auxiliar
  function urlBase64ToUint8Array(base64String) {
    const padding = '='.repeat((4 - base64String.length % 4) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
    const rawData = atob(base64);
    const outputArray = new Uint8Array(rawData.length);
    for (let i = 0; i < rawData.length; ++i)
      outputArray[i] = rawData.charCodeAt(i);
    return outputArray;
  }

});

</script>

<script src="/notificacoes/register.js" defer></script>

</body>
</html>
