<style>
#nav              { background:transparent; color:#fff; position:relative; margin:auto; }
#nav ul           { list-style:none; margin:0; padding:0; display:flex; flex-wrap:wrap; align-items:center; }
#nav li           { position:relative; }
#nav a            { text-decoration:none; color:#fff; padding:10px 15px; display:block; white-space:nowrap; }
.menu-item:hover  { background:#002244; }
.dropdown         { display:none; position:absolute; left:0; right:0; top:65px; background:#fff; box-shadow:0 4px 8px rgba(0,0,0,0.2); z-index:9999; }
.dropdown .dropdown-content {
  position:absolute; top:30px; left:0; right:0; background:#f9f9f9; border-radius:6px;
  z-index:1000; overflow:hidden; max-width:1350px; margin:0 auto;
  display:flex !important; flex-wrap:wrap; gap:40px; padding:20px 20px;}
.dropdown .dropdown-content a { color:#003366; margin-bottom:10px; }
.dropdown .dropdown-content a:hover { text-decoration:underline; }
.dropdown .dropdown-content > * { flex: 1 1 200px; min-width: 200px; }
</style>

<div class="content">
  <nav id="nav">
    <ul>
      <li><a href="#" class="menu-item" data-dropdown="dropdown1">TRANSPARÊNCIA</a></li>
      <li><a href="#" class="menu-item" data-dropdown="dropdown2">CONTATOS</a></li>
      <li><a href="#" class="menu-item" data-dropdown="dropdown3">SERVIÇOS</a></li>
      <li><a href="#" class="menu-item" data-dropdown="dropdown4">MÍDIAS</a></li>
      <li><a href="#" class="menu-item" data-dropdown="dropdown5">GOVERNO</a></li>
    </ul>
  </nav>

  <!-- DROPDOWNS DENTRO DO .content -->
  <div class="dropwrap">
    <div id="dropdown1" class="dropdown">
      <div class="dropdown-content animated fadeInDown">
        <style>
          .colgrupo { flex: 1 1 220px; min-width: 200px; }
          .colgrupo .asidebarcol-tta { font-weight: bold; margin-bottom: 10px; }
          .colgrupo a { display: block; margin-bottom: 6px; color: #003366; text-decoration: none; }
          .colgrupo a:hover { text-decoration: underline; }
        </style>

        <?php
        $ent = $_GET['ent'] ?? false;
        if(!$TRANSPARENCIA) { $TRANSPARENCIA = $APP->startApp('transparencia'); }
        $filtros = (object) array('ent' => $entidadeMatriz, 'aside' => true);
        $lista = $TRANSPARENCIA->viewMenusGruposArquivos($filtros);
        $Y = date('Y');
        foreach($lista['Portal da Transparência'] as $g => $item) { ?>
          <div class="colgrupo">
            <div class="asidebarcol-tta"><i class="fa fa-file-pdf-o mr10"></i><?= $g ?></div>
            <div>
              <? foreach ($item as $i) { ?>
                <a href="pag_trans.php?pg=trans/list&ano=<?= $_GET['ano'] ?>&grupo=<?= urlencode($g) ?>&secao=<?= urlencode($i->nome) ?>"><?= $i->nome ?></a>
              <? } ?>
            </div>
          </div>

            <br>
        <? } ?>
      </div>
    </div>
    <div id="dropdown2" class="dropdown"><div class="dropdown-content animated fadeInDown"><?php include "_contatos.php"; ?></div></div>
    <div id="dropdown3" class="dropdown"><div class="dropdown-content animated fadeInDown"><?php include "_services.php"; ?></div></div>
    <div id="dropdown4" class="dropdown"><div class="dropdown-content animated fadeInDown"><?php include "_midias.php"; ?></div></div>
    <div id="dropdown5" class="dropdown"><div class="dropdown-content animated fadeInDown"><?php include "_governo.php"; ?></div></div>
  </div>
</div>


<script>
const menuItems = document.querySelectorAll('.menu-item');
const dropdowns = document.querySelectorAll('.dropdown');
menuItems.forEach(item => {
  item.addEventListener('mouseover', () => {
    const id = item.dataset.dropdown;
    dropdowns.forEach(dd => dd.style.display = dd.id === id ? 'block' : 'none');
  });
});
dropdowns.forEach(dd => {
  dd.addEventListener('mouseenter', () => dd.style.display = 'block');
  dd.addEventListener('mouseleave', () => dd.style.display = 'none');
});
document.getElementById('nav').addEventListener('mouseleave', () => {
  dropdowns.forEach(dd => dd.style.display = 'none');
});
</script>
