<?php 
$busca = $_GET['busca'] ?? null; // Garantir que a variável busca esteja definida
if (!$busca) {
    echo "<h3>Não foi encontrado nenhum dado com este argumento.</h3>";
} else {
    // 1. Iniciando a pesquisa geral
    $limite = 20;
    $pag = ($_GET['pag'] ?? 1);
    $pag = (filter_var($pag, FILTER_VALIDATE_INT)) ? $pag : 1;
    $extra = false; // Pesquisa em campos menos importantes (texto)
    $r = $APP->startBusca($busca, $extra);
    // 2. Processando os resultados gerais
    $R = [];
    foreach ($r as $k => $z) {
        foreach ($z as $x) {
            $x->{'app'} = $k;
            $R[] = $x;
        }
    }
    $total = count($R);
    if ($total > $limite) {
        $ARRAY = array_chunk($R, $limite);
        $R = $ARRAY[$pag - 1];
    }
    // 3. Pesquisa de transparência
    $SQL = "
    SELECT
        'transparencia' as app,
        p.codigo,
        p.id,
        p.titulo,
        p.tag,
        p.texto,
        p.data,
        p.exercicio,
        p.entidade,
        g.nome as grupo,
        c.nome as categoria,
        a.legenda as arquivo,
        MATCH (p.titulo, p.texto) AGAINST ('%$busca%' IN BOOLEAN MODE) AS relevancia
    FROM transparencia p
        JOIN transparencia_categorias c ON c.id = p.categoria
        JOIN transparencia_grupos g ON g.id = c.grupo
        LEFT JOIN transparencia_arquivos a ON (a.codigo = p.codigo AND a.legenda LIKE '%$busca%')
    WHERE (p.titulo LIKE '%$busca%') OR (p.texto LIKE '%$busca%')
    GROUP BY p.id
    ORDER BY relevancia DESC, rand()
    LIMIT 50";
    $transparenciaResults = $APP->db->ObjectBuilder()->rawQuery($SQL);
    $totalTransparencia = count($transparenciaResults);
}
?>

<a class="navigation fleft" href="index.php">Principal</a>
<span class="navigation fleft">Resultado da Busca</span>
<a class="navigation fright" href="javascript:history.go(-1)"><i class="btn fa fa-angle-double-left mr5"></i>Voltar</a>
<div class="clear"></div>
<div class="mt10"></div>
<hr>
<div>
    <h3><i class="fa fa-search mt20 mr10"></i> Procurando por "<b><?= $busca ?></b>"</h3>
    <hr class="hr40 mb20">

    <?php if ($R) { ?>
        <?php foreach ($R as $r) { ?>

            <!-- agenda -->
            <div class="mb10">
                <? if($r->app == 'agenda') { ?>
                    <div class="border-pag">
                        <h5>Publicado em: <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=apis/agenda&secao=<?= $r->titulo ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->texto; ?></p>
                    </div>  
                <? } ?>
            </div>
                
            <!-- audios -->
            <div class="mb10">
                <? if ($r->app == 'audios') { ?>
                    <div class="border-pag">
                        <h5>Áudios | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <div class="h4 upper"><b><?= $r->titulo ?></b></h3>
                        <p style="padding-bottom:10px"><?= $r->descricao ?></p>
                        <? $a = getAudios($r->id); foreach ($a as $a) { ?>
                            <audio class="small" controls="controls" style="width:200px; height:40px"><source src="<?= API.$a->path.$a->arquivo ?>" type="audio/mp3" /></audio><br>
                        <? } ?>
                    </div>
                <? } ?>
            </div>    

            <!-- classificados -->
            <div class="mb10">
                <?php if ($r->app == 'classificados') { ?>
                    <div class="border-pag">
                        <h5>Classificados | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=classificados/view&tag=<?= $r->tag ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->subtitulo ?></p>
                    </div>
                <?php } ?>
            </div>

            <!-- concursos -->
            <div class="mb10">
                <? if($r->app == 'concursos'){ ?>
                    <div class="border-pag">
                        <h5>Concursos | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="<?= 'pag_trans.php?pg=concursos/list&ano='.date('Y', strtotime($r->data)).'&b='.$r->titulo ?>"><b><?= $r->titulo ?></b></a>
                    </div>
                <? } ?>
            </div>

            <!-- diário -->
            <div class="mb10">
                <? if($r->app == 'diario') { ?>
                    <div class="border-pag">
                     <h5>Diário Oficial <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                     <a class="h4 upper" href="<?= TRANSP.'diario?ano='.date('Y', strtotime($r->data)).'&b='.$r->titulo ?>"><b><?= $r->titulo; ?></b></a>
                    </div>
                <? } ?>
            </div>    

            <!-- downloads -->
            <div class="mb10">
                <? if ($r->app == 'downloads') { ?>
                    <div class="border-pag">
                        <h5>Downloadas | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href='javascript:abreJanelaContador("<?= str_replace('web/', '', dirURL(URL_DIR.API.$r->path.$r->arquivo)); ?>", "downloads/<?= $r->id ?>", "<?= API ?>!/contador")'><b><?= $r->titulo ?></b></a>
                        <h5><?= $r->legenda ?? (explode(' (', $r->arquivo, -1)[0]) ?></h5>
                    </div>
                <? } ?>
            </div>

            <!-- enquetes -->
            <div class="mb10">
                <? if($r->app == 'enquetes') { ?>
                    <div class="border-pag">
                        <h5>Enquetes | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=apis/enquetes&tag=<?= $r->tag ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->texto; ?></p>
                    </div>
                <? } ?>
            </div>

            <!-- links -->
            <div class="mb10">
                <? if($r->app == 'links') { ?>
                    <div class="border-pag">
                        <h5>Links | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" target="_blank" href="<?= $r->url ?>"><b><?= $r->titulo ?></b></a>
                    </div>
                <? } ?>
            </div>
                
            <!-- Galerias -->
            <div class="mb10">
                <? if($r->app == 'galerias') { ?>
                    <div class="border-pag">
                        <h5>Galerias | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=apis/galeria&ID=<?= $r->id ?>&titulo=<?= $r->titulo ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->descricao; ?></p>
                    </div>
                <? } ?>
            </div>

            <!-- governo -->
            <div class="mb10">
                <? if($r->app == 'governo') { ?>
                    <div class="border-pag">
                        <h5>Publicado em: <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=governo/view&tag=<?= $r->tag ?>"><?= $r->titulo ?></a>
                        <h4><b><?= $r->subtitulo; ?></b></h4>
                    </div>
                <? } ?>
            </div>

            <!-- Licitações -->
            <div class="mb10">
                <?php if($r->app == 'licitacoes') { ?>
                    <div class="border-pag">
                        <h5>Licitações <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h5" href="<?= 'pag_trans.php?pg=licitacoes/list&ano='.date('Y', strtotime($r->data)).'&b='.$r->titulo ?>"><b><?= $r->titulo; ?></b></a>
                        <p><?= $r->objeto; ?></p>
                    </div>
                <?php } ?>
            </div>    

            <!-- noticias -->
            <div class="mb10">
                <?php if ($r->app == 'noticias') { ?>
                    <div class="border-pag">
                        <h5>Publicações | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=public/vwpub&tag=<?= $r->tag ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->subtitulo ?></p>
                    </div>
                <?php } ?>
            </div>    

            <!-- pesquisas -->
            <div class="mb10">
                <? if($r->app == 'pesquisas') { ?>
                    <div class="border-pag">
                        <h5>Publicado em: <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper" href="pag.php?pg=midias/pesquisas&secao=<?= $r->secao ?>"><b><?= $r->titulo ?></b></a>
                        <p><?= $r->texto; ?></p>
                    </div>
                <? } ?>
            </div>
                
            <div class="mb10">
                <!-- videos -->
                <? if($r->app == 'videos'){ ?>
                    <div class="border-pag">
                        <h5>Vídeos | <?= date('d/m/Y \à\s H:i', strtotime($r->data)); ?></h5>
                        <a class="h4 upper popup-youtube" href="http://www.youtube.com/watch?v=<?= $r->codigo ?>" rel="fancyvideo"><b><?= $r->titulo; ?></b></a>
                        <p><?= $r->descricao; ?></p>
                    </div>
                <? } ?>
            </div>

        <?php } ?>

        <!-- Paginação fora do loop -->
        <?php if ($total > $limite) { ?>
            <tr class="bg border">
                <td colspan="2">
                    <div style="margin-top: 10px;">
                        <center><?php include ( INC_PLUGINS . 'paginacao/paginacao.php'); ?></center>
                    </div>
                </td>
            </tr>
        <?php } ?>

    <?php } else { ?>
        <div>Nenhum Resultado Encontrado;</div>
    <?php } ?>
</div>

<div class="clear:both"></div>

<!-- Exibição dos Resultados de Transparência -->
<?php if ($totalTransparencia > 0) { ?>
    <div>
        <?php foreach ($transparenciaResults as $b) { ?>
            <div class="border-pag mb10">
                <h5>Transparência / <?= $b->grupo . ' / ' . $b->categoria ?></h5>
                <h5>Publicado em: <?= date('d/m/Y', strtotime($b->data)); ?></h5>
                <div class="mt5 acordion-showbox" showBox="<?= $b->app . $b->id ?>" showBox-target="pesquisa" status="0" style="overflow:hidden">
                    <span><i class="fa fa-plus mr10"></i><?= $b->titulo ?></span>
                </div>
                <div efeito="<?= $b->app . $b->id ?>" style="display: none; margin-left:20px;">
                    <div class="mt5 mb10" style="max-height: 250px; overflow-y: auto;"><h5><?= $b->texto ?></h5></div>
                </div>
                <?php if ($b->arquivo) {
                    foreach ($APP->getArquivosPesquisa($b->app, $_REQUEST['busca'], $b->codigo) as $arquivo) { ?>
                        <h6 class="mt5">
                            <i class="fa fa-hand-o-right mr5"></i>
                            <a class="upper" href='javascript:abreJanela("<?= dirURL(URL_ADM.API.$arquivo->path.$arquivo->arquivo); ?>")'><?= date('d/m/Y', strtotime($arquivo->data))?> - <?= $arquivo->legenda ?? $b->titulo ?></a>
                        </h6>
                    <?php }} ?>
                <a href="pag_trans.php?pg=trans/list&ent=<?= $b->entidade ?>&ano=<?= $b->exercicio ?>&grupo=<?= $b->grupo ?>&b=<?= $b->titulo ?>">
                    <h5 class="mt5 mb5"><h5 class="mt5 mb5" style="display: inline-block; padding:7px 17px; background:var(--tta); color:var(--tfo); border-radius: 5px; cursor: pointer; text-align: center; font-weight: bold; transition: background-color 0.3s;" 
                        onmouseover="this.style.backgroundColor='var(--thv)';" 
                        onmouseout="this.style.backgroundColor='var(--tta)';">
                        <i class="fa fa-hand-o-right mr5"></i><b>Ver pasta completa.</b>
                    </h5>
                </a>
            </div>
        <hr class="hr40 mb20">
        <?php } ?>
    </div>
<?php } ?>

<script src="<?= PLUGINS ?>js/abreJanela.js" type="text/javascript"></script>
<link rel="stylesheet" type="text/css" href="<?= PLUGINS ?>magnific/dist/magnific-popup.css" media="screen" />
<script type="text/javascript" src="<?= PLUGINS ?>magnific/dist/jquery.magnific-popup.min.js"></script>
<script>
$(document).ready(function() {
    $('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
        disableOn: 700,
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,
        fixedContentPos: true
    });
});
</script>
