<div class="block-links">
    <?php
    $grupo = "Legislação Municipal"; // Definindo o grupo
    if (!$TRANSPARENCIA) {
        $TRANSPARENCIA = $APP->startApp('transparencia'); // Inicializando o app de transparência
    }
    $filtros = (object) array('ent' => $entidadeMatriz, 'aside' => true); // Filtros para consulta
    $lista = $TRANSPARENCIA->viewMenusGruposArquivos($filtros); // Obtendo os itens do grupo
    if (isset($lista['Portal da Transparência'][$grupo])) {
        $itens = $lista['Portal da Transparência'][$grupo];
        foreach ($itens as $item) {
            if (!empty($item->nome) && isset($item->link)) {
                $secao = urlencode(strtolower(str_replace(' ', '', $item->nome))); // Ajusta o valor da seção, removendo espaços e minúsculo
                $url = '#'; // Fallback
                if ($item->link != 0) {
                    $url = 'pag_trans.php?pg=trans/list&grupo=' . urlencode($grupo) . '&secao=' . $secao;
                }
                echo '<a class="block-links fleft upper" href="' . htmlspecialchars($url) . '">' . htmlspecialchars($item->nome) . '</a>';
            }
        }
    } else {
        echo "<p>Grupo 'Legislação Municipal' não encontrado ou sem itens disponíveis.</p>";
    }
    ?>
</div>    