<link rel="stylesheet" href="<?= PLUGINS ?>paginacao/paginacao.css">

<?php
if(!function_exists('paginacao')) {
	function paginacao( $url, $pagina, $paginas, $adjacents = 5 ) {
		$firstlabel = '&laquo;&laquo;&nbsp;';
		$prevlabel  = '&lsaquo;&lsaquo;&nbsp;';
		$nextlabel  = '&nbsp;&rsaquo;&rsaquo;';
		$lastlabel  = '&nbsp;&raquo;&raquo;';
		
		$out = "<div class=\"pagin\">\n";
		
		// first
		if($pagina>($adjacents+1)) {
			$out.= "<a href=\"" . $url . "\">" . $firstlabel . "</a>\n";
		} else {
			//$out.= "<span>" . $firstlabel . "</span>\n"; // Não exibe "FIRST" Desativado
		}
		
		// previous
		if($pagina==1) {
			$out.= "<span>" . $prevlabel . "</span>\n";
		}
		elseif($pagina==2) {
			$out.= "<a href=\"" . $url . "\">" . $prevlabel . "</a>\n";
		}
		else {
			$out.= "<a href=\"" . $url . "&amp;pag=" . ($pagina-1) . "\">" . $prevlabel . "</a>\n";
		}
		
		// 1 2 3 4 etc
		$pmin = ($pagina>$adjacents) ? ($pagina-$adjacents) : 1;
		$pmax = ($pagina<($paginas-$adjacents)) ? ($pagina+$adjacents) : $paginas;
		for($i=$pmin; $i<=$pmax; $i++) {
			if($i==$pagina) {
				$out.= "<span class=\"current\">" . $i . "</span>\n";
			}
			elseif($i==1) {
				$out.= "<a href=\"" . $url . "\">" . $i . "</a>\n";
			}
			else {
				$out.= "<a href=\"" . $url . "&amp;pag=" . $i . "\">" . $i . "</a>\n";
			}
		}
		
		// next
		if($pagina<$paginas) {
			$out.= "<a href=\"" . $url . "&amp;pag=" .($pagina+1) . "\">" . $nextlabel . "</a>\n";
		}
		else {
			$out.= "<span>" . $nextlabel . "</span>\n";
		}
		
		// last
		if($pagina<($paginas-$adjacents)) {
			$out.= "<a href=\"" . $url . "&amp;pag=" . $paginas . "\">" . $lastlabel . "</a>\n";
		} else {
			//$out.= "<span>" . $lastlabel . "</span>\n"; // Não exibe "LAST" Desativado
		}
		
		$out.= "</div>";
		
		return $out;
	}
}

$paginas = ceil($total/$limite);
# Executa a 
if ($url AND $limite AND $total AND ($total > $limite)) { echo paginacao($url, $pag, $paginas); }

?>