/* Universal Carousel & Animate.js for Bootstrap 4 & 5 */
(function() {

    // Função para animar legendas
    function doAnimations(elems) {
        if (!elems) return;

        // Se for jQuery object
        if (typeof jQuery !== 'undefined' && elems instanceof jQuery) {
            elems.each(function() {
                var $this = jQuery(this),
                    animationType = $this.data('animation');
                $this.addClass(animationType).one('webkitAnimationEnd animationend', function() {
                    $this.removeClass(animationType);
                });
            });
        } else {
            // NodeList ou array
            elems = Array.from(elems);
            elems.forEach(function(el){
                var animationType = el.dataset.animation;
                el.classList.add(animationType);
                el.addEventListener('animationend', function(){
                    el.classList.remove(animationType);
                }, {once:true});
            });
        }
    }

    // Aguarda o DOM
    document.addEventListener('DOMContentLoaded', function() {

        var myCarouselEl = document.querySelector('#carousel-example-generic');
        if(!myCarouselEl) return; // Sai se não tiver carousel

        // Detecta se jQuery + Bootstrap 4 está presente
        var isBootstrap4 = (window.jQuery && typeof jQuery.fn.carousel === 'function');

        if(isBootstrap4){
            // Versão jQuery / Bootstrap 4
            var $myCarousel = jQuery(myCarouselEl);

            var $firstAnimatingElems = $myCarousel.find('.item:first').find("[data-animation^='animated']");
            $myCarousel.carousel({ interval: 3500 });
            doAnimations($firstAnimatingElems);

            $myCarousel.on('slide.bs.carousel', function (e) {
                var $animatingElems = jQuery(e.relatedTarget).find("[data-animation^='animated']");
                doAnimations($animatingElems);
            });

        } else {
            // Versão Bootstrap 5 / JS puro
            var carousel = new bootstrap.Carousel(myCarouselEl, { interval: 3500 });

            var firstAnimatingElems = myCarouselEl.querySelectorAll('.carousel-item:first-child [data-animation^="animated"]');
            doAnimations(firstAnimatingElems);

            myCarouselEl.addEventListener('slide.bs.carousel', function(e){
                var animatingElems = e.relatedTarget.querySelectorAll('[data-animation^="animated"]');
                doAnimations(animatingElems);
            });
        }

    });

})();
