<style>
.hero-slide                 {position:relative; width:100%; height:100vh; display:flex; flex-direction:column; justify-content: center; align-items: center; background-size:cover; background-position:center; overflow:hidden}
.hero-slide .overlay        {position: absolute; top: 0; left: 0; width: 100%; height: 100%}
.hero-slide .space-topo     {height:100px}
.hero-slide .cols           {display: flex; gap: 20px}
.hero-slide .col-left       {width: 60%; padding: 10px; display: flex; flex-direction: column; justify-content: center; align-items: flex-start; min-height: 200px}
.hero-slide .col-right      {width: 40%; padding: 10px; display: flex; flex-direction: column; justify-content: center; align-items: flex-start; min-height: 200px}
.hero-slide h1              {color: var(--banfonth2); font: 300 22px/22px "Roboto"; margin:0 0 15px; text-align:left}
.hero-slide h2              {color: var(--banfonth2); font: 700 60px/70px "Poppins", sans-serif; margin:0 0 15px; text-align:left}
.hero-slide h3              {color: var(--banfonth3); font: 400 15px/25px "Roboto"; margin: 0 0 15px; text-align:left}
.hero-slide .redes img      {display: inline-block; margin-right: 10px; width: 40px; height: 40px; }
.hero-slide .services img   {width: auto; height: 50px}
.hero-slide img:hover       {opacity:0.8;}
.hero-slide .marquee        {position:relative; z-index: 2; width:100%; flex-shrink:0;}
.hero-slide .icons          {position:relative; z-index: 2; width:100%; flex-shrink:1;}
.cols-wrapper {
    background: rgba(40, 64, 74, 0.8);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 20px;
    margin: 10px 0; 
}
@media (max-width: 3840px)  {.hero-slide h2{font: 700 70px/80px "Poppins", sans-serif}}
@media (max-width: 1920px)  {.hero-slide h2{font: 700 50px/60px "Poppins", sans-serif}}
@media (max-width: 1366px)  {.hero-slide h2{font: 700 40px/50px "Poppins", sans-serif}}
@media (max-width: 1024px)  {.hero-slide h2{font: 700 50px/60px "Poppins", sans-serif}.hero-slide .col-left{width:80%}}
</style>



<div class="jp-desktop">
    <?php 
    $CARROSSEL = $APP->startAPP('carrossel');
    $secao = $secao ?? 'Default';
    $home = $CARROSSEL->getCarrosselSecao($secao);
    $imagem = $CARROSSEL->getImagens($home->id)[0] ?? null; // pega apenas a primeira imagem
    ?>
    <?php if ($imagem): ?>

    <div class="hero-light">
        <div class="hero-slide" style="background:url('<?= URL_ADM.$imagem->path.$imagem->arquivo ?>') no-repeat center center/cover;">
            <div class="overlay"></div>
            <div class="space-topo"></div>
            <div class="wrap" style="width:100%">
                <div class="cols-wrapper">
                    <div class="cols">
                        <div class="col-left mb20">
                            <h1 class="animated fadeInDown center"><?=$imagem->titulo?></h1>
                            <h2 class="animated fadeInDown center"><?=$imagem->subtitulo?></h2>
                            <h3 class="animated fadeInUp center"><?=$imagem->texto?></h3>
                            <?php if ($imagem->link): ?><a href="<?= $imagem->link ?>" class="btn">VER MAIS</a><?php endif; ?>
                            <div class="animated fadeInUp mt10">
                                <div class="services"><img src="<?= IMAGENS ?>service-banner.png" title="Ícones" height="50"></div>
                                <div class="redes mt15"><? include (INC_CUSTOM . 'menus/_banner_redes.php'); ?></div>
                            </div>
                        </div>
                        <div class="col-right"></div>
                    </div>
                    <div class="marquee mb20"><? include ( INC_APPS . 'marquee.php'); ?></div>
                    <div class="icons"><? include (INC_CUSTOM . 'menus/_banner_icons_index.php'); ?></div>
                </div>
            </div>
            <br><br>
        </div>
        <?php endif; ?>
    </div>
</div>
<script defer src="<?= PLUGINS ?>carousel/js/index.js"></script>

