/*
 *  Document   : login.js
 *  Author     : ComunicPlus.com
 *  Description: Scripts página login
 */
var Login = function() {
    var vLogin = function(){
        jQuery('.form-login').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error h6', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                usuario: {
                    required: true,
                },
                senha: {
                    required: true,
                }
            },
            messages: {
                usuario: {
                    required: 'Digite seu nick ou e-mail',
                },
                senha: {
                    required: 'Insira sua senha.',
                },
            },
            errorPlacement: function (error, element) { // render error placement for each input type
                var cont = $(element).parent('.input-group');
                if (cont.size() > 0) {
                    cont.after(error);
                } else {
                    element.after(error);
                }
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $ ( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });

                return false;
            }
        });
    };

    var vRecuperar = function(){
        jQuery('.forget-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error h6', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                email: {
                    required: true,
                    email: true
                }
            },
            messages: {
                email: {
                    required: 'Digite seu endereço de e-mail.',
                    email: 'Insira um e-mail válido.'
                }
            },
            errorPlacement: function (error, element) { // render error placement for each input type
                var cont = $(element).parent('.input-group');
                if (cont.size() > 0) {
                    cont.after(error);
                } else {
                    element.after(error);
                }
            },
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $ ( form ).attr('action');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        ajaxErro();
                    }
                });

                return false;
            }
        });
    };

    var vAlterar = function(){
        if($('.form-token').length > 0 ) {
            jQuery('.form-token').validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error h6', // default input error message class
                focusInvalid: true, // do not focus the last invalid input
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    senha1: {
                        required: true,
                        minlength: 5
                    },
                    senha2: {
                        equalTo: senha1
                    }
                },
                messages: {
                    senha1: {
                        required: 'Digite sua nova senha',
                        minlength: 'Sua nova senha deve conter um mínimo de 5 caracteres'
                    },
                    senha2: {
                        equalTo: 'Suas senhas não conferem.'
                    }
                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    var cont = $(element).parent('.input-group');
                    if (cont.size() > 0) {
                        cont.after(error);
                    } else {
                        element.after(error);
                    }
                },
                submitHandler: function( form ){
                    var dados = $( form ).serialize();
                    var action = $ ( form ).attr('action');
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            ajaxErro();
                        }
                    });

                    return false;
                }
            });
        }
    };

    var vConvite = function(){
        if($('.form-convite').length) {
            jQuery('.form-convite').validate({
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error h6', // default input error message class
                focusInvalid: true, // do not focus the last invalid input
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    nome: {
                        required: true,
                    },
                    usuario: {
                        required: true,
                        remote: {
                            url: $('.form-convite').attr('action'),
                            type: "post",
                            data: {
                                consulta: true
                            }
                        }
                    },
                    senha1: {
                        required: true,
                        minlength: 5
                    },
                    senha2: {
                        equalTo: senha1
                    }
                },
                messages: {
                    nome: {
                        required: 'Digite seu nome.',
                    },
                    usuario: {
                        required: 'Digite um login válido.',
                        remote: 'Usuário indisponível.'
                    },
                    senha1: {
                        required: 'Digite sua senha',
                        minlength: 'Sua senha deve conter um mínimo de 5 caracteres'
                    },
                    senha2: {
                        equalTo: 'Suas senhas não conferem.'
                    }
                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    var cont = $(element).parent('.input-group');
                    if (cont.size() > 0) {
                        cont.after(error);
                    } else {
                        element.after(error);
                    }
                },
                submitHandler: function( form ){
                    var dados = $( form ).serialize();
                    var action = $ ( form ).attr('action');
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            ajaxErro();
                        }
                    });

                    return false;
                }
            });
        }
    };

    return {
        init: function () {
            // Init Login Form Validation
            vLogin();
            vConvite();
            vRecuperar();
            vAlterar();
        }
    };
}();
jQuery(document).ready(function() { Login.init(); });


$('#recuperar-senha').click(function() {
    jQuery('.form-login').hide();
    jQuery('.forget-form').show();
});

$('#voltar-login').click(function() {
    jQuery('.form-login').show();
    jQuery('.forget-form').hide();
});

function retornoAjax(r, extra = false) {
    // Reset
    if (r.reset) {
        $(r.reset).trigger("reset");
        /* FIX */
        if( $(".select2").length ) { $(".select2").select2(); }
        uploader = $('[uploader]').length ? $('[uploader]') : null; controle = $('[controle]').length ? $('[controle]') : null;
        if(uploader) { uploader.removeAllFiles(true); }
        if (controle) { controle.attr('value', 0); }
    }

    // Mensagens
    if(r.msg) {
        var tipo = r.mtipo ? r.mtipo : 'info';
        $toast = toastr[tipo](r.msg, r.titulo);     
    }

    // Seleciona Foco
    if (r.focus) {
        $(r.focus).select();
        //$.scrollTo(r.focus);
    }

    // Novo Formulario
    if (r.novo_formulario) {
        $("[formulario]").attr("value", r.novo_formulario);
    }

    // JavaScript
    if (r.js) {
        $('#jQuery').html(r.js);
        $('#jQuery').html('');
    }

    // Clear
    if (r.clear) {
        $(r.clear).val('');
    }

    // Select
    if( r.select ) {
        $(r.select).select();
    }

    // Redirecionamento
    if (r.href) {
        if (r.href == 'reload') {
            setTimeout( function(){
                window.location.reload()
            }, 1500)
        } else {
            setTimeout( function(){
                window.location.href = r.href
            }, 1500)
        }
    }

    // Download
    if (r.download) {
        setTimeout( function(){
            var iframe = document.createElement('iframe');
            iframe.id = r.download;
            iframe.style.display = 'none';
            document.body.appendChild(iframe);
            iframe.src = '\\!/download/?d='+ r.download;

            if(extra) {
                prontos = $('[prontos]');
                antigo = $('[prontos]').first().html();
                atual = parseInt(antigo-1);
                if(atual > 0) {
                    prontos.html(atual);
                } else {
                    prontos.remove();
                }
                extra.remove();
            }

        }, 1000);
    }

    // Toggle Modal
    if (r.modal) {
        $(r.modal).modal('toggle');
    }
}