<?
function youtubeID($url){
    if(strlen($url) > 11) {
        if (preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $url, $match)) 
        {
            return $match[1];
        }
        else
            return false;
    }
    return $url;
}

function siteURL() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'].'/';

    if( strlen(PATH) ) {
    	return $protocol.$domainName.PATH.'/';
    } else {
    	return $protocol.$domainName;
    }
}

function removeAcentos($text, $slug = null, $min = false) {
    $return = preg_replace( '/[`^~\'"]/', null, iconv( 'UTF-8', 'ASCII//TRANSLIT', $text ) );
    $return = trim(preg_replace("/[][><}{)(:;,!?*%~^`@ ]/", $slug, $return));
    $a = array('\\', '/', '.');
    $return = str_replace($a, '', $return);
    if ($min) { $return = strtolower($return); }
    return $return;
}

function stringTag($string, $min = false) {
    $return = removeAcentos($string, '', true);
    return $return;
}

class Tempo extends DateTime {
    private $parts = array(
        array(31104000, 'ano', 'anos'),
        array(2592000, 'mês', 'meses'),
        array(86400, 'dia', 'dias'),
        array(3600, 'hr', 'hrs'),
        array(60, 'min', 'min'),
        array(1, 'seg', 'seg'),
    );
    
    function formatar(DateTime $relativeTo = NULL) {
        if (is_null($relativeTo)) {
            $relativeTo = new DateTime();
        }
        $diff       = parent::format('U') - $relativeTo->format('U');
        $past       = FALSE;
        if ($diff < 0) {
            $past   = TRUE;
            $diff  *= -1;
        }
        foreach ($this->parts as $subparts) {
            $n = floor($diff / $subparts[0]);
            if ($n) {
                $output = '%d %s';
                $part   = $subparts[$n > 1 ? 2 : 1];
                if ($past) {
                    $part  .= ''; //' atrás';
                }
                return sprintf($output, $n, $part);
            }
        }
        return 'agora';
    }
}
function tempo($data) {
	$t = new Tempo($data);
	return $t->formatar();
}

function exibirData($data, $max = false) {
	if($max) {
		$y = explode('-', $data);
		if($y[0] == date('Y')) {
			$return = strftime("%d de %B", strtotime($data));
		} else {
			$return = strftime("%d de %B de %Y", strtotime($data));
		}

	} else {
		$y = explode('-', $data);
		if($y[0] == date('Y')) {
			$return = strftime("%d %B", strtotime($data));
		} else {
			$return = strftime("%d %b/%y", strtotime($data));
		}
	}
	echo utf8_encode($return);
}

function getExt($var) {
	return pathinfo($var, PATHINFO_EXTENSION) ?? false;
}

function geraSenha($tamanho = 10, $maiusculas = true, $numeros = true, $simbolos = false) {
	$lmin = 'abcdefghijklmnopqrstuvwxyz';
	$lmai = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$num = '1234567890';
	$simb = '!@#$%-_+£';
	$retorno = '';
	$caracteres = '';
	
	$caracteres .= $lmin;
	if ($maiusculas) $caracteres .= $lmai;
	if ($numeros) $caracteres .= $num;
	if ($simbolos) $caracteres .= $simb;
	
	$len = strlen($caracteres);
	for ($n = 1; $n <= $tamanho; $n++) {
		$rand = mt_rand(1, $len);
		$retorno .= $caracteres[$rand-1];
	}
	return $retorno;
}

function menuS($app, $class = null) {
	$url = URL_ARRAY;
	if($app == @$url[2]) {
		return ($class) ?? ' active open ';
	}
}
function menuP($alvo, $class = null) {
	$url = URL_ARRAY;
	if ($alvo == @$url[1]) {
		return ($class) ?? ' active ';
	}
}
function menuM($app, $menu = '', $class = null) {
    $url = URL_ARRAY;
    //var_dump($url); var_dump($app); var_dump($menu); die();
    if ($app == @$url[2] & $menu == @$url[3]) {
        return ($class) ?? ' active ';
    }
}

function getIP() {
    $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if(getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if(getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if(getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if(getenv('HTTP_FORWARDED'))
        $ipaddress = getenv('HTTP_FORWARDED');
    else if(getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
 
    return explode(',', $ipaddress)[0];
}

function moeda($numero) { return number_format($numero, 2, ',', '.'); };

function valor($numero) {
	$source = array('.', ',');  
	$replace = array('', '.'); 
	$valor = str_replace($source, $replace, $numero);
    $valor = preg_replace('/[^0-9\.]/', '', $valor);
	return $valor;
};

function sDir($directory, $hideDotFiles = true) {
    // Add trailing slash if necessary.
    if ($directory[mb_strlen($directory) - 1] !== DIRECTORY_SEPARATOR) {
        $directory .= DIRECTORY_SEPARATOR;
    }
    $directoryStructure = [];
    // array_diff is used to remove the "." and ".." files in directories on
    // Linux systems.
    foreach (array_diff(scandir($directory), ['.', '..']) as $file) {
        if ($hideDotFiles && $file[0] === '.') {
            continue;
        }
        if (is_dir($directory . $file)) {
            $directoryStructure[$file] = sDir($directory . $file);
        } else {
            $directoryStructure[] = $file;
        }
    }
    return $directoryStructure;
}
function dDir($directory) {
    array_map('unlink', glob($directory."*.*"));
    rmdir($directory);
    return $true;
}