<?
class Videos extends APP {
	PRIVATE $APP;

	PUBLIC $videos;
	PUBLIC $secoes;

	function __construct($isView = false) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getVideos();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('videos_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('videos_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('videos_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getVideos() {
		$this->db->join('videos_secoes s', 'v.secao = s.id', 'LEFT');
		$this->db->where('v.entidade', $this->_auth->entidade->id);
		$this->videos = $this->db->ObjectBuilder()->get('videos v', null, 'v.*, s.nome as secao, s.id as secao_id');
		return $this->videos;
	}

	function getVideoID($ID) {
		$this->db->join('videos_secoes s', 'v.secao = s.id', 'LEFT');
		$this->db->where('v.id', $ID);
		$this->db->where('v.entidade', $this->_auth->entidade->id);
		$this->videos = $this->db->ObjectBuilder()->getOne('videos v', 'v.*, s.nome as secao, s.id as secao_id');
		return $this->videos;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('videos', $dados);
	}
	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('videos');
	}
	function adicionar($dados) {
		if ($this->db->insert('videos', $dados)){
			return $this->db->getInsertId();
		} else {
			return false;
		}
	}
	function getSecoes($check = false, $filtros = false) {
		if($check and $filtros) {
			$this->db->join('videos v', 'v.secao = s.id', 'INNER');
			$this->db->where('YEAR(v.data)', $filtros->ano);
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->join('videos v', 'v.secao = s.id', 'LEFT');
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('videos_secoes s', null, 's.*');
		return $this->secoes;
	}
	function viewCategoriasArquivos($filtros = false) {
		$this->db->join('videos_secoes s', 'v.secao = s.id', 'LEFT');
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('v.entidade', $filtros->ent);
		} else {
			$this->db->where('v.entidade', $this->_auth->entidade->id);
		}
		# SEÇÃO
		if($filtros->s) {
			$this->db->where("s.nome", $filtros->s);
		}

		$this->db->OrderBy('v.data', 'DESC');
		$this->db->OrderBy('v.titulo', 'ASC');
		return $this->db->ObjectBuilder()->get('videos v', null, 'v.*, s.nome as secao, s.id as secao_id');
	}
	function getVideosNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('videos_secoes s', 'v.secao = s.id', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('v.entidade', $this->_auth->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('v.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('v.data', 'DESC');
		}

		$this->db->pageLimit = $limitador;
		if ($d = $this->db->ObjectBuilder()->paginate('videos v', $pagina, 'v.*, s.nome as secao, s.id as secao_id'))  {
			return $d;
		} else {
			return false;
		}
	}

	function getHeaders($url) {
		$curl = curl_init();
		curl_setopt_array($curl,
			array(
			    CURLOPT_URL => $url,
			    CURLOPT_HEADER => true,
			    CURLOPT_RETURNTRANSFER => true,
			    CURLOPT_NOBODY => true,
			    CURLOPT_SSL_VERIFYHOST => 0,
			    CURLOPT_SSL_VERIFYPEER => 0
			)
		);
		$header = explode("\n", curl_exec($curl));
		curl_close($curl);
		return $header;
	}
}

return $VIDEOS = new Videos();

?>