var crop_max_width = 800;
var crop_max_height = 600;
var jcrop_api;
var canvas;
var context;
var image;

var prefsize;

$("#file-crop").change(function() {
    loadImage(this);
});
// Inicializa quando carrega
$("#view-crop").change(function() { applyCrop(); })

function loadImage(input) {
  

  // LIMITA TAMANHO DO UPLOAD
  if (input.files[0].size > 4100000) {
    $toast = toastr['error']('Ela supera o limite máximo <b>(4mb)</b>. Escolha uma nova imagem para continuar', 'Esta Imagem é muito Grande!');
    return false;
  } else {
    valor = $(input).val();
    if(valor.length) {
        $('#view-crop').show();
        $('#capa').addClass('hidden');
        $('#label-crop').hide()
        $('#submit-crop').removeClass('hidden').attr('disabled', true).html('<i class="fa fa-spinner fa-pulse"></i> Carregando');
        setTimeout(function(){
          $('#submit-crop').removeAttr('disabled').html('<i class="fa fa-save"></i> Salvar');
        }, 1500);
    } else {
        if($('#capa').attr('src').length > 2) { $('#capa').removeClass('hidden') }
        $('#submit-crop').addClass('hidden');
        $('#label-crop').show()
    }
  }

  if (input.files && input.files[0]) {
    var reader = new FileReader();
    canvas = null;
    reader.onload = function(e) {
      image = new Image();
      image.onload = validateImage;
      image.src = e.target.result;
    }
    reader.readAsDataURL(input.files[0]);
  }
}

function dataURLtoBlob(dataURL) {
  var BASE64_MARKER = ';base64,';
  if (dataURL.indexOf(BASE64_MARKER) == -1) {
    var parts = dataURL.split(',');
    var contentType = parts[0].split(':')[1];
    var raw = decodeURIComponent(parts[1]);

    return new Blob([raw], {
      type: contentType
    });
  }
  var parts = dataURL.split(BASE64_MARKER);
  var contentType = parts[0].split(':')[1];
  var raw = window.atob(parts[1]);
  var rawLength = raw.length;
  var uInt8Array = new Uint8Array(rawLength);
  for (var i = 0; i < rawLength; ++i) {
    uInt8Array[i] = raw.charCodeAt(i);
  }

  return new Blob([uInt8Array], {
    type: contentType
  });
}

function validateImage() {
  if (canvas != null) {
    image = new Image();
    image.onload = restartJcrop;
    image.src = canvas.toDataURL('image/png');
  } else restartJcrop();
}

function restartJcrop() {
  if (jcrop_api != null) {
    jcrop_api.destroy();
  }

  $("#view-crop").empty();
  $("#view-crop").append("<canvas id=\"canvas\">");
  canvas = $("#canvas")[0];
  context = canvas.getContext("2d");
  canvas.width = image.width;
  canvas.height = image.height;
  context.drawImage(image, 0, 0);
  $("#canvas").Jcrop({
    onSelect: selectcanvas,
    onChange: selectcanvas,
    onRelease: clearcanvas,
    boxWidth: crop_max_width,
    boxHeight: crop_max_height,
    aspectRatio: 100/50,
    setSelect: [0, 0, 10000, 5000],
  }, function() {
    jcrop_api = this;
  });
  clearcanvas();
}

function clearcanvas() {
  prefsize = {
    x: 0,
    y: 0,
    w: canvas.width,
    h: canvas.height,
  };
}

function selectcanvas(coords) {
  prefsize = {
    x: Math.round(coords.x),
    y: Math.round(coords.y),
    w: Math.round(coords.w),
    h: Math.round(coords.h)
  };
  $('#crop-x').attr('value', prefsize.x);
  $('#crop-y').attr('value', prefsize.y);
  $('#crop-w').attr('value', prefsize.w);
  $('#crop-h').attr('value', prefsize.h);
}

function applyCrop() {
  canvas.width = prefsize.w;
  canvas.height = prefsize.h;
  context.drawImage(image, prefsize.x, prefsize.y, prefsize.w, prefsize.h, 0, 0, canvas.width, canvas.height);
  validateImage();
}

$("#form-crop").submit(function(e) {
  e.preventDefault();
  formData = new FormData($(this)[0]);
  var blob = dataURLtoBlob(canvas.toDataURL('image/png'));
  //---Add file blob to the form data
  formData.append("cropped_image", blob);

  $.ajax({
    url: $(this).attr('action'),
    type: "POST",
    data: formData,
    dataType: "json",
    contentType: false,
    cache: false,
    processData: false,
    beforeSend: function (){
      BlockUI('.loader');
    },
    success: function(data) {
      unBlockUI('.loader');
      retornoAjax(data);
      if(data.success == true) {
        $('#capa').removeClass('hidden');
        $('#capa-img').attr('src', data.arquivo+'?'+ new Date().getTime());
        $('#label-crop').html('Trocar de Imagem').show();
        $('#submit-crop').addClass('hidden');
        $('#label-crop').removeClass('hidden');
        $('#view-crop').hide();
        $('#form-crop')[0].reset();
        location.reload();
      }
    },
    error: function(data) {
      unBlockUI('.loader');
      $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
    },
  });
});






















var p_crop_max_width = 600;
var p_crop_max_height = 600;
var p_jcrop_api;
var p_canvas;
var p_context;
var p_image;

var p_prefsize;

$("#perfil_file-crop").change(function() {
    loadImagePerfil(this);
});
// Inicializa quando carrega
$("#perfil_view-crop").change(function() { applyCropPerfil(); alert('xD changed')})

function loadImagePerfil(input) {
  // LIMITA TAMANHO DO UPLOAD
  if (input.files[0].size > 4100000) {
    $toast = toastr['error']('Ela supera o limite máximo <b>(4mb)</b>. Escolha uma nova imagem para continuar', 'Esta Imagem é muito Grande!');
    return false;
  } else {
    valor = $(input).val();
    if(valor.length) {
        $('#perfil_view-crop').show();
        $('#perfil').addClass('hidden');
        $('#perfil_label-crop').hide()
        $('#perfil_submit-crop').removeClass('hidden').attr('disabled', true).html('<i class="fa fa-spinner fa-pulse"></i> Carregando');
        setTimeout(function(){
          $('#perfil_submit-crop').removeAttr('disabled').html('<i class="fa fa-save"></i> Salvar');
        }, 1500);
    } else {
        if($('#perfil').attr('src').length > 2) { $('#perfil').removeClass('hidden') }
        $('#perfil_submit-crop').addClass('hidden');
        $('#perfil_label-crop').show()
    }
  }

  if (input.files && input.files[0]) {
    var p_reader = new FileReader();
    p_canvas = null;
    p_reader.onload = function(e) {
      p_image = new Image();
      p_image.onload = validateImagePerfil;
      p_image.src = e.target.result;
    }
    p_reader.readAsDataURL(input.files[0]);
  }
}

function validateImagePerfil() {
  if (p_canvas != null) {
    p_image = new Image();
    p_image.onload = restartJcropPerfil;
    p_image.src = p_canvas.toDataURL('image/png');
  } else restartJcropPerfil();
}

function restartJcropPerfil() {
  if (p_jcrop_api != null) {
    p_jcrop_api.destroy();
  }

  $("#perfil_view-crop").empty();
  $("#perfil_view-crop").append("<canvas id=\"canvasPerfil\">");
  p_canvas = $("#canvasPerfil")[0];
  p_context = p_canvas.getContext("2d");
  p_canvas.width = p_image.width;
  p_canvas.height = p_image.height;
  p_context.drawImage(p_image, 0, 0);
  $("#canvasPerfil").Jcrop({
    onSelect: selectcanvasPerfil,
    onChange: selectcanvasPerfil,
    onRelease: clearcanvasPerfil,
    boxWidth: p_crop_max_width,
    boxHeight: p_crop_max_height,
    aspectRatio: 50/50,
    setSelect: [0, 0, 5000, 5000],
  }, function() {
    p_jcrop_api = this;
  });
  clearcanvasPerfil();
}

function clearcanvasPerfil() {
  p_prefsize = {
    x: 0,
    y: 0,
    w: p_canvas.width,
    h: p_canvas.height,
  };
}

function selectcanvasPerfil(coords) {
  p_prefsize = {
    x: Math.round(coords.x),
    y: Math.round(coords.y),
    w: Math.round(coords.w),
    h: Math.round(coords.h)
  };
  $('#perfil_crop-x').attr('value', p_prefsize.x);
  $('#perfil_crop-y').attr('value', p_prefsize.y);
  $('#perfil_crop-w').attr('value', p_prefsize.w);
  $('#perfil_crop-h').attr('value', p_prefsize.h);
}

function applyCropPerfil() {
  p_canvas.width = p_prefsize.w;
  p_canvas.height = p_prefsize.h;
  context.drawImage(p_image, p_prefsize.x, p_prefsize.y, p_prefsize.w, p_prefsize.h, 0, 0, p_canvas.width, p_canvas.height);
  validateImagePerfil();
}

$("#perfil_form-crop").submit(function(e) {
  e.preventDefault();
  formData = new FormData($(this)[0]);
  var blob = dataURLtoBlob(p_canvas.toDataURL('image/png'));
  //---Add file blob to the form data
  formData.append("cropped_image", blob);

  $.ajax({
    url: $(this).attr('action'),
    type: "POST",
    data: formData,
    dataType: "json",
    contentType: false,
    cache: false,
    processData: false,
    beforeSend: function (){
      BlockUI('.loader');
    },
    success: function(data) {
      unBlockUI('.loaderPerfil');
      retornoAjax(data);
      if(data.success == true) {
        $('#perfil').removeClass('hidden');
        $('#perfil-img').attr('src', data.arquivo+'?'+ new Date().getTime());
        $('#perfil_label-crop').html('Trocar de Imagem').show();
        $('#perfil_submit-crop').addClass('hidden');
        $('#perfil_label-crop').removeClass('hidden');
        $('#perfil_view-crop').hide();
        $('#perfil_form-crop')[0].reset();
        location.reload();
      }
    },
    error: function(data) {
      unBlockUI('.loaderPerfil');
      $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
    },
  });
});