<?
class Vagas extends APP {
	PRIVATE $APP;

	PUBLIC $vagas;
	PUBLIC $candidatos;
	PUBLIC $status;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		//$this::getVagas($_POST['carregar']);
		$this::getSetup();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	PRIVATE function getSetup() {
		if(!$this->db->ObjectBuilder()->rawQuery('SHOW COLUMNS FROM vagas_setup WHERE Field = "entidade"')){
			$this->db->rawQuery('ALTER TABLE vagas_setup CHANGE COLUMN id id INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD COLUMN entidade INT(11) NOT NULL DEFAULT 0 AFTER email_porta;');

			$this->db->where('matriz', 1);
			$ent = $this->db->ObjectBuilder()->getValue('app_entidades', 'id');
			$this->db->where('id', 1);
			$this->db->update('vagas_setup', array('entidade' => (int) $ent));
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('vagas_setup') ) {
			## Configurações de E-amail
			define('eEMAIL', $this->setup->email_email);
			define('eEMAIL_NOME', $this->setup->email_nome);
			define('eEMAIL_HOST', $this->setup->email_host);
			define('eEMAIL_LOGIN', $this->setup->email_login);
			define('eEMAIL_SENHA', $this->setup->email_senha);
			define('eEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('vagas_setup', $dados);
		} else {
			return $this->db->insert('vagas_setup', $dados);
		}
	}

	function startEmail() {
		##### PHP MAILER;
		include ('app/core/PHPMailer/PHPMailerAutoload.php');
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			//$this->email->SMTPDebug = 2;
			$this->email->Host = eEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = eEMAIL_LOGIN;
			$this->email->Password = eEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = eEMAIL_PORTA;
			$this->email->setFrom(eEMAIL, eEMAIL_NOME);
	}


	function enviarEmailCandidato($dados) {

		GLOBAL $APP;
		GLOBAL $path;

		$v = $this::getVagaID($dados->id_vaga);
		$c = $this::getCandidatoID($dados->id);

		## Iniciar E-mail
		if (!$this->email) { $this->startEmail(); }

		## Prepara Mensagem;
		$assunto = 'Nova Candidatura à Vaga de Emprego';
		$mensagem = 'Olá, '.$p->nome.'.<br>
			Você acaba de receber uma candidatura a vaga de emprego: '.$v->titulo.'.<br>
			Esta candidatura foi recebida com sucesso e ficará disponível para consulta através do site:';

		## Importa Template
		include($path['core'].'template.php');

		## Prepara o Envio
		$this->email->addAddress($v->email);
		$this->email->Subject = $assunto;
		$this->email->Body    = $template;
		$this->email->isHTML(true);
		## Envia
		if (@$this->email->send()) {
			## Informa envio.
			$this->db->where('id', $ID);
			$update['envio'] = 1;
			$this->db->update('vagas_candidatos', $update);
		}
		return true;
	}

	function consultaCNPJ($cnpj) {
		$this->db->where('documento', $cnpj);
		return $this->db->ObjectBuilder()->getOne('vagas');
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('vagas_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('vagas_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('vagas_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('vagas_arquivos');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('vagas_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('vagas_arquivos', $legenda);
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('vagas_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('vagas_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getVagasCnpj($cnpj, $status = false) {
		if($status !== false) { $this->db->where('e.status', $status); }
		$this->db->join('vagas_candidatos c', 'c.id_vaga = e.id', 'LEFT');
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.ID');
		if($vagas = $this->db->ObjectBuilder()->get('vagas e', null, 'e.*, count(c.ID) as candidatos')) {
			foreach($vagas as $v) {
				$v->candidaturas = $this::getCandidatos('all', $v->id);
			}
		}
		return $vagas;
	}
	
	function getVagas($limitador, $status = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		if($status !== false) { $this->db->where('e.status', $status); }
		$this->db->join('vagas_candidatos c', 'c.id_vaga = e.id', 'LEFT');
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.ID');
		return $this->vagas = $this->db->ObjectBuilder()->get('vagas e', $limitador, 'e.*, count(c.ID) as candidatos');
	}

	function getCandidatos($limitador, $vaga = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		if($vaga) { $this->db->where('id_vaga', $vaga); }
		$this->db->join('vagas v', 'c.id_vaga = v.id', 'INNER');
		$this->db->where('c.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('c.data', 'DESC');
		$this->db->groupBy('c.ID');
		return $this->vagas = $this->db->ObjectBuilder()->get('vagas_candidatos c', $limitador, 'c.*, v.empresa, v.titulo');	
	}

	function getVagaCodigo($codigo) {
		$this->db->where('e.codigo', $codigo);
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->get('vagas e', null, 'e.*')[0];
	}

	function getVagaID($ID) {
		$this->db->where('e.id', $ID);
		return $this->db->ObjectBuilder()->get('vagas e', null, 'e.*')[0];
	}

	function getCandidatoID($ID) {
		$this->db->where('e.id', $ID);
		return $this->db->ObjectBuilder()->get('vagas_candidatos e', null, 'e.*')[0];
	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('vagas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarCandidato($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('vagas_candidatos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('vagas');
	}

	function excluirCandidato($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('vagas_candidatos');
	}


	function criar($dados) {
		if ($this->db->insert('vagas', $dados)){
			$ID = $this->db->getInsertID();
			/*if($dados['email']) {
				$this::enviarEmail('criar', $ID);
			}*/
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function criarCandidato($dados) {
		if ($this->db->insert('vagas_candidatos', $dados)){
			$ID = $this->db->getInsertID();
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function notificar($ID) {
		$c = $this::getCandidatoID($ID);
		return $this::enviarEmailCandidato($c);
	}
	
	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('esic', $update);
	}

}

return $VAGAS = new Vagas($isView);

?>