TableDatatablesEditable = function () {

    var tabelaCategorias = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('categoria-ID');
            if(ID) {
                secoes = secao[ID];
            } else {
                secoes = secaoGeral;
            }
            jqTds[0].innerHTML = '<select required name="grupo" maxlength="50" class="form-control select2">' + secoes + '</select>';
            jqTds[1].innerHTML = '<input type="text" required name="nome" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = "<input type='text' required name='descricao' class='form-control' value='" + remSlash(aData[2]) + "'>";
            jqTds[3].innerHTML = '<select required name="exibicao" maxlength="50" class="form-control select2">' + (exibicao[aData[3]] ? exibicao[aData[3]] : exibicao['Exercício']) + '</select>';
            jqTds[4].innerHTML = '<select required name="atualizacao" maxlength="50" class="form-control select2">' + (periodo[aData[4]] ? periodo[aData[4]] : periodo['Nenhuma']) + '</select>';
            jqTds[5].innerHTML = aData[5];
            jqTds[6].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[7].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
            select2Tipos();
        }
        function select2Tipos() {
            $.fn.select2.defaults.set("theme", "bootstrap");
            $.fn.select2.defaults.set('language', 'pt-BR');
            $(".select2").select2({
                selectOnClose: true,
                placeholder: 'Selecione um Tipo',
                selectOnBlur: true,
                tags: false,
            });
        } select2();

        function remSlash(str) {
            str = (str + '')
                .replace(/\'./g,'');
            return str
        }

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
            oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
            oTable.fnUpdate(jqInputs[5], nRow, 5, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 6, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 7, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao+'&tabela=categorias',
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        console.log(jqInputs[5]);
                        $(nRow).attr('categoria-ID', data.ID);
                        oTable.fnUpdate(grupo[jqInputs[0].value], nRow, 0, false);
                        oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                        oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
                        oTable.fnUpdate(jqInputs[3].value, nRow, 3, false);
                        oTable.fnUpdate(jqInputs[4].value, nRow, 4, false);
                        oTable.fnUpdate('<a icone="'+data.ID+'" ><img width="30" imgIcone="'+data.ID+'" src="'+data.icone+'" /></a>', nRow, 5, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 6, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 7, false);
                        oTable.fnDraw();

                        secao[data.ID] = data.secao
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });
            $('#controle-ajax').attr('acao', '');
        }

        var tableLinks = $('#tabela_categorias');


        var oTable = tableLinks.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1] },
                },
                { extend: 'copy',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1] },
                },
                { extend: 'pdf',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1] },
                },
                { extend: 'excel',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1] },
                },
                { extend: 'csv',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                //'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "ASC"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#adicionarC').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        tableLinks.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('categoria-ID');

            swal({
                title: "Tem certeza que deseja excluir esta categoria?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar&tabela=categorias',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[categoria-ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });            
            
        });

        tableLinks.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableLinks.on('click', '.edit', function (e) {
            nNew = false;

            var ID = $(this).closest('tr').attr('categoria-ID');
            if(ID) {
                $('#controle-ajax').attr('acao', 'editar');
            } else {
                $('#controle-ajax').attr('acao', 'novo');
            }

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }


    var tabelaGrupos = function () {


        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('grupo-ID');
            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('grupo-ID');

            jqTds[0].innerHTML = '<select required name="menu" maxlength="50" class="form-control select2">' + (menus[ID] ? menus[ID] : menuGeral) + '</select>';
            jqTds[1].innerHTML = '<input type="text" required name="nome" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<input type="text" required name="descricao" class="form-control" value="' + aData[2] + '">';
            jqTds[3].innerHTML = '<select required name="aside" maxlength="50" class="form-control select2">' + (aData[3] == 'Aba' ? '<option selected value="0">Aba</option><option value="1">Link</option>' : '<option value="0">Aba</option><option selected value="1">Link</option>') + '</select>';
            jqTds[4].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[5].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
        }

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            aside = ['Aba', 'Link'];
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate(aside[jqInputs[3].value], nRow, 3, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 4, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 5, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            aside = ['Aba', 'Link'];
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao+'&tabela=grupos',
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('grupo-ID', data.ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate(menu[jqInputs[1].value], nRow, 1, false);
                        oTable.fnUpdate(aside[jqInputs[2].value], nRow, 2, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 3, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 4, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });
            $('#controle-ajax').attr('acao', '');
        }

        var tableLinks = $('#tabela_grupos');


        var oTable = tableLinks.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0] },
                },
                { extend: 'copy',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0] },
                },
                { extend: 'pdf',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0] },
                },
                { extend: 'excel',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0] },
                },
                { extend: 'csv',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                //'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "ASC"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#adicionarG').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        tableLinks.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('grupo-ID');

            swal({
                title: "Tem certeza que deseja excluir este grupo?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar&tabela=grupos',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[grupo-ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });
            
            
        });

        tableLinks.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableLinks.on('click', '.edit', function (e) {
            nNew = false;

            var ID = $(this).closest('tr').attr('grupo-ID');
            if(ID) {
                $('#controle-ajax').attr('acao', 'editar');
            } else {
                $('#controle-ajax').attr('acao', 'novo');
            }

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }

    var tabelaMenus = function () {


        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('menu-ID');

            jqTds[0].innerHTML = '<input type="text" required name="nome" class="form-control" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<input type="number" required name="ordem" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[3].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
        }

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 2, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 3, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao+'&tabela=menus',
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('menu-ID', data.ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 2, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 3, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });
            $('#controle-ajax').attr('acao', '');
        }

        var tableLinks = $('#tabela_menus');


        var oTable = tableLinks.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0] },
                },
                { extend: 'copy',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0] },
                },
                { extend: 'pdf',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0] },
                },
                { extend: 'excel',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0] },
                },
                { extend: 'csv',
                    title: 'Agenda',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                //'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "ASC"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#adicionarMenu').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        tableLinks.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('menu-ID');

            swal({
                title: "Tem certeza que deseja excluir este menu?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar&tabela=menus',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[menu-ID='+ID+']')
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });
            
            
        });

        tableLinks.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableLinks.on('click', '.edit', function (e) {
            nNew = false;

            var ID = $(this).closest('tr').attr('menu-ID');
            if(ID) {
                $('#controle-ajax').attr('acao', 'editar');
            } else {
                $('#controle-ajax').attr('acao', 'novo');
            }

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }

    var tabelaLinks = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('link-ID');
            jqTds[0].innerHTML = '<input type="text" required name="titulo" class="form-control" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<input type="text" required name="link" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[3].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
            select2Tipos();
        }
        function select2Tipos() {
            $.fn.select2.defaults.set("theme", "bootstrap");
            $.fn.select2.defaults.set('language', 'pt-BR');
            $(".select2").select2({
                selectOnClose: true,
                placeholder: 'Selecione um Tipo',
                selectOnBlur: true,
                tags: true,
            });
        } select2();

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 2, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 3, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax-links').attr('action');
            var acao = $('#controle-ajax-links').attr('acao');
            var codigo = $('#controle-ajax-links').attr('codigo');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID+'&acao='+acao+'&codigo='+codigo,
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('link-ID', data.ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 2, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 3, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });

        }

        var tableLinks = $('#tabela_links');


        var oTable = tableLinks.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'copy',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'pdf',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'excel',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'csv',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "asc"]
            ], // set first column as a default sort by asc

        });

        var tableWrapper = $("#editable_wrapper_link");

        var nEditing = null;
        var nNew = false;

        $('#novo_link').click(function (e) {
            e.preventDefault();

            if (nNew && nEditing) {
                if (confirm("A linha em edição não foi salva. Você deseja salvá-la?")) {
                    saveRow(oTable, nEditing); // save
                    $(nEditing).find("td:first").html("Untitled");
                    nEditing = null;
                    nNew = false;

                } else {
                    oTable.fnDeleteRow(nEditing); // cancel
                    nEditing = null;
                    nNew = false;
                    return;
                }
            }

            var aiNew = oTable.fnAddData(['', '', '', '', '', '', '', '', '', '', '', '', '']);
            var nRow = oTable.fnGetNodes(aiNew[0]);
            oTable.find('tbody').prepend(nRow);
            $('#controle-ajax').attr('acao', 'novo');
            editRow(oTable, nRow);
            nEditing = nRow;
            nNew = true;
            $(oTable).find('input,select').first().focus();
        });

        tableLinks.on('click', '.delete', function (e) {
            e.preventDefault();

            var action = $('#controle-ajax-links').attr('action');
            var acao = $('#controle-ajax-links').attr('acao');
            var ID = $(this).closest('tr').attr('link-ID');

            swal({
                title: "Tem certeza que deseja excluir este Link?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[link-ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            console.log(data)
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });          
            
            
        });

        tableLinks.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableLinks.on('click', '.edit', function (e) {
            $('#controle-ajax-links').attr('acao', 'editar');
            e.preventDefault();
            nNew = false;

            var ID = $(this).closest('tr').attr('link-ID');

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }

    return {

        //main function to initiate the module
        init: function () {
            tabelaMenus();
            tabelaGrupos();
            tabelaCategorias();
            tabelaLinks();
        }

    };

}();
jQuery(document).ready(function() {
    //TableDatatablesEditable.init();
});


$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    if ( $(e.target).attr('href') == '#tab-grupos' ) {
        $('.progress-bar').css('width', 50+'%');
        $('[li-grupos]').removeClass('done').addClass('active');
        $('[li-categorias]').removeClass('active');

    } else if ( $(e.target).attr('href') == '#tab-categorias' ) {
        $('.progress-bar').css('width', 100+'%');
        $('[li-grupos]').addClass('done');
        $('[li-categorias]').addClass('active');
    }
})



var Icones = function() {
    var vConfirmar = function(){
        jQuery('.js-icones').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                'alvo-icone': {
                    required: true,
                },
            },
            messages: {
                
            },
            ignore: ":hidden:not(#texto),.note-editable.panel-body",
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                            $('[imgIcone='+data.ID+']').attr('src', data.icone);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Icones.init(); });


$(document).on('click', '[icone]', function () {
    ID = $(this).attr('icone');
    dir = $('[icone-dir]').attr('icone-dir');
    nome = $(this).attr('nome');

    $('#modal-icones').modal('show');
        $('#icone-alvo').attr('value', ID);
        $('[nome-icone='+nome+']').attr('selected', true);

    $('#alvo-icone').attr('value',ID);

    $('#modal-icones').on('hidden.bs.modal', function () {
        $('#icone-alvo').attr('value', '');
        $('[nome-icone]').removeAttr('selected');
    })
})




var Ordem = function() {
    var vConfirmar = function(){
        jQuery('.js-ordem').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                'alvo-icone': {
                    required: true,
                },
            },
            messages: {
                
            },
            ignore: ":hidden:not(#texto),.note-editable.panel-body",
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        retornoAjax(data);
                            $('[imgOrdem='+data.ID+']').attr('src', data.ordem);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Ordem.init(); });

$(document).on('click', '[ordem]', function () {
    ID = $(this).attr('ordem');
    dir = $('[ordem-dir]').attr('icone-dir');
    nome = $(this).attr('nome');

    $('#modal-ordem').modal('show');
        $('#ordem-alvo').attr('value', ID);
        $('[nome-ordem='+nome+']').attr('selected', true);

    $('#alvo-ordem').attr('value', ID);

    $('#modal-ordem').on('hidden.bs.modal', function () {
        $('#ordem-alvo').attr('value', '');
        $('[nome-ordem]').removeAttr('selected');
    })
})