// init cubeportfolio
function imagensAtivas() {
if ($('#js-grid-juicy-projects').length > 0) {
    if($('#js-grid-juicy-projects').attr('iniciado') == 1) {
        $('#js-grid-juicy-projects').cubeportfolio('destroy');
        $('#js-grid-juicy-projects').attr('iniciado', 0);
    }
    if ($('#js-grid-juicy-projects').attr('qtd') > 0) {    
        $('#js-grid-juicy-projects').attr('iniciado', 1);
        var CUBE = $('#js-grid-juicy-projects').cubeportfolio({
            //filters: '#js-filters-juicy-projects',
            //loadMore: '#js-loadMore-juicy-projects',
            loadMoreAction: 'click',
            layoutMode: 'grid',
            defaultFilter: '*',
            animationType: 'quicksand',
            gapHorizontal: 35,
            gapVertical: 30,
            gridAdjustment: 'responsive',
            mediaQueries: [{
                width: 1500,
                cols: 6
            }, {
                width: 1100,
                cols: 5
            }, {
                width: 800,
                cols: 3
            }, {
                width: 480,
                cols: 2
            }, {
                width: 320,
                cols: 1
            }],
            //caption: 'overlayBottomReveal',
            displayType: 'sequentially',
            displayTypeSpeed: 80,

            // lightbox
            lightboxDelegate: '.cbp-lightbox',
            lightboxGallery: true,
            lightboxTitleSrc: 'data-title',
            lightboxCounter: '<div class="cbp-popup-lightbox-counter">{{current}} de {{total}}</div>',
        });
    }
}
}
if(window.location.hash == '#tab-imagens') {
    imagensAtivas()
}

function arquivosAtivos() {
if ($('#listaArquivos').length > 0) {
    if($('#listaArquivos').attr('iniciado') == 1) {
        $('#listaArquivos').cubeportfolio('destroy');
        $('#listaArquivos').attr('iniciado', 0);
    }
    if ($('#listaArquivos').attr('qtd') > 0) {    
        $('#listaArquivos').attr('iniciado', 1);
        var CUBEA = $('#listaArquivos').cubeportfolio({
            //filters: '#js-filters-juicy-projects',
            //loadMore: '#js-loadMore-juicy-projects',
            loadMoreAction: 'click',
            layoutMode: 'grid',
            defaultFilter: '*',
            animationType: 'quicksand',
            gapHorizontal: 35,
            gapVertical: 30,
            gridAdjustment: 'responsive',
            mediaQueries: [{
                width: 1500,
                cols: 8
            }, {
                width: 1100,
                cols: 6
            }, {
                width: 800,
                cols: 5
            }, {
                width: 480,
                cols: 3
            }, {
                width: 320,
                cols: 2
            }],
            //caption: 'overlayBottomReveal',
            displayType: 'sequentially',
            displayTypeSpeed: 80,

            // lightbox
            lightboxDelegate: '.cbp-lightbox',
            lightboxGallery: true,
            lightboxTitleSrc: 'data-title',
            lightboxCounter: '<div class="cbp-popup-lightbox-counter">{{current}} de {{total}}</div>',
        });
    }
}
}
if(window.location.hash == '#tab-arquivos') {
    arquivosAtivos()
}

var FormWizard = function () {

    var handleSummernote = function () {
        var myElement = $('#texto');
        myElement.show();
        myElement.summernote({
            height: 300,
            dialogsFade: true,
            placeholder: 'Digite ou insira o texto aqui',
            lang: 'pt-BR',
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                //['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link'/*, 'picture', 'video'*/]],
                ['view', ['fullscreen', 'codeview', 'help']]
              ],
            callbacks: {
                onChange: function(contents, $editable) {
                    myElement.val(myElement.summernote('isEmpty') ? "" : contents);
                    v.element(myElement); 
                }
            }
        });
        //API:
        //var sHTML = $('#summernote_1').code(); // get code
        //$('#summernote_1').destroy(); // destroy




        function format(state) {
            if (!state.id) return state.text; // optgroup
            return "<img class='flag' src='../../assets/global/img/flags/" + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
        }

        var form = $('#form-editar');
        var error = $('.alert-danger', form);
        var success = $('.alert-success', form);

        var v = form.validate({
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                //account
                data: {
                    required: true
                },
                hora: {
                    required: true
                },
                nome: {
                    required: true
                },
                documento: {
                    required: false
                },
                departamento: {
                    required: true
                },
                assunto: {
                    required: true
                },
                origem: {
                    required: true
                },
                descricao: {
                    //required: false
                }
            },

            ignore: ":hidden:not(#texto),.note-editable.panel-body",

            messages: { // custom messages for radio buttons and checkboxes
                
            },

            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                    error.insertAfter("#form_gender_error");
                } else if (element.attr("name") == "texto") { // for uniform checkboxes, insert the after the given container
                    error.insertAfter("#erro-editor");
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
                success.hide();
                error.show();
                App.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                    .closest('.form-group').removeClass('has-error'); // set success class to the control group
                }
            },

            submitHandler: function (form) {
                data = $( form ).serialize();
                var action = $( form ).attr('action');
                if($('[name=documento]').length > 1) {
                    if( !validar('[name=documento]', 'cpf-cnpj') ) {
                        $('[name=documento]').select();
                        swal("Documento inválido.", "O Documento informado é inválido.", "error");
                        return false;
                    }
                }
                //var acao = 'criar';
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: data,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }

        });
    }


    return {
        //main function to initiate the module
        init: function () {
            //validations();
            handleSummernote();
        }
    };

}();
jQuery(document).ready(function() {
    FormWizard.init();
});


//## UPLOAD
if($('.dropzone').length) {
    $('.dropzone').each( function() {

        var codigo = $(this).attr('codigo');
        var ID = $(this).attr('ID');
        var action = $(this).attr('action');
        var tipo = $(this).attr('tipo');


        //var controle = $('[controle]');
        var submit = $("[dContinuar]");

        // MaxFiles
        if ($(this).attr('maxFiles').length) {
            _maxFiles = $(this).attr('maxFiles');
        } else {
            _maxFiles = 10;
        }

        // extFilter
        if ($(this).attr('extFilter').length) {
            _extFilter = $(this).attr('extFilter');
        } else {
            _extFilter = '';
        }


        var uploader = new Dropzone(this, { // Make the whole body a dropzone
          url: action, // Set the url
          parallelUploads: 5,
          maxFiles: _maxFiles,
          maxFilesize: 200, //mb
          acceptedFiles: _extFilter, //
          //previewTemplate: previewTemplate,
          autoQueue: true, // Make sure the files aren't queued until manually added
          //previewsContainer: "#previews", // Define the container to display the previews
          //clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.,
          removedfile: function(file) {
            
            if (file.status == 'success') {
                if(file.xhr) {
                    r = JSON.parse(file.xhr.response);
                }
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: "acao=deletar&arquivo="+r.ID,
                    dataType: 'html',
                    success: function( data ) {
                        retornoAjax($.parseJSON(data));
                    }
                });
                //var v = parseInt(controle.val())-parseInt(1);
                //controle.attr('value', v);
            }
            var _ref;
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
          }
        });
        // Start UPLOADS:
        uploader.on('addedfile', function(file, xhr, formData){
            BlockUI('.dropzone');
            submit.prop('disabled', true);
            submit.children('span').html('Aguarde carregar os arquivos.');
        });
        // Envia Informações de Sessão e Usuário
        uploader.on('sending', function(file, xhr, formData){
            formData.append('ID', ID);
            formData.append('codigo', codigo);
            formData.append('acao', 'novo');
            formData.append('tipo', tipo);
            
        });
        // Completar UPLOADS:
        uploader.on('queuecomplete', function(file, xhr, formData){ location.reload();
            unBlockUI('.dropzone');
            submit.prop('disabled', false);
            submit.children('span').html( 'Continuar' );
        });
        // Success
        uploader.on("success", function(file, response) {
            //retornoAjax(response);
        });
    })
}


$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    if ( $(e.target).attr('href') == '#tab-imagens' ) {
        imagensAtivas();

    } else if ( $(e.target).attr('href') == '#tab-arquivos' ) {
        arquivosAtivos()
    }
})

$('[excluirImagem]').on('click', function() {
    action = $('.dropzone').attr('action');
    ID = $(this).attr('excluirImagem');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=deletar&arquivo="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[divImagem='+ID+']').fadeTo( "slow", 0.20 );
                $('[btnImagem='+ID+']').html('<h3>Imagem Excluida</h3>').css('color', '#FFF');
                //imagensAtivas()
            }
        }
    });
})

$('[excluirArquivo]').on('click', function() {
    action = $('.dropzone').attr('action');
    ID = $(this).attr('excluirArquivo');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=deletar&arquivo="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[divArquivo='+ID+']').fadeTo( "slow", 0.20 );
                $('[btnArquivo='+ID+']').html('<h3>Arquivo Excluido</h3>').css('color', '#FFF');
                //imagensAtivas()
            }
        }
    });
})


var Legendas = function() {
    var vConfirmar = function(){
        jQuery('.js-legenda').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                'alvo-legenda': {
                    required: true,
                },
                legenda: {
                    //required: true,
                },
            },
            messages: {
                
            },
            ignore: ":hidden:not(#texto),.note-editable.panel-body",
            submitHandler: function( form ){
                var dados = $( form ).serialize();
                var action = $( form ).attr('action');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: dados,
                    success: function( data ) {
                        if(data.success == true) {
                            $('[legenda='+data.ID+']').html( (data.legenda.length > 0) ? data.legenda : '- Sem legenda -' );
                            $('[data='+data.ID+']').html( (data.data.length > 0) ? data.data : '- Sem Data -' );
                        }
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Legendas.init(); });


$('[legendaArquivo]').each( function () {
    $(this).on('click', function() {
        ID = $(this).attr('legendaArquivo');
        legenda = $('[legenda='+ID+']');
        data = $('[data='+ID+']');

        if(legenda.html() != '- Sem Título -') {
            $('#texto-legenda').attr('value', legenda.html());
        } else {
            $('#texto-legenda').attr('value', '');
        }

        if(data.html() != '- Sem Data -') {
            $('#texto-data').val(data.html());
        } else {            
            $('#texto-data').attr('value', '');
        }

        $('#modal-legenda').modal('show');

        $('#alvo-legenda').attr('value',ID);

        $('#modal-legenda').on('hidden.bs.modal', function () {
            $('#texto-legenda').attr('value', '');
            $('#texto-data').attr('value', '');
            $('#alvo-legenda').attr('value', '');
        })
    })
})