<?
class Pesquisas extends APP {
	PRIVATE $APP;

	PUBLIC $pesquisas;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getPesquisas();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('pesquisas_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('pesquisas_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('pesquisas_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function addOpcao($dados) {
		$this->db->insert('pesquisas_opcoes', $dados);
		return $this->db->getInsertID();
	}

	function editOpcao($ID, $dados) {
		$this->db->where('id', $ID);
		return $this->db->update('pesquisas_opcoes', $dados);
	}

	function delOpcao($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('pesquisas_opcoes');
	}
	
	function getPesquisas($true = false) {
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('pesquisas_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->join('pesquisas_respostas r', 'e.id = r.pesquisa', 'LEFT');
		$this->db->join('pesquisas_opcoes o', 'o.pesquisa = e.id', 'LEFT');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		if($true) { $this->db->where('status', 1); }
		$en = $this->db->ObjectBuilder()->get('pesquisas e', NULL, 'e.*, count(distinct(r.id)) as total_respostas, s.nome as secao, s.id as secao_id');
		if($en) {
			foreach($en as $e) {
				$e->{'questoes'} = $this::getOpcoes($e->id);
				$pesquisas[] = $e;
			}
			$this->pesquisas = (object) $pesquisas;
		}
		return $this->pesquisas;
	}

	function getPesquisasView($filtros) {
		$this->db->join('pesquisas_opcoes o', 'o.pesquisa = e.id', 'INNER');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		## Entidade
		if($filtros->ent) {
			$this->db->where('e.entidade', $filtros->ent);
		} else if($this->_auth->entidade->id) {
			$this->db->where('e.entidade', $this->_auth->entidade->id);
		} else {
			$tthis->db->where('e.entidade', $this->entidade->id);
		}
		if($filtros->s) {
			$this->db->join('pesquisas_secoes s', "(s.id = e.secao AND s.nome = '$filtros->s')", 'INNER');
		} else {
			$this->db->join('pesquisas_secoes s', 's.id = e.secao', 'INNER');
		}
		$this->db->having('e.status', 1);
		if($en = $this->db->ObjectBuilder()->get('pesquisas e', NULL, 'e.*, s.nome as secao, s.id as secao_id')) {
			foreach($en as $e) {
				$e->{'questoes'} = $this::getOpcoes($e->id);
				$pesquisas[] = $e;
			}
			$pesquisas = (object) $pesquisas;
		}
		return $pesquisas;
	}

	function getRespostasTextos($p) {
		$questoes = $this::getOpcoes($p->id);
		foreach($questoes as $q) {
			if($q->tipo == 'texto') {
				$Q[] = $q->id;
			}
		}
		$json = '';
		foreach($Q as $q) {
			//$json .= ", r.json->>'$.\"".$q."\"' as q_".$q;
			$json .= ", json_unquote(json_extract(r.json, '$.\"".$q."\"')) as q_".$q;
			$this->db->where('json', '%"'.$q.'":""%', 'NOT LIKE');
		}
		$this->db->where('pesquisa', $p->id);
		$respostas = $this->db->ObjectBuilder()->get('pesquisas_respostas r', null, 'id, data'.$json);
		foreach($respostas as $r) {
			foreach($Q as $q) {
				if($r->{'q_'.$q}) {
					$QQ[$q][] = html_entity_decode($r->{'q_'.$q});
				}
			}
		}
		foreach($Q as $q) {
			$q->respostas = array_values($QQ[$q->id]);
		}
		return $QQ;
	}

	function getPesquisaID($ID) {
		$this->db->where('e.id', $ID);
		//$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('pesquisas_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->join('pesquisas_respostas r', 'e.id = r.pesquisa', 'LEFT');
		$this->db->join('pesquisas_opcoes o', 'o.pesquisa = e.id', 'LEFT');
		$this->db->groupBy('e.id');
		$en = $this->db->ObjectBuilder()->get('pesquisas e', NULL, 'e.*, s.nome as secao, s.id as secao_id, MIN(r.data) as data_inicio, MAX(r.data) as data_final')[0];
		if($en) {
			$en->{'questoes'} = $this::getOpcoes($en->id);
			return $en;
		}
		return $en;
	}

	function getPesquisaSecao($secao) {
		$this->db->where('s.nome', $secao);
		if($this->entidade) {
			$this->db->where('e.entidade', $this->entidade->id);
		} else {
			$this->db->where('e.entidade', $this->_auth->entidade->id);
		}
		$this->db->join('pesquisas_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->join('pesquisas_opcoes o', 'o.pesquisa = e.id', 'LEFT');
		$this->db->OrderBy('e.data', 'DESC');
		$this->db->groupBy('e.id');
		$en = $this->db->ObjectBuilder()->get('pesquisas e', NULL, 'e.*, s.nome as secao, s.id as secao_id')[0];
		if($en) {
			$en->{'questoes'} = $this::getOpcoes($en->id);
			return $en;
		}
		return $en;
	}

	function getOpcoes($ID) {
		$this->db->where('pesquisa', $ID);
		$this->db->orderBy('ordem', 'ASC');
		if($opcoes = $this->db->ObjectBuilder()->get('pesquisas_opcoes')) {
			foreach($opcoes as $o) {
				if($o->json) {
					$o->json = json_decode($o->json, true);
				}
				$O[$o->id] = $o;
			}
		}
		return $O;
	}

	function getOpcaoID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('pesquisas_opcoes');
	}

	function getPesquisaTag($TAG) {
		$this->db->where('tag', $TAG);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$en = $this->db->ObjectBuilder()->getOne('pesquisas');
		if($en) {
			$en->{'questoes'} = $this::getOpcoes($en->id);
			return $en;
		}
		return $en;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('pesquisas'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('pesquisas', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('pesquisas', $dados);
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('pesquisas', $dados);
	}

	function ativarPublico($ID) {
		$dados = array('publico' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('pesquisas', $dados);
	}

	function desativarPublico($ID) {
		$dados = array('publico' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('pesquisas', $dados);
	}

	function excluir($ID) {
		$this->db->where('pesquisa', $ID);
		$this->db->delete('pesquisas_opcoes');

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('pesquisas');
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('pesquisas'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('pesquisas', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes($check = false, $filtros = false) {
		if ($check) {
			$this->db->join('pesquisas e', 'e.secao = s.id', 'INNER');
		} else {
			$this->db->join('pesquisas e', 'e.secao = s.id', 'LEFT');
		}
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('pesquisas_secoes s', null, 's.*');
		return $this->secoes;
	}

	
	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('pesquisas c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL OR c.secao = '$ID')");
		} else {
			$this->db->join('pesquisas c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->having('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		return $this->db->ObjectBuilder()->get('pesquisas_secoes s', null, 's.*');
	}

	function Responder($resposta, $forced = false) {
		if($forced) {
			return $this->db->insert('pesquisas_respostas', $resposta);
		} else {
			$this->db->where('pesquisa', $resposta['pesquisa']);
			$this->db->where('ip', $resposta['ip']);
			if(!$this->db->get('pesquisas_respostas')) {
				return $this->db->insert('pesquisas_respostas', $resposta);
			} else {
				return false;
			}
		}
	}

	function zerarVotos($ID) {
		$dados['votos'] = 0;
		$this->db->where('pesquisa', $ID);
		return $this->db->update('pesquisas_opcoes', $dados);
	}

	function getPesquisasNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {		
		$this->db->join('pesquisas_opcoes o', 'o.pesquisa = e.id', 'INNER');
		$this->db->join('pesquisas_secoes s', 's.id = e.secao', 'LEFT');
		$this->db->where('e.status', 1);
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		if($this->entidade) {
			$this->db->where('e.entidade', $this->entidade->id);
		} else {
			$this->db->where('e.entidade', $this->_auth->entidade->id);
		}
		if ($orderBy) {
			$this->db->OrderBy('e.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('e.data', 'DESC');
		}
		$this->db->groupBy('e.id');

		$this->db->pageLimit = $limitador;
		if ($en = $this->db->ObjectBuilder()->paginate('pesquisas e', $pagina, 'e.*, s.nome as secao'))  {
			foreach($en as $e) {
				$e->{'opcoes'} = $this::getOpcoes($e->id);
				$pesquisas[] = $e;
			}
			$pesquisas = (object) $pesquisas;
			return $pesquisas;
		} else {
			return false;
		}
	}


	function getRelatorio($pesquisa, $filtros = false) {
		$p = $this::getPesquisaID($pesquisa);
		foreach($p->questoes as $q) {
			if($q->json) {
				$Q[] = $q->id;
				$f = false;
				foreach($q->json as $j) {
					$f[html_entity_decode($j)] = 0;
				}
				$QQ[$q->id] = $f;
			}
		}
		$json = '';
		foreach($Q as $q) {
			//$json .= ", r.json->>'$.\"".$q."\"' as q_".$q;
			$json .= ", json_unquote(json_extract(r.json, '$.\"".$q."\"')) as q_".$q;
		}
		$this->db->where('pesquisa', $pesquisa);
		$this->db->groupBy('pesquisa');
		foreach($Q as $q) {
			$this->db->groupBy('q_'.$q);
		}
		$respostas = $this->db->ObjectBuilder()->get('pesquisas_respostas r', null, 'count(id) as respostas '.$json);
		$total = $somar = 0;
		foreach($respostas as $r) {
			$total += $r->respostas;
			$somar = $r->respostas;
			foreach($Q as $q) {
				if($r->{'q_'.$q} != 'on') {
					$QQ[$q][html_entity_decode($r->{'q_'.$q})] += $somar;
				}
			}
		}
		foreach($p->questoes as $q) {
			unset($q->json);
			$q->respostas = $QQ[$q->id];
			$q->resultados = array_sum($QQ[$q->id]);
			//$q->respostas = $QQ[$]->
		}
		$p->total_respostas = $total;
		//var_dump($p);
		return $p;
	}

}

return $PESQUISAS = new Pesquisas($isView);

?>