<?

class Ouvidoria extends APP {
	PRIVATE $APP;

	PUBLIC $ouvidorias;
	PUBLIC $finalidades;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getOuvidorias($_POST['carregar']);
		$this::getFinalidades();
		$this::getStatus();
		$this::getSetup();
	}

	PRIVATE function getSetup() {
		if(!$this->db->ObjectBuilder()->rawQuery('SHOW COLUMNS FROM ouvidoria_setup WHERE Field = "entidade"')){
			$this->db->rawQuery('ALTER TABLE ouvidoria_setup CHANGE COLUMN id id INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD COLUMN entidade INT(11) NOT NULL DEFAULT 0 AFTER email_porta;');

			$this->db->where('matriz', 1);
			$ent = $this->db->ObjectBuilder()->getValue('app_entidades', 'id');
			$this->db->where('id', 1);
			$this->db->update('ouvidoria_setup', array('entidade' => (int) $ent));
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('ouvidoria_setup') ) {
			## Configurações de E-amail
			define('oEMAIL', $this->setup->email_email);
			define('oEMAIL_NOME', $this->setup->email_nome);
			define('oEMAIL_HOST', $this->setup->email_host);
			define('oEMAIL_LOGIN', $this->setup->email_login);
			define('oEMAIL_SENHA', $this->setup->email_senha);
			define('oEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function getSetupEmailEnt($ent) {
		$this->db->where('entidade', $ent);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('ouvidoria_setup') ) {
			## Configurações de E-amail
			define('oEMAIL', $this->setup->email_email);
			define('oEMAIL_NOME', $this->setup->email_nome);
			define('oEMAIL_HOST', $this->setup->email_host);
			define('oEMAIL_LOGIN', $this->setup->email_login);
			define('oEMAIL_SENHA', $this->setup->email_senha);
			define('oEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('ouvidoria_setup', $dados);
		} else {
			$dados['entidade'] = $this->_auth->entidade->id;
			return $this->db->insert('ouvidoria_setup', $dados);
		}
	}

	function startEmail() {
		##### PHP MAILER;
		include ('app/core/PHPMailer/PHPMailerAutoload.php');
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			//$this->email->SMTPDebug = 2;
			$this->email->Host = oEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = oEMAIL_LOGIN;
			$this->email->Password = oEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = oEMAIL_PORTA;
			$this->email->setFrom(oEMAIL, oEMAIL_NOME);
	}


	function enviarEmail($acao, $ID, $ent = false) {

		GLOBAL $APP;
		GLOBAL $path;
		$p = $this::getOuvidoriaID($ID);

		if(!$acao or !$p) { return true; }

		## Iniciar E-mail
		if (!$this->email) { $this->startEmail(); }

		## Prepara Mensagem;
		if($acao == 'criar') {
			$assunto = 'Ouvidoria - Solicitação recebida com sucesso!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Você acaba de enviar uma solicitação ao nosso Ouvidoria.<br>
				Sua solicitação foi recebida com sucesso e será respondida o mais breve possível.<br>';
		} else if ($acao == 'atualizacao') {
			$assunto = 'Ouvidoria - Solicitação atualizada!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Sua solicitação ao nosso Ouvidoria foi atualizada.<br>';
		}

		## Importa Template
		include($path['core'].'template.php');

		## Prepara o Envio
		$this->email->addAddress($p->email);
		$this->email->Subject = $assunto;
		$this->email->Body    = $template;
		$this->email->isHTML(true);
		## Envia
		if (@$this->email->send()) {
			## Informa envio.
			$this->db->where('id', $ID);
			$dados['envio'] = 1;
			$this->db->update('ouvidoria', $dados);
		}
		return true;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('ouvidoria_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('ouvidoria_arquivos');
	}

	function consultaProtocolo($P) {
		$this->db->where('protocolo', $P);
		return $this->db->ObjectBuilder()->getOne('ouvidoria');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('ouvidoria_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('ouvidoria_arquivos');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('ouvidoria_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('ouvidoria_arquivos', $legenda);
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('ouvidoria_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('ouvidoria_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function addResposta($dados) {
		if ( $this->db->insert('ouvidoria_respostas', $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function excluirResposta($ID) {
		if ($r = $this::getRespostaID($ID) ) {
			if ($A = $this::getArquivosCodigo($r->codigo)) {
				foreach ($A as $a) {
					$this::excluirArquivo($a->id);
				}
				$path = $A[0]->path;
				@rmdir($path);
				$from = array('arquivos/', 'imagens/'); $to = array('', '');
				@rmdir(str_replace($from, $to, $path));
			}
		}
		$this->db->where('id' ,$ID);
		if ( $this->db->delete('ouvidoria_respostas') ) {
			return true;
		} else {
			return false;
		}
	}

	function editarResposta($ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('ouvidoria_respostas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function getRespostas($o) {
		$this->db->where('ouvidoria', $o);
		return $this->db->ObjectBuilder()->get('ouvidoria_respostas');
	}

	function getRespostaID($r) {
		$this->db->where('id', $r);
		return $this->db->ObjectBuilder()->getOne('ouvidoria_respostas');
	}
	
	function getOuvidorias($limitador, $status = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->join('ouvidoria_finalidades f', 'f.id = o.finalidade', 'LEFT');
		$this->db->join('ouvidoria_status s', 's.id = o.status', 'LEFT');
		$this->db->where('o.entidade', $this->_auth->entidade->id);
		if ($status) {
			$status = array('Encerrado', 'Encerrados', 'Finalizado', 'Finalizados', 'Despachado', 'Despachados', 'Respondido', 'Respondidos');
			$this->db->where('s.nome', $status, 'IN');
		} else {
			$status = array('Encerrado', 'Encerrados', 'Finalizado', 'Finalizados', 'Despachado', 'Despachados', 'Respondido', 'Respondidos');
			$this->db->where('s.nome', $status, 'NOT IN');
		}
		$this->db->OrderBy('o.data', 'DESC');
		if ($ouvidorias = $this->db->ObjectBuilder()->get('ouvidoria o', $limitador, 'o.*, f.nome as finalidade, o.finalidade as finalidade_id, s.nome as status, s.id as status_id') ) {
			foreach($ouvidorias as $o) {
				$o->{'respostas'} = $this::getRespostas($o->id);
				$OUVIDORIAS[] = $o;
			}
			return $this->ouvidorias = $OUVIDORIAS;
		} else {
			return null;
		}
			
	}

	function getOuvidoriaCodigo($codigo) {
		$this->db->join('ouvidoria_finalidades f', 'f.id = o.finalidade', 'LEFT');
		$this->db->join('ouvidoria_status s', 's.id = o.status', 'LEFT');
		$this->db->where('o.codigo', $codigo);
		$this->db->where('o.entidade', $this->_auth->entidade->id);
		$ouvidoria = $this->db->ObjectBuilder()->get('ouvidoria o', null, 'o.*, f.nome as finalidade, o.finalidade as finalidade_id, s.nome as status, s.id as status_id')[0];
		return $ouvidoria;
	}

	function getOuvidoriaID($ID) {
		$this->db->join('ouvidoria_finalidades f', 'f.id = o.finalidade', 'LEFT');
		$this->db->join('ouvidoria_status s', 's.id = o.status', 'LEFT');
		$this->db->where('o.id', $ID);
		if( $ouvidoria = $this->db->ObjectBuilder()->get('ouvidoria o', null, 'o.*, f.nome as finalidade, o.finalidade as finalidade_id, s.nome as status, s.id as status_id')[0] ) {
			$ouvidoria->{'respostas'} = $this::getRespostas($ouvidoria->id);
		}
		return $ouvidoria;
	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$dados['envio'] = 0;
		if( $this->db->update('ouvidoria', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$o = $this::getOuvidoriaID($ID);

		if ($r = $o->respostas) {
			foreach($r as $r) {
				if ($A = $this::getArquivosCodigo($r->codigo)) {
					foreach ($A as $a) {
						$this::excluirArquivo($a->id);
					}
					$path = $A[0]->path;
					@rmdir($path);
					$from = array($r->codigo); $to = array('', '');
					@rmdir(str_replace($from, $to, $path));
				}
				$R[] = $r->id;
			}
			$this->db->where('id', $R, 'IN');
			$this->db->delete('ouvidoria_respostas');
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('ouvidoria');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('ouvidoria', $dados)){
			$ID = $this->db->getInsertID();
			if($dados['email']) {
				$this::getSetupEmailEnt($dados['entidade']);
				$this::enviarEmail('criar', $ID);
			}
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getFinalidades() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->finalidades = $this->db->ObjectBuilder()->get('ouvidoria_finalidades');
		return $this->finalidades;
	}

	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('ouvidoria_status');
		return $this->status;
	}

	function getStatusPadrao($entidade) {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->db->where('entidade', $entidade);
		$status = $this->db->ObjectBuilder()->getValue('ouvidoria_status', 'id', 1);
		return $status ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('ouvidoria_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('ouvidoria_status', $dados);

		$this->db->where('status', 0);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('ouvidoria', array('status' => $ID));
		return true;
	}

	function notificar($ID) {
		return $this::enviarEmail('atualizacao', $ID);
	}
	
	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('ouvidoria', $update);
	}

}

return $OUVIDORIA = new Ouvidoria($isView);

?>