<?php
require __DIR__ . '/webpush_autoload/autoload.php';  // autoload real do WebPush

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// TESTE DE AUTLOAD
echo "📡 Autoload funcionando!\n";

// --- Configuração de teste do push ---
$subscription = Subscription::create([
    'endpoint' => 'COLE_AQUI_O_TOKEN_DO_DISPOSITIVO',
    'publicKey' => 'COLE_AQUI_A_PUBLIC_KEY_DO_CLIENTE',
    'authToken' => 'COLE_AQUI_O_AUTH_TOKEN_DO_CLIENTE',
    'contentEncoding' => 'aesgcm',
]);

$vapid = [
    'subject' => 'mailto:seuemail@dominio.com',
    'publicKey' => 'SUA_PUBLIC_KEY_VAPID',
    'privateKey' => 'SUA_PRIVATE_KEY_VAPID',
];

$webPush = new WebPush($vapid);

// envia a notificação
$resposta = $webPush->sendOneNotification($subscription, json_encode(['title' => 'Teste', 'body' => 'Mensagem de teste']));

// DEBUG
var_dump($resposta);
