<?
class Noticias extends APP {
	PRIVATE $APP;

	PUBLIC $noticias;
	PUBLIC $secoes;

	function __construct($isView) { GLOBAL $_POST;
		parent::__construct($isView);
		if($isView) {
			$this->isView = true;
		} else {
			$this::getNoticias($_POST['carregar']);
			$this::getSecoes();
		}
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('noticias_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('noticias_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('noticias_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('noticias_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('noticias', array('capa' => 0));
		return true;
	}

	function addLink($dados) {
		if ($this->db->insert('noticias_links', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function addVideo($dados) {
		return $this->db->insert('noticias_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('noticias_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('noticias_videos');
	}

	function getLinks($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('noticias_links');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('noticias_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('noticias_arquivos');
	}

	function atualizaCapa($ID, $dados) {
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('noticias_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('noticias_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('noticias', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('noticias_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('noticias', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('noticias_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('noticias_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		$this->db->OrderBy('legenda', 'ASC');
		$this->db->OrderBy('arquivo', 'ASC');
		return $this->db->ObjectBuilder()->get('noticias_arquivos');
	}

	function galeriaAudios($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'audio');
		return $this->db->ObjectBuilder()->get('noticias_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('noticias_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('noticias_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => API.HD.'noticias/'.$this->entidade->id.'/',
				'arquivo' => 'capa.jpg',
			);
		}
	}

	function setEntidades($noticia, $entidades = false) {
		$this::delEntidades($noticia);
		if($entidades) {
			foreach($entidades as $e) {
				$insert[] = array(
					'noticia' => $noticia,
					'entidade' => $e,
					'usuario' => $this->_auth->usuario->ID
				);
			}
			return $this->db->insertMulti('noticias_entidades', $insert);
		}
		return true;
	}

	function getEntidades($noticia) {
		$this->db->where('noticia', $noticia);
		return $this->db->getValue('noticias_entidades', 'entidade', null);
	}

	function delEntidades($noticia, $entidade = false) {
		$this->db->where('noticia', $noticia);
		if($entidade) { $this->db->where('entidade', $entidade); }
		return $this->db->delete('noticias_entidades');
	}
	
	function getNoticias($limitador) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		if($this->isVereador) {
			$this->db->join('vereadores v', 'v.id = n.vereador', 'INNER');
			$this->db->where('n.vereador', $this->isVereador);
		}
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		$this->db->join('noticias_entidades e', 'e.noticia = n.id', 'LEFT');
		$this->db->join('app_entidades e2', 'n.entidade = e2.id', 'LEFT');
		$this->db->join('app_entidades ee', 'e.entidade = ee.id', 'LEFT');
		$this->db->where('(n.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		$this->db->OrderBy('n.data', 'DESC');
		$this->db->groupBy('n.id');
		if($this->isVereador) {
			$this->noticias = $this->db->ObjectBuilder()->get('noticias n', $limitador, 'n.*, s.nome as secao, s.id as secao_id, ee.id as entidade_id, e2.nome as entidade_nome, v.nome as nome_vereador');
		} else {
			$this->noticias = $this->db->ObjectBuilder()->get('noticias n', $limitador, 'n.*, s.nome as secao, s.id as secao_id, ee.id as entidade_id, e2.nome as entidade_nome');
		}
		return $this->noticias;
	}

	function getNoticiaTag($TAG) {
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		$this->db->where('n.tag', $TAG);
		if($n = $this->db->ObjectBuilder()->getOne('noticias n', 'n.*, s.nome as secao, s.id as secao_id')) {
			$arquivos{'capa'} = $this::getCapaID($n->capa);
			$arquivos{'videos'} = $this::getVideos($n);
			$arquivos{'arquivos'} = $this::galeriaArquivos($n);
			$arquivos{'audios'} = $this::galeriaAudios($n);
			$arquivos{'links'} = $this::getLinks($n);
			$arquivos{'imagens'} = $this::galeriaImagem($n);
			$n->{'arquivos'} = (object) $arquivos;
		}
		return $n;
	}

	function getNoticiaID($ID) {
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		$this->db->where('n.id', $ID);
		$this->db->where('n.entidade', $this->_auth->entidade->id);
		$noticia = $this->db->ObjectBuilder()->getOne('noticias n', 'n.*, s.nome as secao, s.id as secao_id');
		if($n = $noticia) {
			$arquivos{'capa'} = $this::getCapaID($n->capa);
			$arquivos{'videos'} = $this::getVideos($n);
			$arquivos{'arquivos'} = $this::galeriaArquivos($n);
			$arquivos{'audios'} = $this::galeriaAudios($n);
			$arquivos{'links'} = $this::getLinks($n);
			$arquivos{'imagens'} = $this::galeriaImagem($n);
			$noticia->{'arquivos'} = (object) $arquivos;
		}
		return $noticia;
	}

	function destacar($ID, $tipo) {
		$n = $this::getNoticiaID($ID);

		if($n->destaque == $tipo) {
			$data['destaque'] = 0;
			$this->db->where('id', $ID);
			if( $this->db->update('noticias', $data) ) {
				$return['status'] = true;
				$return['acao'] = 0;
			} else {
				return false;
			}
		
		} else {
			$data['destaque'] = $tipo;
			$this->db->where('id', $ID);
			if( $this->db->update('noticias', $data) ) {
				$return['status'] = true;
				$return['acao'] = 1;
			} else {
				return false;
			}
		}
		return (object) $return;

	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('noticias'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('noticias', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('noticias', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('noticias', $dados);
	}

	function excluir($ID) {
		$n = $this::getNoticiaID($ID);

		if($n->entidade != $this->_auth->entidade->id) {
			return $this::delEntidades($ID, $this->_auth->entidade->id);
		}

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('noticias');
	}

	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('noticias_links');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('noticias_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('noticias_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('noticias_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('noticias'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('noticias', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('noticias_secoes');
		return $this->secoes;
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('noticias', $dados);
	}

	function getNoticiasCapa($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		if($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('n.status', 1);
		$this->db->join('noticias_entidades e', 'n.id = e.noticia', 'LEFT');
		$this->db->where('(n.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		$this->db->where('n.destaque', 1);
		if ($orderBy) {
			$this->db->OrderBy('n.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('n.data', 'DESC');
		}
		$this->db->where('n.vereador', 0);
		$this->db->groupBy('n.id');
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('noticias n', 1, 'n.*, s.nome as secao, s.id as secao_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
				$this->_notCapas[] = $n->id;
				$n->{'capa'} = (object) $this::getCapaID($n->capa);
				$noticias[] = (object) $n;
			}
			return $noticias;
		} else {
			return false;
		}
	}

	function getNoticiasNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		if ($this->_notCapas) {
			$this->db->where('n.id', $this->_notCapas, 'NOT IN');
		}
		$this->db->where('n.status', 1);
		$this->db->join('noticias_entidades e', 'n.id = e.noticia', 'LEFT');
		$this->db->where('(n.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		if ($orderBy) {
			$this->db->OrderBy('n.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('n.data', 'DESC');
		}
		if ($this->_remover) {
			$this->db->where('n.id', $this->_remover, 'NOT IN');
		}
		$this->db->where('n.vereador', 0);
		$this->db->groupBy('n.id');
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('noticias n', $pagina, 'n.*, s.nome as secao, s.id as secao_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
				$this->_remover[] = $n->id;
				$n->{'capa'} = (object) $this::getCapaID($n->capa);
				if($limitador == 1) {
					$arquivos{'capa'} = $this::getCapaID($n->capa);
					$arquivos{'videos'} = $this::getVideos($n);
					$arquivos{'arquivos'} = $this::galeriaArquivos($n);
					$arquivos{'audios'} = $this::galeriaAudios($n);
					$arquivos{'links'} = $this::getLinks($n);
					$arquivos{'imagens'} = $this::galeriaImagem($n);
					$n->{'arquivos'} = (object) $arquivos;
				}
				$noticias[] = (object) $n;
			}
			return $noticias;
		} else {
			return false;
		}
	}

	function getNoticiasVereadores($limitador, $tagNome = false, $orderBy = false, $pagina = 1) {
		$this->db->join('vereadores v', 'v.id = n.vereador', 'LEFT');
		$this->db->join('noticias_secoes s', 's.id = n.secao', 'LEFT');
		if ($tagNome) {
			$this->db->where('v.tag', $tagNome);
		}
		if ($orderBy) {
			$this->db->OrderBy('n.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('n.data', 'DESC');
		}
		$this->db->groupBy('n.id');
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('noticias n', $pagina, 'n.*, s.nome as secao, s.id as secao_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
				$this->_remover[] = $n->id;
				$n->{'capa'} = (object) $this::getCapaID($n->capa);
				if($limitador == 1) {
					$arquivos{'capa'} = $this::getCapaID($n->capa);
					$arquivos{'videos'} = $this::getVideos($n);
					$arquivos{'arquivos'} = $this::galeriaArquivos($n);
					$arquivos{'audios'} = $this::galeriaAudios($n);
					$arquivos{'links'} = $this::getLinks($n);
					$arquivos{'imagens'} = $this::galeriaImagem($n);
					$n->{'arquivos'} = (object) $arquivos;
				}
				$noticias[] = (object) $n;
			}
			return $noticias;
		} else {
			return false;
		}
	}

}

return $NOTICIAS = new Noticias($isView);

?>