<?
class Livros extends APP {
	PRIVATE $APP;

	PUBLIC $livros;
	PUBLIC $categorias;

	function __construct($isView) {
		if($isView) {
			$this->isView = true;
		}
		parent::__construct($isView);
		$this::getLivros();
		$this::getCategorias();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
			$this->entidade = $this->_auth->entidade;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('livros_arquivos');
		return true;
	}

	function getObjct($tabela) {
		return $this->db->ObjectBuilder()->get($tabela, null);
	}
	function getArrayExterno($tabela) {
		$this->db->where('local', 0);
		$this->db->where('entidade', $this->_update->entidade);
		return $this->db->get($tabela, null);
	}
	function getObjectExterno($tabela) {
		$this->db->where('local', 0);
		$this->db->where('entidade', $this->_update->entidade);
		return $this->db->ObjectBuilder()->get($tabela, null);
	}

	function receberAtualizacao($POST) {
		$this->_update->entidade = $entidade = $POST['entidade'];
		$this->_update->url_arquivos = $url_arquivos = $POST['url_arquivos'];
		$livros = $POST['livros'];
		$categorias = $POST['categorias'];
		$arquivos = $POST['arquivos'];
		$this::atualizarCategorias($categorias);
		$this::atualizarArquivos($arquivos, $url_arquivos);
		$this::atualizarLivros($livros);
		return true;
	}

	function atualizarCategorias($categorias) {
		$catE = $this::getObjectExterno('livros_categorias');
		// Insere novos;
		foreach($categorias as $c) {
			$c = (object) $c;
			$insert = true;
			foreach($catE as $e) {
				if($e->nome == $c->nome) {
					$insert = false;
					$this->_catDiff[$c->id] = $e->id;
				}
			}
			if($insert) {
				$insert = array(
					'nome' => $c->nome,
					'entidade' => $this->_update->entidade,
					'local' => 0
				);
				$this->db->insert('livros_categorias', $insert);
				$insertID = $this->db->getInsertID();
				$this->_catDiff[$c->id] = $insertID;
			}
		}
		// Deleta desatualizados;
		foreach($catE as $e) {
			$excluir = true;
			foreach($categorias as $c) {
				$c = (object) $c;
				if($c->nome == $e->nome) {
					$excluir = false;
				}
			}
			if($excluir) {
				$this->db->where('id', $e->id);
				$this->db->delete('livros_categorias');
			}
		}
	}

	function atualizarArquivos($arquivos) {
		// Deleta todos;
		$this->db->where('local', 0);
		$this->db->delete('livros_arquivos');
		// Insere novos;
		foreach($arquivos as $a) {
			unset($a['id']);
			$a['path'] = $this->_update->url_arquivos.$a['path'];
			$a['local'] = 0;
			$this->db->insert('livros_arquivos', $a);
			if($a['tipo'] == 'capa') {
				$this->_capas[$a['codigo']] = $this->db->getInsertID();
			}
		}
	}

	function agrupaArquivos($arquivos) {
		foreach($arquivos as $a) {
			$return[$a->codigo][] = $a;
		}
		return $return;
	}

	function atualizarLivros($livros) {
		foreach($livros as $remoto) {
			$catRemoto = $remoto['categoria'];
			$newCat = ($this->_catDiff[$catRemoto] ? $this->_catDiff[$catRemoto] : $catRemoto);
			// Adapta para importar;
			$remoto['categoria'] = $newCat;
			$remoto['local'] = 0;
			$remoto['entidade'] = $this->_update->entidade;
			$remoto['capa'] = ($this->_capas[$remoto['codigo']] ? $this->_capas[$remoto['codigo']] : 0);
			$local = $this::getArrayLivro($remoto['codigo']);

			if($local) {
				$this->db->where('id', $local['id']);
				$this->db->update('livros', $remoto);
				$IDs[] = $local['id'];
			} else {
				$this->db->insert('livros', $remoto);
				$IDs[] = $this->db->getInsertID();
			}
		}
		$this->db->where('local', 0);
		$this->db->where('id', $IDs, 'NOT IN');
		$this->db->delete('livros');
	}

	function getArrayLivro($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->getOne('livros');
	}

	function atualizarSites() {
		$sites = $this::getSites();
		foreach($sites as $s) {
			set_time_limit(1800);
			$dominio = $s->site_dominio;
			$entidade = $s->site_entidade;
			$arquivos = $this::getObjct('livros_arquivos');
			$dados['livros'] = $this::getObjct('livros');
			$dados['categorias'] = $this::getObjct('livros_categorias');
			$dados['arquivos'] = $this::getObjct('livros_arquivos');
			$dados['entidade'] = $entidade;
			$dados['url_arquivos'] = URL_DIR;
			$dados['acao'] = 'atualizar';
			if($this::postURL($dominio, $dados)) {
				$this::informaAtualizacao($s->id);
			}
		}
		return true;
	}

	function informaAtualizacao($site) {
		$this->db->where('id', $site);
		return $this->db->update('livros_sites', array('ultima_atualizacao' => date('Y-m-d H:i:s')));
	}

	function postURL($url, $post) {
		if (substr($url, -1) == '/') { $url = substr($url, 0, -1); };
		$url .= '/adm/app/livros/!/update';
		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_HTTPHEADER, array("Content-type: multipart/form-data"),
		    CURLOPT_URL => $url,
		    CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_POST => true,
		    CURLOPT_SSL_VERIFYHOST => false,
		    CURLOPT_SSL_VERIFYPEER => false,
		    CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_POSTFIELDS => urldecode(http_build_query($post)),
		));
		$return = curl_exec($ch);
		$r = json_decode($return);
		return $r->success;
	}

	function getSites() {
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->ObjectBuilder()->get('livros_sites');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('livros_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('livros_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('livros_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('livros_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('livros_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('livros_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('livros_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('livros_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('livros', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('livros_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('livros', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('livros_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('tipo', 'arquivo');
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('livros_arquivos');
	}
	
	function getLivros() {
		$this->db->join('livros_categorias c', 'c.id = d.categoria', 'LEFT');
		$this->db->where('d.entidade', $this->_auth->entidade->id);
		$this->livros = $this->db->ObjectBuilder()->get('livros d', null, 'd.*, c.nome as categoria');
		return $this->livros;
	}

	function getLivroID($ID) {
		$this->db->where('id', $ID);
		$livro = $this->db->ObjectBuilder()->getOne('livros');
		return $livro;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('livros', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$d = $this::getLivroID($ID);

		if ($A = $this::getArquivosCodigo($d->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('livros');
	}


	function criar($dados) {
		if ($this->db->insert('livros', $dados)){
			return $this->db->getInsertID();
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('livros_arquivos');
	}

	function getCategorias($check = false, $filtros = false) {
		if($check) {
			$this->db->join('livros a', 'a.categoria = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->categorias = $this->db->ObjectBuilder()->get('livros_categorias s', null, 's.*');
		return $this->categorias;
	}

	function getAutores() {
		$this->db->where('entidade', $this->entidade->id);
		$this->db->groupBy('autor');
		$this->db->orderBy('autor', 'ASC');
		return $this->db->ObjectBuilder()->getValue('livros', 'autor', null);
	}

	function getCapaCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->where('tipo', 'capa');
		if ( $capa = $this->db->ObjectBuilder()->getOne('livros_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => URL_ADM.HD.'livros/',
				'arquivo' => 'capa.jpg',
			);
		}
	}

	function getLivrosNews($limitador, $categoria = false, $autor = false, $orderBy = false, $pagina = 1, $titulo = null) {
		$this->db->join('livros a', 'a.codigo = ar.codigo', 'INNER');
		$this->db->join('livros_categorias s', 'a.categoria = s.id', 'LEFT');
		if ($categoria) {
			if (is_array($categoria)) {
				$this->db->where('s.nome', $categoria, 'IN');
			} else {
				$this->db->where('s.nome', $categoria);
			}
		}
		if($titulo) {
			$this->db->where("(a.titulo LIKE '%".$titulo."%' OR a.autor LIKE '%".$titulo."%' OR s.nome LIKE '%".$titulo."%')");
		}
		if ($autor) {
			if (is_array($autor)) {
				$this->db->where('a.autor', $autor, 'IN');
			} else {
				$this->db->where('a.autor', $autor);
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		$this->db->groupBy('a.ID');
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
			if ($orderBy->campo != 'legenda') {
				$this->db->OrderBy('ar.data', 'DESC');
			}
		} else {
			$this->db->orderBy('s.nome', 'ASC');
			$this->db->OrderBy('a.titulo', 'ASC');
		}
		$this->db->where('ar.tipo', 'capa', '!=');
		//$this->db->groupBy('a.ID');
		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('livros_arquivos ar', $pagina, 'ar.*, a.titulo, a.autor, a.ano, s.nome as categoria'))  {
			$return = false;
			foreach($arquivos as $a) {
				$a->capa = $this::getCapaCodigo($a->codigo, true);
				$return[$a->categoria][] = $a;
			}
			$this->totalCount = $this->db->totalCount;
			return $return;
		} else {
			return false;
		}
	}

	function getLivrosList($limitador, $categoria = false, $categoriaNao = false, $orderBy = false, $pagina = 1, $titulo = false) {
		$this->db->join('livros a', 'a.codigo = ar.codigo', 'INNER');
		$this->db->join('livros_categorias s', 'a.categoria = s.id', 'LEFT');
		if ($categoria) {
			if (is_array($categoria)) {
				$this->db->where('s.nome', $categoria, 'IN');
			} else {
				$this->db->where('s.nome', $categoria);
			}
		}
		if($titulo) {
			$this->db->where('a.titulo', $titulo);
		}
		if ($categoriaNao) {
			if (is_array($categoriaNao)) {
				$this->db->where('s.nome', $categoriaNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $categoriaNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
			if ($orderBy->campo != 'legenda') {
				$this->db->OrderBy('ar.legenda', 'ASC');
			}
		} else {
			$this->db->OrderBy('a.titulo', 'ASC');
		}

		$this->db->groupBy('a.id');
		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('livros_arquivos ar', $pagina, 'a.*'))  {
			foreach($arquivos as $a) {
				$a->arquivos = $this::getArquivosCodigo($a->codigo);
			}
			$this->totalCount = $this->db->totalCount;
			var_dump($arquivos);
			return $arquivos;
		} else {
			return false;
		}
	}

	function getLivrosCadastro($limitador, $categoria = false, $categoriaNao = false, $orderBy = false, $pagina = 1, $titulo = null) {
		$this->db->join('livros_categorias s', 'a.categoria = s.id', 'LEFT');
		if ($categoria) {
			if (is_array($categoria)) {
				$this->db->where('s.nome', $categoria, 'IN');
			} else {
				$this->db->where('s.nome', $categoria);
			}
		}
		if(strlen($titulo) > 2) {
			$this->db->where('a.titulo', $titulo);
		}
		if ($categoriaNao) {
			if (is_array($categoriaNao)) {
				$this->db->where('s.nome', $categoriaNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $categoriaNao, '!=');
			}
		}
		$this->db->where('a.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('a.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('a.data', 'DESC');
		}

		$this->db->groupBy('a.id');
		$this->db->pageLimit = $limitador;
		if ($arquivos = $this->db->ObjectBuilder()->paginate('livros a', $pagina, 'a.*'))  {
			foreach($arquivos as $a) {
				$a->arquivos = $this::getArquivosCodigo($a->codigo);
			}
			return $arquivos;
		} else {
			return false;
		}
	}
}

return $LIVROS = new Livros($isView);

?>