var Editar = function() {
    var vEditar = function(){
        jQuery('#form-editar').each(function() {
            $($(this)).validate({
                errorClass: 'help-block text-right animated fadeInDown',
                errorElement: 'div',
                errorPlacement: function(error, e) {
                    jQuery(e).parents('.form-group > div').append(error);
                },
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');                
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    data: {
                        required: true
                    },
                    hora: {
                        required: true
                    },
                    sessao: {
                        required: true
                    },
                    titulo: {
                        required: true
                    }
                },
                messages: {
                    data: {
                        required: 'Insira uma data válida'
                    },
                    hora: {
                        required: 'Insira uma hora válida'
                    },
                    sessao: {
                        required: 'Selecione ou insira uma seção'
                    },
                    titulo: {
                        required: 'Insira um nome para a galeria'
                    }
                },
                submitHandler: function( form ){
                    
                    var dados = $( form ).serialize();
                    var action = $( form ).attr('action');

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });

                    return false;
                }
            });
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vEditar();
        }
    };
}();
jQuery(function(){ Editar.init(); });