<?
class Licencas extends APP {
	PRIVATE $APP;

	PUBLIC $downloads;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
		$this::getDownloads();
	}

	function getEmpreendimentos() {
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('nome', 'ASC');
		return $this->db->ObjectBuilder()->get('licencas_empreendimentos');
	}

	function getTipos() {
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('nome', 'ASC');
		return $this->db->ObjectBuilder()->get('licencas_tipos');
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('licencas_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('licencas_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('licencas_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('licencas_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('licencas_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('licencas_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('licencas_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('licencas_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('licencas_arquivos');
	}
	
	function getDownloads() {
		$this->db->join('licencas_tipos t', 't.id = l.licenca', 'LEFT');
		$this->db->join('licencas_empreendimentos e', 'e.id = l.tipo', 'LEFT');
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('l.data', 'desc');
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		$this->downloads = $this->db->ObjectBuilder()->get('licencas l', null, 'l.*, t.nome as tipo_nome, e.nome as empreendimento_nome');
		return $this->downloads;
	}

	function getDownloadID($ID) {
		$this->db->where('id', $ID);
		$download = $this->db->ObjectBuilder()->getOne('licencas');
		return $download;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('licencas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$d = $this::getDownloadID($ID);

		if ($A = $this::getArquivosCodigo($d->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('licencas');
	}


	function criar($dados) {
		if ($this->db->insert('licencas', $dados)){
			return $this->db->getInsertID();
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function soNumero($str) {
	    return preg_replace("/[^0-9]/", "", $str);
	}

	function getLicencas($documento = null, $limite = 9999, $pag = 1, $tipo = false, $emp = false) {
		if($documento) {
			$documentoSN = $this::soNumero($documento);
			$this->db->where("(l.documento = '$documentoSN' OR l.nome LIKE '%$documento%')");
		}
		$this->db->pageLimit = $limite;
		$this->db->join('licencas_tipos t', 't.id = l.licenca', 'LEFT');
		$this->db->join('licencas_empreendimentos e', 'e.id = l.tipo', 'LEFT');
		$this->db->where('l.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('l.data', 'desc');
		foreach($this->db->ObjectBuilder()->paginate('licencas l', $pag, 'l.*, t.nome as tipo_nome, e.nome as empreendimento_nome') as $l) {
			$this->totalCount = $this->db->totalCount;
			$l->{'arquivos'} = $this::getArquivosCodigo($l->codigo);
			$licencas[] = $l;
		}
		return $licencas;
	}
}

return $LICENCAS = new Licencas($isView);

?>