<?
class Galerias extends APP {
	PRIVATE $APP;

	PUBLIC $galerias;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getGalerias();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('galeria', $ID);
		$this->db->where('capa', 1);
		if($capa = $this->db->ObjectBuilder()->getOne('galerias_arquivos')) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('galerias_arquivos', $dados) ) {	

				$data = array('img_capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('galerias', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('galerias_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('img_capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('galerias', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('galerias_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('galerias_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('galerias_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('galerias_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getGalerias() {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->galerias = $this->db->ObjectBuilder()->get('galerias g', null, 'g.*, s.nome as secao, s.id as secao_id');
		return $this->galerias;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('galerias_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('galerias_arquivos');
	}

	function getImagens($id) {
		$this->db->where('galeria', $id);
		$this->db->orderBy('capa', 'DESC');
		return $this->db->ObjectBuilder()->get('galerias_arquivos');
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('galerias_arquivos', $legenda);
	}


	function getGaleria($ID) {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		$this->db->where('g.entidade', $this->_auth->entidade->id);
		$this->db->where('g.id', $ID);
		$galeria = $this->db->ObjectBuilder()->getOne('galerias g', 'g.*, s.nome as secao, s.id as secao_id');
		return $galeria;
	}

	function destacar($ID, $tipo) {
		$n = $this::getGaleria($ID);

		if($n->capa == $tipo) {
			$data['capa'] = 0;
			$this->db->where('id', $ID);
			$this->db->update('galerias', $data);
			$return['status'] = true;
			$return['acao'] = 0;
		
		} else {
			$data['capa'] = $tipo;
			$this->db->where('id', $ID);
			$this->db->update('galerias', $data);
			$return['status'] = true;
			$return['acao'] = 1;
		}
		return (object) $return;

	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('galerias', $dados);
	}
	function excluir($ID) {
		if ($A = $this::getImagens($ID)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('galerias');
	}
	function adicionar($dados) {
		if ($this->db->insert('galerias', $dados)){
			return $this->db->getInsertId();
		} else {
			return false;
		}
	}

	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('galerias a', 'a.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('galerias_secoes s', null, 's.*');
		return $this->secoes;
	}
	function viewCategoriasArquivos($filtros = false) {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('g.entidade', $filtros->ent);
		} else {
			$this->db->where('g.entidade', $this->_auth->entidade->id);
		}
		# SEÇÃO
		if($filtros->s) {
			$this->db->where("s.nome", $filtros->s);
		}

		$this->db->OrderBy('g.data', 'DESC');
		$this->db->OrderBy('g.titulo', 'ASC');
		if ( $d = $this->db->ObjectBuilder()->get('galerias g', null, 'g.*, s.nome as secao, s.id as secao_id') ) {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getImagens($d->id);
				$this->return[$d->id] = $d;
			};
			return $this->return;
		} else {
			return null;
		}
	}
	function viewCategoriasArquivosCapas($filtros = false) {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('g.entidade', $filtros->ent);
		} else {
			$this->db->where('g.entidade', $this->_auth->entidade->id);
		}
		# SEÇÃO
		if($filtros->s) {
			$this->db->where("s.nome", $filtros->s);
		}
		$this->db->where('g.capa', 1);
		$this->db->OrderBy('g.data', 'DESC');
		$this->db->OrderBy('g.titulo', 'ASC');
		if ( $d = $this->db->ObjectBuilder()->get('galerias g', null, 'g.*, s.nome as secao, s.id as secao_id') ) {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getImagens($d->id);
				$this->return[$d->id] = $d;
			};
			return $this->return;
		} else {
			return null;
		}
	}

	function getGaleriasNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('g.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('g.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('g.data', 'DESC');
		}
		$this->db->pageLimit = $limitador;
		if ($d = $this->db->ObjectBuilder()->paginate('galerias g', $pagina, 'g.*, s.nome as secao, s.id as secao_id'))  {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getImagens($d->id);
				$this->return[$d->id] = $d;
			};
			return $this->return;
		} else {
			return false;
		}
	}

	function getGaleriasCapas($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('galerias_secoes s', 's.id = g.secao', 'LEFT');
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->where('g.entidade', $this->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy('g.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('g.data', 'DESC');
		}
		$this->db->where('g.capa', 1);
		$this->db->pageLimit = $limitador;
		if ($d = $this->db->ObjectBuilder()->paginate('galerias g', $pagina, 'g.*, s.nome as secao, s.id as secao_id'))  {
			$this->return = false;
			foreach($d as $d) {
				$d->{'arquivos'} = $this::getImagens($d->id);
				$this->return[$d->id] = $d;
			};
			return $this->return;
		} else {
			return false;
		}
	}
}

return $GALERIAS = new Galerias($isView);

?>