<?
class FAQ extends APP {
	PRIVATE $APP;

	PUBLIC $faqs;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getFaqs();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('faq_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('faq_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('faq_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function getFaqs() {
		$this->db->join('faq_secoes s', 's.id = f.secao', 'LEFT');
		$this->db->where('f.entidade', $this->_auth->entidade->id);
		$this->faqs = $this->db->ObjectBuilder()->get('faq f', null, 'f.*, s.nome as secao, f.secao as secao_id');
		return $this->faqs;
	}

	function getFaqID($ID) {
		$this->db->where('id', $ID);
		$faq = $this->db->ObjectBuilder()->getOne('faq');
		return $faq;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('faq', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('faq');
	}


	function criar($dados) {
		if ($this->db->insert('faq', $dados)){
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('faq', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('faq', $dados);
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('faq_secoes');
		return $this->secoes;
	}

	function viewSecoesFAQs($filtros = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(f.data)', $filtros->ano);
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('f.entidade', $filtros->ent);
		} else {
			$this->db->where('f.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("f.pergunta LIKE '%$filtros->b%'");
			$this->db->orWhere("f.resposta LIKE '%$filtros->b%'");
		}
		# SEÇÃO
		if($filtros->secao) {
			$this->db->where("s.nome LIKE '%$filtros->secao%'");
		}

		$this->db->join('faq_secoes s', 's.id = f.secao', 'LEFT');
		$this->db->OrderBy('s.nome', 'ASC');
		//$this->db->OrderBy('f.data', 'DESC');
		$this->db->OrderBy('f.pergunta', 'ASC');
		$this->db->groupBy('f.id');
		if ( $F = $this->db->ObjectBuilder()->get('faq f', null, 'f.*, s.nome as secao') ) {
			foreach($F as $f) {
				$return[$f->secao][] = $f;
			}
			return $return;
		} else {
			return null;
		}		
	}

}

return $FAQ = new FAQ($isView);

?>