<?
class FaleConosco extends APP {
	PRIVATE $APP;

	PUBLIC $mensagens;
	PUBLIC $secoes;
	PUBLIC $setup;

	function __construct($isView, $ent = false) {
		GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getMensagens($_POST['carregar']);
		$this::getSecoes();
		$this::getSetup();
		if($ent) {
			$this->_auth->entidade = $this::getEntidade($ent);
		} else if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	PRIVATE function getSetup() {
		if(!$this->db->ObjectBuilder()->rawQuery('SHOW COLUMNS FROM faleconosco_setup WHERE Field = "entidade"')){
			$this->db->rawQuery('ALTER TABLE faleconosco_setup CHANGE COLUMN id id INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD COLUMN entidade INT(11) NOT NULL DEFAULT 0 AFTER email_porta;');

			$this->db->where('matriz', 1);
			$ent = $this->db->ObjectBuilder()->getValue('app_entidades', 'id');
			$this->db->where('id', 1);
			$this->db->update('faleconosco_setup', array('entidade' => (int) $ent));
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('faleconosco_setup') ) {
			## Configurações de E-amail
			define('mEMAIL', $this->setup->email_email);
			define('mEMAIL_NOME', $this->setup->email_nome);
			define('mEMAIL_HOST', $this->setup->email_host);
			define('mEMAIL_LOGIN', $this->setup->email_login);
			define('mEMAIL_SENHA', $this->setup->email_senha);
			define('mEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('faleconosco_setup', $dados);
		} else {
			return $this->db->insert('faleconosco_setup', $dados);
		}
	}

	function startEmail() {
		##### PHP MAILER;
		include ('app/core/PHPMailer/PHPMailerAutoload.php');
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			//$this->email->SMTPDebug = 2;
			$this->email->Host = mEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = mEMAIL_LOGIN;
			$this->email->Password = mEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = mEMAIL_PORTA;
			$this->email->setFrom(mEMAIL, mEMAIL_NOME);
	}


	function enviarEmail($acao, $ID) {

		GLOBAL $APP;
		GLOBAL $path;
		$m = $this::getMensagemID($ID);
		
		if(!$acao or !$m) { return true; }

		## Iniciar E-mail
		if (!$this->email) { $this->startEmail(); }

		## Prepara Mensagem;
		if($acao == 'criar') {
			$assunto = 'Fale Conosco - Mensagem recebida com sucesso!';
			$mensagem = 'Olá, <b>'.$m->nome.'.</b><br>
				Sua mensagem abaixo foi recebida com sucesso e será respondida o mais breve possível.<br>Obrigado!<br><br>';
				$mensagem .= 'Mensagem: <br>"'.$m->mensagem.'"<br><br><br>';
		} else if ($acao == 'atualizacao') {
			$assunto = 'Fale Conosco - Mensagem respondida!';
			$mensagem = 'Olá, '.$m->nome.'.<br>
				Estamos respondendo sua mensagem abaixo.<br><br>';
				$mensagem .= '<b>Mensagem:</b> <br>'.$m->mensagem.'<br><br>';
				$mensagem .= '<b>Resposta:</b> <br>'.$m->resposta;
		}

		## Importa Template
		include($path['core'].'template.php');

		## Prepara o Envio
		$this->email->addAddress($m->email);
		$this->email->Subject = $assunto;
		$this->email->Body    = $template;
		$this->email->isHTML(true);
		## Envia
		if (@$this->email->send()) {
			return true;
			## Informa envio.
			$this->db->where('id', $ID);
			$dados['envio'] = 1;
			$this->db->update('faleconosco', $dados);
		} else {
			return false;
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('faleconosco_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('faleconosco_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('faleconosco_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function getMensagens($limitador) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->join('faleconosco_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->murais = $this->db->ObjectBuilder()->get('faleconosco t', $limitador, 't.*, g.nome as secao, t.secao as secao_id');
		return $this->murais;
	}

	function getMensagemTag($TAG) {
		$this->db->join('faleconosco_secoes g', 'g.id = secao AND g.id = '.$TAG, 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$mensagem = $this->db->ObjectBuilder()->get('faleconosco t', null, 't.*, g.nome as secao, t.secao as secao_id')[0];
		return $mensagem;
	}

	function getMensagemID($ID) {
		$this->db->where('id', $ID);
		$mensagem = $this->db->ObjectBuilder()->getOne('faleconosco');
		return $mensagem;
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('faleconosco', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getMensagemID($ID);

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('faleconosco');
	}


	function criar($dados) {
		if ($this->db->insert('faleconosco', $dados)){
			$this::enviarEmail('criar', $this->db->getInsertID());
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('faleconosco', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('faleconosco', $dados);
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('faleconosco_secoes');
		return $this->secoes;
	}

	function getSecoesDisp($ID = null) {
		if($ID) {
			$this->db->join('faleconosco c', "c.secao = s.id", 'LEFT');
			$this->db->where("(c.id IS NULL) OR (c.secao = '$ID')");
		} else {
			$this->db->join('faleconosco c', "c.secao = s.id", 'LEFT');
			$this->db->where("c.id IS NULL");
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('s.id');
		$this->secoes = $this->db->ObjectBuilder()->get('faleconosco_secoes s', null, 's.*');
		return $this->secoes;
	}

	function notificar($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 1;
		$this->db->update('faleconosco', $update);
		return $this::enviarEmail('atualizacao', $ID);
	}

	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('faleconosco', $update);
	}

}

return $FALECONOSCO = new FaleConosco($isView);

?>