<?
class Esic extends APP {
	PRIVATE $APP;

	PUBLIC $esics;
	PUBLIC $status;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getEsics($_POST['carregar']);
		$this::getStatus();
		$this::getSetup();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	PRIVATE function getSetup() {
		if(!$this->db->ObjectBuilder()->rawQuery('SHOW COLUMNS FROM esic_setup WHERE Field = "entidade"')){
			$this->db->rawQuery('ALTER TABLE esic_setup CHANGE COLUMN id id INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD COLUMN entidade INT(11) NOT NULL DEFAULT 0 AFTER email_porta;');

			$this->db->where('matriz', 1);
			$ent = $this->db->ObjectBuilder()->getValue('app_entidades', 'id');
			$this->db->where('id', 1);
			$this->db->update('esic_setup', array('entidade' => (int) $ent));
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ( $this->setup = $this->db->ObjectBuilder()->getOne('esic_setup') ) {
			## Configurações de E-amail
			define('eEMAIL', $this->setup->email_email);
			define('eEMAIL_NOME', $this->setup->email_nome);
			define('eEMAIL_HOST', $this->setup->email_host);
			define('eEMAIL_LOGIN', $this->setup->email_login);
			define('eEMAIL_SENHA', $this->setup->email_senha);
			define('eEMAIL_PORTA', $this->setup->email_porta ?? 587);
		} else {
			return false;
		}
	}

	function configEmail($dados) {
		if($this->setup) {
			$this->db->where('id', $this->setup->id);
			return $this->db->update('esic_setup', $dados);
		} else {
			return $this->db->insert('esic_setup', $dados);
		}
	}

	function startEmail() {
		##### PHP MAILER;
		include ('app/core/PHPMailer/PHPMailerAutoload.php');
		$this->email = new PHPMailer;
			$this->email->isSMTP();
			$this->email->Host = eEMAIL_HOST;
			$this->email->SMTPAuth = true;
			$this->email->Username = eEMAIL_LOGIN;
			$this->email->Password = eEMAIL_SENHA;
			$this->email->SMTPSecure = 'ssl'; // ssl / tls
			$this->email->Port = eEMAIL_PORTA;
			$this->email->setFrom(eEMAIL, eEMAIL_NOME);
	}


	function enviarEmail($acao, $ID) {

		GLOBAL $APP;
		GLOBAL $path;
		$p = $this::getEsicID($ID);
		
		if(!$acao or !$p) { return true; }

		## Iniciar E-mail
		if (!$this->email) { $this->startEmail(); }

		## Prepara Mensagem;
		if($acao == 'criar') {
			$assunto = 'e-Sic - Solicitação recebida com sucesso!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Você acaba de enviar uma solicitação ao nosso e-Sic.<br>
				Sua solicitação foi recebida com sucesso e será respondida o mais breve possível.<br>';
		} else if ($acao == 'atualizacao') {
			$assunto = 'e-Sic - Solicitação atualizada!';
			$mensagem = 'Olá, '.$p->nome.'.<br>
				Sua solicitação ao nosso e-Sic foi atualizada.<br>';
		}

		## Importa Template
		include($path['core'].'template.php');

		## Prepara o Envio
		$this->email->addAddress($p->email);
		$this->email->Subject = $assunto;
		$this->email->Body    = $template;
		$this->email->isHTML(true);
		## Envia
		if (@$this->email->send()) {
			## Informa envio.
			$this->db->where('id', $ID);
			$dados['envio'] = 1;
			$this->db->update('esic', $dados);
		}
		return true;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('esic_arquivos');
		return true;
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('esic_arquivos');
	}

	function consultaProtocolo($P) {
		$this->db->where('protocolo', $P);
		return $this->db->ObjectBuilder()->getOne('esic');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('esic_arquivos');
	}

	function galeriaArquivos($o) {
		$this->db->where('codigo', $o->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('esic_arquivos');
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('esic_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('esic_arquivos', $legenda);
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('esic_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('esic_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function addResposta($dados) {
		if ( $this->db->insert('esic_respostas', $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function excluirResposta($ID) {
		if ($r = $this::getRespostaID($ID) ) {
			if ($A = $this::getArquivosCodigo($r->codigo)) {
				foreach ($A as $a) {
					$this::excluirArquivo($a->id);
				}
				$path = $A[0]->path;
				@rmdir($path);
				$from = array('arquivos/', 'imagens/'); $to = array('', '');
				@rmdir(str_replace($from, $to, $path));
			}
		}
		$this->db->where('id' ,$ID);
		if ( $this->db->delete('esic_respostas') ) {
			return true;
		} else {
			return false;
		}
	}

	function editarResposta($ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('esic_respostas', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function getRespostas($e) {
		$this->db->where('esic', $e);
		return $this->db->ObjectBuilder()->get('esic_respostas');
	}

	function getRespostaID($r) {
		$this->db->where('id', $r);
		return $this->db->ObjectBuilder()->getOne('esic_respostas');
	}
	
	function getEsics($limitador, $status = false) {
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->join('esic_status s', 's.id = e.status', 'LEFT');
		if ($status) {
			$status = array('Finalizado', 'Finalizados');
			$this->db->where('s.nome', $status, 'IN');
		} else {
			$status = array('Finalizado', 'Finalizados');
			$this->db->where('s.nome', $status, 'NOT IN');
		}
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('e.data', 'DESC');
		if ($esics = $this->db->ObjectBuilder()->get('esic e', $limitador, 'e.*, s.nome as status, s.id as status_id') ) {
			foreach($esics as $e) {
				$e->{'respostas'} = $this::getRespostas($e->id);
				$ESIC[] = $e;
			}
			return $this->esics = $ESIC;
		} else {
			return null;
		}
			
	}

	function getEsicCodigo($codigo) {
		$this->db->join('esic_status s', 's.id = e.status', 'LEFT');
		$this->db->where('e.codigo', $codigo);
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$esic = $this->db->ObjectBuilder()->get('esic e', null, 'e.*, s.nome as status, s.id as status_id')[0];
		return $esic;
	}

	function getEsicID($ID) {
		$this->db->join('esic_status s', 's.id = e.status', 'LEFT');
		$this->db->where('e.id', $ID);
		$esic = $this->db->ObjectBuilder()->get('esic e', null, 'e.*, s.nome as status, s.id as status_id')[0];
		$esic->{'respostas'} = $this::getRespostas($esic->id);
		return $esic;
	}

	function getUsuarioID($ID) {
		$this->db->where('ID', $ID);
		return $this->db->ObjectBuilder()->getOne('app_usuarios');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$dados['envio'] = 0;
		if( $this->db->update('esic', $dados) ) {
			return true;
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$o = $this::getEsicID($ID);

		if ($r = $o->respostas) {
			foreach($r as $r) {
				if ($A = $this::getArquivosCodigo($r->codigo)) {
					foreach ($A as $a) {
						$this::excluirArquivo($a->id);
					}
					$path = $A[0]->path;
					@rmdir($path);
					$from = array($r->codigo); $to = array('', '');
					@rmdir(str_replace($from, $to, $path));
				}
				$R[] = $r->id;
			}
			$this->db->where('id', $R, 'IN');
			$this->db->delete('esic_respostas');
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('esic');
	}


	function criar($dados) {
		$dados['status'] = $this::getStatusPadrao($dados['entidade']);
		if ($this->db->insert('esic', $dados)){
			$ID = $this->db->getInsertID();
			if($dados['email']) {
				$this::enviarEmail('criar', $ID);
			}
			return true;
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getStatus() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->status = $this->db->ObjectBuilder()->get('esic_status');
		return $this->status;
	}

	function getStatusPadrao($entidade) {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('padrao', 1);
		$this->db->where('entidade', $entidade);
		$status = $this->db->ObjectBuilder()->getValue('esic_status', 'id', 1);
		return $status ?? 0;
	}

	function padraoStatus($ID) {
		$dados['padrao'] = 0;
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('esic_status', $dados);

		$dados['padrao'] = 1;
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('esic_status', $dados);

		$this->db->where('status', 0);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->update('esic', array('status' => $ID));
		return true;
	}

	function notificar($ID) {
		return $this::enviarEmail('atualizacao', $ID);
	}
	
	function resetEnvio($ID) {
		$this->db->where('id', $ID);
		$update['envio'] = 0;
		$this->db->update('esic', $update);
	}

}

return $ESIC = new Esic($isView);

?>