<?
class Engenharia extends APP {
	PRIVATE $APP;

	PUBLIC $projetos;

	function __construct($isView) { GLOBAL $_POST;
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('engenharia_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('engenharia_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('engenharia_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('engenharia_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('engenharia', array('capa' => 0));
		return true;
	}

	function getAndamentos($p) {
		$this->db->where('engenharia', $p->id);
		return $this->db->ObjectBuilder()->get('engenharia_andamento');
	}

	function getModalidades() {
		$this->db->OrderBy('ID', 'ASC');
		return $this->db->ObjectBuilder()->get('engenharia_modalidades');
	}

	function addLink($dados) {
		if ($this->db->insert('engenharia_links', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function addVideo($dados) {
		return $this->db->insert('engenharia_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('engenharia_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('engenharia_videos');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('engenharia_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('engenharia_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('engenharia_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('engenharia_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('engenharia', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('engenharia_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('engenharia', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('engenharia_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		$this->db->OrderBy('id', 'DESC');
		return $this->db->ObjectBuilder()->get('engenharia_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('engenharia_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('engenharia_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('engenharia_arquivos') ){
			return $capa;
		} else {
			return false;
		}
	}
	
	function getEngenharias($limitador = false, $count = false) {
		if(!$limitador) { $limitador = 300; } else if  ($limitador == 'all') { $limitador = null; }
		$this->db->join('engenharia_andamento a', 'a.engenharia = e.id', 'LEFT');
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('a.id', 'DESC');
		$this->db->groupBy('e.id, a.engenharia');
		$projetos = $this->db->ObjectBuilder()->get('engenharia e', $limitador, 'e.*, COUNT(a.id) as andamento');
		if ($this->isView or $count) {
			if($projetos) {
				$num = 0;
				foreach($projetos as $p) {
					$arquivos{'capa'} = $this::getCapaID($n->capa);
					$arquivos{'videos'} = $this::getVideos($n->codigo);
					$arquivos{'arquivos'} = $this::galeriaArquivos($n->codigo);
					$arquivos{'imagens'} = $this::galeriaImagem($n->codigo);
					$p->{'arquivos'} = (object) $arquivos;
				}
				return $this->projetos = $projetos;
			} else {
				return false;
			}
		}
		return $this->projetos = $projetos;
	}

	function getEngenhariaTag($TAG) {
		$this->db->join('engenharia_modalidades m', 'e.modalidade = m.id', 'LEFT');
		$this->db->where('e.tag', $TAG);
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$engenharia = $this->db->ObjectBuilder()->getOne('engenharia e', 'e.*, m.nome as modalidade, m.id as ID_modalidade');
		if($engenharia) {
			$engenharia->{'andamento'} = $this::getExecucoesEngenhariaID($engenharia->id);
			$arquivos{'capa'} = $this::getCapaID($engenharia->capa);
			$arquivos{'videos'} = $this::getVideos($engenharia);
			$arquivos{'arquivos'} = $this::galeriaArquivos($engenharia);
			$arquivos{'imagens'} = $this::galeriaImagem($engenharia);
			$engenharia->{'arquivos'} = (object) $arquivos;
		}
		return $engenharia;
	}

	function getExecucoesEngenhariaID($ID) {
		$this->db->where('engenharia', $ID);
		return $this->db->ObjectBuilder()->get('engenharia_andamento');
	}

	function getEngenhariaID($ID) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$engenharia = $this->db->ObjectBuilder()->getOne('engenharia');
		if($engenharia) {
			$arquivos{'capa'} = $this::getCapaID($n->capa);
			$arquivos{'videos'} = $this::getVideos($n);
			$arquivos{'arquivos'} = $this::galeriaArquivos($n);
			$arquivos{'imagens'} = $this::galeriaImagem($n);
			$engenharia->{'arquivos'} = (object) $arquivos;
		}
		return $engenharia;
	}
	function getEngenhariaExecucaoID($ID) {
		$this->db->where('id', $ID);
		$engenharia = $this->db->ObjectBuilder()->getOne('engenharia_andamento');
		if($engenharia) {
			$engenharia->{'projeto'} = $this::getEngenhariaID($engenharia->engenharia);
		}
		return $engenharia;
	}

	function destacar($ID, $tipo) {
		$n = $this::getEngenhariaID($ID);

		if($n->destaque == $tipo) {
			$data['destaque'] = 0;
			$this->db->where('id', $ID);
			if( $this->db->update('engenharia', $data) ) {
				$return['status'] = true;
				$return['acao'] = 0;
			} else {
				return false;
			}
		
		} else {
			$data['destaque'] = $tipo;
			$this->db->where('id', $ID);
			if( $this->db->update('engenharia', $data) ) {
				$return['status'] = true;
				$return['acao'] = 1;
			} else {
				return false;
			}
		}
		return (object) $return;

	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('engenharia'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('engenharia', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function editarAndamento($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('engenharia_andamento'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		if( $this->db->update('engenharia_andamento', $dados) ) {
			return $this::getEngenhariaExecucaoID($ID)->projeto->tag;
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('engenharia', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('engenharia', $dados);
	}

	function desativarAndamento($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		return $this->db->update('engenharia_andamento', $dados);
	}

	function ativarAndamento($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		return $this->db->update('engenharia_andamento', $dados);
	}

	function excluir($ID) {
		$n = $this::getEngenhariaID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('engenharia');
	}

	function excluirAndamento($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('engenharia_andamento');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('engenharia_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('engenharia_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('engenharia_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('engenharia'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('engenharia', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	function criarAndamento($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('engenharia_andamento'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('engenharia_andamento', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('secao', 'ASC');
		$this->db->groupBy('secao');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->getValue('engenharia', 'secao', null);
		return $this->secoes;
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('engenharia', $dados);
	}


	function viewCategoriasArquivos($filtros = false, $ordem = false) {
		# ANO
		if ($filtros->ano) {
			$this->db->where("('$filtros->ano' BETWEEN YEAR(p.data_inicio) AND YEAR(p.data_final))");
		}
		# ENTIDADE
		if ($filtros->ent) {
			$this->db->where('p.entidade', $filtros->ent);
		} else {
			$this->db->where('p.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("(p.titulo LIKE '%$filtros->b%' OR p.texto LIKE '%$filtros->b%')");
		}
		$this->db->join('engenharia_modalidades m', 'p.modalidade = m.id', 'LEFT');
		$this->db->join('engenharia_andamento a', 'a.engenharia = p.id', 'LEFT');
		$this->db->OrderBy('p.status', 'ASC');
		if($ordem) {
			$this->db->orderBy('p.'.$ordem->campo, $ordem->ordem);
		} else {
			$this->db->OrderBy('p.data_inicio', 'DESC');
			$this->db->OrderBy('p.titulo', 'ASC');
		}
		$this->db->groupBy('p.id');
		if ( $d = $this->db->ObjectBuilder()->get('engenharia p', null, 'p.*, m.nome as modalidade, count(a.ID) as andamento') ) {
			$this->return = false;
			foreach($d as $d) {
				if ($d->status == 1 AND $d->data_final) {
					$status = 'Em Andamento';
				} else if($d->data_final) {
					$status = 'Finalizado';
				} else {
					$status = 'Relatrios Mensais';
				}

				$d->{'capa'} = $this::getCapaID($d->capa);
				$d->{'arquivos'} = $this::galeriaArquivos($d);

				$return[$status][$d->id] = $d;
			}
			ksort($return);
			return $return;
		} else {
			return null;
		}		
	}

}

return $ENGENHARIA = new Engenharia($isView);

?>