<?
class Ead extends APP {

	PRIVATE $APP;
	PUBLIC $alunosNovos = 0;

	function __construct($isView) { GLOBAL $_POST;
		parent::__construct($isView);
		if($isView) {
			$this->isView = true;
		} else {
			$this::getAulas($_POST['carregar']);
		}
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
		if ($this->_professor) {
			$professor = $this::getProfessores($this->_auth->usuario->ID);
			$this->_escolas = json_decode($professor->escolas, true);
			$this->_salas = json_decode($professor->salas, true);
			$this->_materias = json_decode($professor->materias, true);
			$this->_series = json_decode($professor->series, true);
			$this->_niveis = json_decode($professor->niveis, true);
		
		} else if(!$isView AND !$this->_auth->_admin){
			$this->acesso = $this::getUsuarios($this->_auth->usuario->ID);
			if(!$this->acesso->_admin) {
				$this->isEscolar = true;
			}
		}
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('ead_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('ead_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('ead_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setAcesso($ID, $escolas, $acesso = null) {
		$this::setEscolas($ID, $escolas);
		$this::set_Acesso($ID, $acesso);
		return true;
	}
	function set_Acesso($ID, $acesso) {
		if($acesso == 0) {
			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('ead_acessos');

		} else if ( $reg = $this::consultaAcesso($ID) ) {
			$dados = array ('usuario' => $ID, 'acesso' => $acesso, 'entidade' => $this->_auth->entidade->id);
			$this->db->where('id', $reg);
			$this->db->update('ead_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('ead_escolas_acessos');

		} else {
			$dados = array ('usuario' => $ID, 'acesso' => $acesso, 'entidade' => $this->_auth->entidade->id);
			$this->db->insert('ead_acessos', $dados);

			$this->db->where('usuario', $ID);
			$this->db->where('entidade', $this->_auth->entidade->id);
			$this->db->delete('ead_escolas_acessos');
		}
	}

	function validaUploadAluno($insert) {
		$this->db->where('usuario', $insert['usuario']);
		if(!$this->db->ObjectBuilder()->getOne('ead_alunos')) {
			if($this->db->insert('ead_alunos', $insert)) {
				$this->alunosNovos++;
			}
		}
	}



	function setEscolas($ID, $dep) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->delete('ead_escolas_acessos');
		if($dep) {
			foreach($dep as $d) {
				$dados[] = array(
					'usuario' => $ID,
					'entidade' => $this->_auth->entidade->id,
					'escola' => $d
				);
			}
			$this->db->insertMulti('ead_escolas_acessos', $dados);
		}
	}

	function consultaAcesso($ID) {
		$this->db->where('usuario', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->where('acesso', 1);
		return $acesso = $this->db->ObjectBuilder()->getValue('ead_acessos', 'id', 1);
	}

	function consultaAcessoEscolas($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('ead_escolas_acessos a', 'a.escola = d.id', 'INNER');
		return $this->db->ObjectBuilder()->get('ead_escolas d', NULL, 'd.*');
	}

	function consultaAcessoEscolasIDs($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('ead_escolas_acessos a', 'a.escola = d.id', 'INNER');
		return $this->db->ObjectBuilder()->getValue('ead_escolas d', 'd.id', null);
	}

	function listarNomesEscolas($ID) {
		$this->db->where('a.usuario', $ID);
		$this->db->where('a.entidade', $this->_auth->entidade->id);
		$this->db->join('ead_escolas_acessos a', 'a.escola = d.id', 'INNER');
		if ($lista = $this->db->ObjectBuilder()->getValue('ead_escolas d', 'd.nome', null)) {
			return implode(', ', $lista);
		}
		return '';
	}

	function getUsuarios($ID = false) { GLOBAL $S;
		$this->db->join('app_permissoes p', "p.usuario = u.ID AND p.aplicativo = '$S->ID' AND p.entidade = '".$this->_auth->entidade->id."'", 'INNER');
		$this->db->join('app_entidades_aplicativos e', "e.entidade = '".$this->_auth->entidade->id."' AND e.aplicativo = '$S->ID'", 'INNER');
		if($ID) { $this->db->where('u.ID', $ID); }
		if ( $u = $this->db->ObjectBuilder()->get('app_usuarios u', null, 'u.*') ) {
			foreach ($u as $u) {
				$u->{'_admin'} = $this::consultaAcesso($u->ID);
				$u->{'escolas'} = $this::consultaAcessoEscolas($u->ID);
				$u->{'escolas_ids'} = $this::consultaAcessoEscolasIDs($u->ID);
				$u->{'nomes_escolas'} = $this::listarNomesEscolas($u->ID);
				$usuarios[$u->ID] = $u;
				if($ID) { return $u; }
			}
		}
		return $this->usuarios = $usuarios;
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('ead_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('ead', array('capa' => 0));
		return true;
	}

	function getAlunoID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('ead_alunos');
	}

	function getAlunos($ID = false, $escola = false, $sala = false) {
		$this->db->join('ead_escolas e', 'e.id = a.escola', 'INNER');
		$this->db->join('ead_salas s', 's.id = a.sala', 'LEFT');
		$this->db->join('ead_series se', 'se.id = a.serie', 'LEFT');
		if($this->_professor) {
			$this->db->where('e.id', $this->_escolas, 'IN');
		}
		if($this->isEscolar) {
			if($this->acesso->escolas_ids) {
				$this->db->where('e.id', $this->acesso->escolas_ids, 'IN');
			} else {
				$this->db->where('e.id', 0);
			}
		}
		if($escola > 0) {
			$this->db->where('a.escola', $escola);
		}
		if($sala > 0) {
			$this->db->where('a.sala', $sala);
		}
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('a.id');
		$this->db->orderBy('a.nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->get('ead_alunos a', 1000, 'a.*, s.nome as sala_nome, s.id as sala_id, e.nome as escola_nome, e.id as escola_id, se.nome as serie_nome, se.id as serie_id')[0];
		}
		return $this->db->ObjectBuilder()->get('ead_alunos a', 1000, 'a.*, s.nome as sala_nome, s.id as sala_id, e.nome as escola_nome, e.id as escola_id, se.nome as serie_nome, se.id as serie_id');
	}

	function getEscolas($ID = false) {
		if($this->_professor) {
			$this->db->where('e.id', $this->_escolas, 'IN');
		}
		if($this->isEscolar) {
			if($this->acesso->escolas_ids) {
				$this->db->where('e.id', $this->acesso->escolas_ids, 'IN');
			} else {
				$this->db->where('e.id', 0);
			}
		}
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->join('ead_salas s', 's.escola = e.id', 'LEFT');
		$this->db->groupBy('e.id');
		$this->db->orderBy('e.nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->get('ead_escolas e', null, 'e.*, count(s.id) as salas')[0];
		}
		return $this->db->ObjectBuilder()->get('ead_escolas e', null, 'e.*, count(s.id) as salas');
	}
	function getEscolaTag($tag) {
		$this->db->where('e.entidade', $this->_auth->entidade->id);
		$this->db->groupBy('e.id');
		$this->db->where('tag', $tag);
		if($escola = $this->db->ObjectBuilder()->getOne('ead_escolas e')) {
			$arquivos->{'capa'} = $this::getCapaID($escola->capa);
			$arquivos->{'arquivos'} = $this::galeriaArquivos($escola);
			$escola->{'arquivos'} = (object) $arquivos;
			return $escola;
		}
	}
	function getSalas($ID = false, $escola = false) {
		if($this->_professor) {
			$this->db->where('s.id', $this->_salas, 'IN');
		}
		if($this->isEscolar) {
			if($this->acesso->escolas_ids) {
				$this->db->where('e.id', $this->acesso->escolas_ids, 'IN');
			} else {
				$this->db->where('e.id', 0);
			}
		}
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->join('ead_escolas e', 'e.id = s.escola', 'LEFT');
		$this->db->join('ead_niveis n', 'n.id = s.nivel', 'LEFT');
		$this->db->groupBy('s.id');
		$this->db->orderBy('s.nome', 'ASC');
		if($ID) {
			$this->db->where('s.id', $ID);
			return $this->db->ObjectBuilder()->get('ead_salas s', null, 's.*, e.nome as escola, e.tag as escola_tag, e.id as escola_id, n.nome as nivel, n.id as nivel_id')[0];
		}
		return $this->db->ObjectBuilder()->get('ead_salas s', null, 's.*, e.nome as escola, e.tag as escola_tag, e.id as escola_id, n.nome as nivel, n.id as nivel_id');
	}
	function getSalasEscola($escola) {
		$this->db->join('ead_escolas e', 'e.id = s.escola', 'LEFT');
		$this->db->join('ead_niveis n', 'n.id = s.nivel', 'LEFT');
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->where('e.id', $escola);
		$this->db->groupBy('s.id');
		$this->db->orderBy('s.nome', 'ASC');
		return $this->db->ObjectBuilder()->get('ead_salas s', null, 's.*, e.nome as escola, e.tag as escola_tag, e.id as escola_id, n.nome as nivel, n.id as nivel_id');
	}
	function getMaterias($ID = false) {
		if($this->_professor) {
			$this->db->where('id', $this->_materias, 'IN');
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->orderBy('nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->getOne('ead_materias');
		}
		return $this->db->ObjectBuilder()->get('ead_materias');
	}
	function getNiveis($ID = false) {
		if($this->_professor) {
			$this->db->where('id', $this->_niveis, 'IN');
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->orderBy('nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->getOne('ead_niveis');
		}
		return $this->db->ObjectBuilder()->get('ead_niveis');
	}
	function getSeries($ID = false) {
		if($this->_professor) {
			$this->db->where('id', $this->_series, 'IN');
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->orderBy('nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->getOne('ead_series');
		}
		return $this->db->ObjectBuilder()->get('ead_series');
	}

	function getProfessores($ID = false) {
		if($this->_professor) {
			$this->db->where('id', $this->_auth->usuario->ID);
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->orderBy('nome', 'ASC');
		if($ID) {
			$this->db->where('id', $ID);
			return $this->db->ObjectBuilder()->getOne('ead_professores');
		}
		return $this->db->ObjectBuilder()->get('ead_professores');
	}

	function getProfessoresEscola($escola) {
		$this->db->where('p.entidade', $this->_auth->entidade->id);
		$this->db->where("JSON_CONTAINS(p.escolas, '[\"$escola\"]')");
		$this->db->orderBy('p.apelido', 'ASC');
		$this->db->groupBy('p.id');
		return $this->db->ObjectBuilder()->get('ead_professores p', null, 'p.*');
	}

	function addLink($dados) {
		if ($this->db->insert('ead_links', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function addVideo($dados) {
		return $this->db->insert('ead_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('ead_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('ead_videos');
	}

	function getLinks($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('ead_links');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('ead_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('ead_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('ead_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('ead_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('ead', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('ead_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('ead', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function atualizaCapaEscola($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('ead_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('ead_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('ead_escolas', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('ead_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('ead_escolas', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('ead_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('ead_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		$this->db->OrderBy('legenda', 'ASC');
		$this->db->OrderBy('arquivo', 'ASC');
		return $this->db->ObjectBuilder()->get('ead_arquivos');
	}

	function galeriaAudios($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'audio');
		return $this->db->ObjectBuilder()->get('ead_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('ead_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('ead_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => API.HD.'ead/'.$this->entidade->id.'/',
				'arquivo' => 'capa.jpg',
			);
		}
	}

	function setEntidades($noticia, $entidades = false) {
		$this::delEntidades($noticia);
		if($entidades) {
			foreach($entidades as $e) {
				$insert[] = array(
					'noticia' => $noticia,
					'entidade' => $e,
					'usuario' => $this->_auth->usuario->ID
				);
			}
			return $this->db->insertMulti('ead_entidades', $insert);
		}
		return true;
	}

	function getEntidades($noticia) {
		$this->db->where('noticia', $noticia);
		return $this->db->getValue('ead_entidades', 'entidade', null);
	}

	function delEntidades($noticia, $entidade = false) {
		$this->db->where('noticia', $noticia);
		if($entidade) { $this->db->where('entidade', $entidade); }
		return $this->db->delete('ead_entidades');
	}
	
	function getAulas($limitador) {
		if($this->_professor) {
			$this->db->where("JSON_CONTAINS(n.professores, '[\"".$this->_auth->usuario->ID."\"]')");
		}
		if(!$limitador) { $limitador = 300; } else if ($limitador == 'all') { $limitador = null; }
		$this->db->where('n.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('n.data', 'DESC');
		$this->db->groupBy('n.id');
		$this->noticias = $this->db->ObjectBuilder()->get('ead n', $limitador, 'n.*');
		return $this->noticias;
	}

	function getAulaID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('ead');
	}

	function getAulaTag($TAG) {
		$this->db->where('n.tag', $TAG);
		if($n = $this->db->ObjectBuilder()->getOne('ead n')) {
			if($array_escolas = json_decode($n->escolas)) {
				$this->db->where('id', $array_escolas, 'IN');
				$arquivos{'escolas'} = $this->db->ObjectBuilder()->get('ead_escolas');
			}
			//$info->{'escolas'} = $this::getEscolasIDs(json_decode($n->escolas));
			//$_escolas = $this::getEscolasIDs(json_decode($n->escolas));
			$arquivos{'capa'} = $this::getCapaID($n->capa);
			$arquivos{'videos'} = $this::getVideos($n);
			$arquivos{'arquivos'} = $this::galeriaArquivos($n);
			$arquivos{'audios'} = $this::galeriaAudios($n);
			$arquivos{'links'} = $this::getLinks($n);
			$arquivos{'imagens'} = $this::galeriaImagem($n);
			$n->{'arquivos'} = (object) $arquivos;
		}
		return $n;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('ead'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('ead', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}
	
	function editarEscola($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('ead_escolas'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('ead_escolas', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('ead', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('ead', $dados);
	}

	function desativarAluno($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		return $this->db->update('ead_alunos', $dados);
	}

	function ativarAluno($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		return $this->db->update('ead_alunos', $dados);
	}

	function desativarProf($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('ead_professores', $dados);
	}

	function ativarProf($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('ead_professores', $dados);
	}

	function excluir($ID) {
		$n = $this::getAulaID($ID);

		if($n->entidade != $this->_auth->entidade->id) {
			return $this::delEntidades($ID, $this->_auth->entidade->id);
		}

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('ead');
	}

	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('ead_links');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('ead_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('ead_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('ead_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('ead'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('ead', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	function criarEscola($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('ead_escolas'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('ead_escolas', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('ead_secoes');
		return $this->secoes;
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('ead', $dados);
	}

	function getNoticiasCapa($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		$this->db->join('ead_secoes s', 's.id = n.secao', 'LEFT');
		if($secao) {
			if (is_array($secao)) {
				$this->db->where('s.nome', $secao, 'IN');
			} else {
				$this->db->where('s.nome', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('s.nome', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('s.nome', $secaoNao, '!=');
			}
		}
		$this->db->join('ead_entidades e', 'n.id = e.noticia', 'LEFT');
		$this->db->where('(n.entidade = '.$this->_auth->entidade->id.' OR e.entidade = '.$this->_auth->entidade->id.')');
		$this->db->where('n.destaque', 1);
		if ($orderBy) {
			$this->db->OrderBy('n.'.$orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('n.data', 'DESC');
		}
		$this->db->groupBy('n.id');
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('ead n', 1, 'n.*, s.nome as secao, s.id as secao_id'))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
				$this->_notCapas[] = $n->id;
				$n->{'capa'} = (object) $this::getCapaID($n->capa);
				$noticias[] = (object) $n;
			}
			return $noticias;
		} else {
			return false;
		}
	}

	function viewAulas($limitador, $escola = false, $professor = false, $sala = false, $pagina = 1) {
		if($escola) {
			$this->db->where("JSON_CONTAINS(a.escolas, '[\"$escolas\"]')");
		}
		if($professor) {
			$this->db->where("JSON_CONTAINS(a.professores, '[\"$professor\"]')");
		}
		if($sala) {
			$this->db->where("JSON_CONTAINS(a.salas, '[\"$sala\"]')");
		}
		$this->db->OrderBy('a.data', 'DESC');
		$this->db->groupBy('a.id');
		$this->db->pageLimit = $limitador;
		if ($aulas = $this->db->ObjectBuilder()->paginate('ead a', $pagina, 'a.*'))  {
			$this->totalCount = $this->db->totalCount;
			return $aulas;
		} else {
			return false;
		}
	}

}

return $EAD = new Ead($isView);

?>