var FormWizard = function () {

    var handleSummernote = function () {
        var myElement = $('#texto');
        myElement.show();
        myElement.summernote({
            height: 250,
            dialogsFade: true,
            placeholder: 'Digite ou insira o texto aqui',
            lang: 'pt-BR',
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                //['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link'/*, 'picture', 'video'*/]],
                ['view', ['fullscreen', 'codeview', 'help']]
              ],
            callbacks: {
                onChange: function(contents, $editable) {
                    myElement.val(myElement.summernote('isEmpty') ? "" : contents);
                    v.element(myElement); 
                }
            }
        });
        //API:
        //var sHTML = $('#summernote_1').code(); // get code
        //$('#summernote_1').destroy(); // destroy




        function format(state) {
            if (!state.id) return state.text; // optgroup
            return "<img class='flag' src='../../assets/global/img/flags/" + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
        }

        var form = $('#form-editar');
        var error = $('.alert-danger', form);
        var success = $('.alert-success', form);

        var v = form.validate({
            doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                //account
                data: {
                    required: true
                },
                hora: {
                    required: true
                },
                grupo: {
                    required: true
                },
                categoria: {
                    required: true
                },
                titulo: {
                    required: true
                },
                texto: {
                    //required: false
                }
            },

            ignore: ":hidden:not(#texto),.note-editable.panel-body",

            messages: { // custom messages for radio buttons and checkboxes
                
            },

            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                    error.insertAfter("#form_gender_error");
                } else if (element.attr("name") == "texto") { // for uniform checkboxes, insert the after the given container
                    error.insertAfter("#erro-editor");
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },

            invalidHandler: function (event, validator) { //display error alert on form submit   
                success.hide();
                error.show();
                App.scrollTo(error, -200);
            },

            highlight: function (element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
            },

            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                    .closest('.form-group').removeClass('has-error'); // set error class to the control group
            },

            success: function (label) {
                if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                    label
                        .closest('.form-group').removeClass('has-error');
                    label.remove(); // remove error label here
                } else { // display success icon for other inputs
                    label
                        .addClass('valid') // mark the current input as valid and display OK icon
                    .closest('.form-group').removeClass('has-error'); // set success class to the control group
                }
            },

            submitHandler: function (form) {
                data = $('#form-editar').serialize();
                var action = $('#form-editar').attr('action');
                //var acao = 'criar';
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: action,
                    data: data,
                    success: function( data ) {
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });
            }

        });
    }


    return {
        //main function to initiate the module
        init: function () {
            //validations();
            handleSummernote();
        }
    };

}();
jQuery(document).ready(function() {
    FormWizard.init();
});


//## UPLOAD
if($('.dropzone').length) {
    $('.dropzone').each( function() {

        var codigo = $(this).attr('codigo');
        var ID = $(this).attr('ID');
        var action = $(this).attr('action');
        var tipo = $(this).attr('tipo');


        //var controle = $('[controle]');
        var submit = $("[dContinuar]");

        // MaxFiles
        if ($(this).attr('maxFiles').length) {
            _maxFiles = $(this).attr('maxFiles');
        } else {
            _maxFiles = 10;
        }

        // extFilter
        if ($(this).attr('extFilter').length) {
            _extFilter = $(this).attr('extFilter');
        } else {
            _extFilter = '';
        }


        var uploader = new Dropzone(this, { // Make the whole body a dropzone
          url: action, // Set the url
          parallelUploads: 5,
          maxFiles: _maxFiles,
          maxFilesize: 200, //mb
          acceptedFiles: _extFilter, //
          //previewTemplate: previewTemplate,
          autoQueue: true, // Make sure the files aren't queued until manually added
          //previewsContainer: "#previews", // Define the container to display the previews
          //clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.,
          removedfile: function(file) {
            
            if (file.status == 'success') {
                if(file.xhr) {
                    r = JSON.parse(file.xhr.response);
                }
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: "acao=deletar&arquivo="+r.ID,
                    dataType: 'html',
                    success: function( data ) {
                        retornoAjax($.parseJSON(data));
                    }
                });
                //var v = parseInt(controle.val())-parseInt(1);
                //controle.attr('value', v);
            }
            var _ref;
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
          }
        });
        // Start UPLOADS:
        uploader.on('addedfile', function(file, xhr, formData){
            BlockUI('.dropzone');
            submit.prop('disabled', true);
            submit.children('span').html('Aguarde carregar os arquivos.');
        });
        // Envia Informações de Sessão e Usuário
        uploader.on('sending', function(file, xhr, formData){
            formData.append('ID', ID);
            formData.append('codigo', codigo);
            formData.append('acao', 'novo');
            formData.append('tipo', tipo);
            
        });
        // Completar UPLOADS:
        uploader.on('queuecomplete', function(file, xhr, formData){ location.reload();
            unBlockUI('.dropzone');
            submit.prop('disabled', false);
            submit.children('span').html( 'Continuar' );
        });
        // Success
        uploader.on("success", function(file, response) {
            //retornoAjax(response);
        });
    })
}



$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    if ( $(e.target).attr('href') == '#tab-informacoes' ) {
        $('.progress-bar').css('width', 50+'%');
        $('[li-informacoes]').addClass('active');
        $('[li-arquivos]').removeClass('done').removeClass('active');

    } else if ( $(e.target).attr('href') == '#tab-arquivos' ) {
        $('.progress-bar').css('width', 100+'%');
        $('[li-informacoes]').addClass('done');
        $('[li-arquivos]').addClass('active');
    }
})


$('[excluirArquivo]').on('click', function() {
    action = $('.dropzone').attr('action');
    ID = $(this).attr('excluirArquivo');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=deletar&arquivo="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[divArquivo='+ID+']').fadeTo( "slow", 0.20 );
                $('[btnArquivo='+ID+']').html('<h3>Arquivo Excluido</h3>').css('color', '#FFF');
                //imagensAtivas()
            }
        }
    });
})

$('[name=grupo]').on('change', function() {    
    $('#selectCategoria').html(grupo[this.value]);
    $('#selectCategoria').select2({
        selectOnClose: true,
        placeholder: 'Selecione',
        selectOnBlur: true,
        tags: false,
    });
})

var TableDatatablesEditar = function () {

    var handleTableArquivos = function () {

        function restoreRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);

            for (var i = 0, iLen = jqTds.length; i < iLen; i++) {
                oTable.fnUpdate(aData[i], nRow, i, false);
            }

            oTable.fnDraw();
        }

        function editRow(oTable, nRow) {
            var aData = oTable.fnGetData(nRow);
            var jqTds = $('>td', nRow);
            ID = $(nRow).closest('tr').attr('arquivo-ID');
            jqTds[0].innerHTML = '<input type="text" required name="data" class="form-control data" value="' + aData[0] + '">';
            jqTds[1].innerHTML = '<input type="text" required name="legenda" class="form-control" value="' + aData[1] + '">';
            jqTds[2].innerHTML = aData[2];
            jqTds[3].innerHTML = '<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Salvar</button>';
            jqTds[4].innerHTML = '<button type="button" class="cancel btn btn-xs green btn-outline no-transform no-shadow no-radius font-s13">Cancelar</button>';
            mascaras()
        }
        function select2Tipos() {
            $.fn.select2.defaults.set("theme", "bootstrap");
            $.fn.select2.defaults.set('language', 'pt-BR');
            $(".select2").select2({
                selectOnClose: true,
                placeholder: 'Selecione um Tipo',
                selectOnBlur: true,
                tags: true,
            });
        } select2();

        function saveRow(oTable, nRow, ID) {
            var jqInputs = $('input,select', nRow);
            $ID = enviaAjax(jqInputs, ID, oTable, nRow, jqInputs);
        }

        function cancelEditRow(oTable, nRow) {
            var jqInputs = $('input,select', nRow);
            oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
            oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
            oTable.fnUpdate(jqInputs[2].value, nRow, 2, false);
            oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 3, false);
            oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 4, false);
            oTable.fnDraw();
        }

        function enviaAjax(dados, ID = false, oTable, nRow, jqInputs, jQTds) {
            //$(".data").inputmask(); $(".hora").unmask();
            data = dados.serialize();
            var action = $('#controle-ajax').attr('action');

            $.ajax({
                type: "POST",
                dataType: "json",
                url: action,
                data: data+'&ID='+ID,
                success: function( data ) {
                    retornoAjax(data);
                    if(data.success == true) {
                        $(nRow).attr('arquivo-ID', ID);
                        oTable.fnUpdate(jqInputs[0].value, nRow, 0, false);
                        oTable.fnUpdate(jqInputs[1].value, nRow, 1, false);
                        oTable.fnUpdate(jqInputs[2], nRow, 2, false);
                        oTable.fnUpdate('<button type="button" class="edit btn btn-xs btn-success no-transform no-shadow no-radius font-s13">Editar</button>', nRow, 3, false);
                        oTable.fnUpdate('<button type="button" class="delete btn btn-xs btn-danger no-transform no-shadow no-radius font-s13">Excluir</button>', nRow, 4, false);
                        oTable.fnDraw();
                    }
                },
                error: function( data ) {
                    $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                }
            });

        }


        var tableArquivos = $('#tabela_arquivos');


        var oTable = tableArquivos.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'copy',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'pdf',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'excel',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'csv',
                    title: 'Arquivos',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2,3] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 item copiado!'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "desc"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#editable_wrapper_arquivos");

        var nEditing = null;
        var nNew = false;

        tableArquivos.on('click', '.delete', function (e) {
            e.preventDefault();

            var action = $('.dropzone').attr('action');
            var ID = $(this).closest('tr').attr('arquivo-ID');

            swal({
                title: "Tem certeza que deseja excluir este arquivo?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()


                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'arquivo='+ID+'&acao=deletar',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[arquivo-ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            console.log(data)
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });

        });

        tableArquivos.on('click', '.cancel', function (e) {
            e.preventDefault();
            if (nNew) {
                oTable.fnDeleteRow(nEditing);
                nEditing = null;
                nNew = false;
            } else {
                restoreRow(oTable, nEditing);
                nEditing = null;
            }
        });

        tableArquivos.on('click', '.edit', function (e) {
            $('#controle-ajax').attr('acao', 'editar');
            e.preventDefault();
            nNew = false;

            var ID = $(this).closest('tr').attr('arquivo-ID');

            /* Get the row as a parent of the link that was clicked on */
            var nRow = $(this).parents('tr')[0];

            if (nEditing !== null && nEditing != nRow) {
                /* Currently editing - but not this row - restore the old before continuing to edit mode */
                restoreRow(oTable, nEditing);
                editRow(oTable, nRow);
                nEditing = nRow;
            } else if (nEditing == nRow && this.innerHTML == "Salvar") {
                /* Editing this row and want to save it */
                saveRow(oTable, nEditing, ID);
                //nEditing = null;
                //alert("Updated! Do not forget to do some ajax to sync with backend :)");
            } else {
                /* No edit in progress - let's start one */
                editRow(oTable, nRow);
                nEditing = nRow;
            }
        });
    }



    return {

        //main function to initiate the module
        init: function () {
            handleTableArquivos();
        }

    };

}();
jQuery(document).ready(function() {
    TableDatatablesEditar.init();
});