var TableDatatablesEditable = function () {

    var handleTable = function () {

        var table = $('#sample_editable_1');

        var oTable = table.dataTable({
            buttons: [
                { extend: 'print',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-print"></i> Imprimir',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'copy',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13', 
                    text: '<i class="fa fa-clipboard"></i> Copiar',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'pdf',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-pdf"></i> PDF',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'excel',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-excel"></i> Excel',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'csv',
                    title: 'Notícias',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: '<i class="fa fa-cvs"></i> CVS',
                    exportOptions: { columns: [0,1,2] },
                },
                { extend: 'colvis',
                    className: 'btn green no-shadow no-radius btn-outline font-s13',
                    text: 'Colunas',
                }
            ],

            "dom": "<'row' <'col-md-12'B>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>",

            "lengthMenu": [
                [25, 50, 100, -1],
                [25, 50, 100, "Todos"] // change per page values here
            ],

            // Or you can use remote translation file
            //"language": {
            //   url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            //},

            // set the initial value
            "pageLength": 50,

            "language": {
                "sProcessing":   "A processar...",
                "sLengthMenu":   "Mostrar _MENU_ registros",
                "sZeroRecords":  "Não foram encontrados resultados",
                "sInfo":         "Mostrando de _START_ até _END_ de _TOTAL_ registros",
                "sInfoEmpty":    "Mostrando de 0 até 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros no total)",
                "sInfoPostFix":  "",
                "sSearch":       "Procurar:",
                "sUrl":          "",
                "oPaginate": {
                    "sFirst":    "Primeiro",
                    "sPrevious": "Anterior",
                    "sNext":     "Seguinte",
                    "sLast":     "Último"
                },
                "language": {
                    buttons: {
                        copySuccess: {
                            _: '%d Copiado com sucesso!',
                            1: '1 ligne copiée'
                        }
                    }
                }
            },

            "columnDefs": [{ // set default column settings
                'orderable': true,
                'type': 'date-uk',
                'targets': [0]
            }, {
                "searchable": true,
                "targets": [0]
            }],
            "order": [
                [0, "desc"]
            ], // set first column as a default sort by ascgetSaldoCliente
        });

        var tableWrapper = $("#sample_editable_1_wrapper");

        var nEditing = null;
        var nNew = false;

        table.on('click', '.delete', function (e) {

            var action = $('#controle-ajax').attr('action');
            var acao = $('#controle-ajax').attr('acao');
            var ID = $(this).closest('tr').attr('ID');

            swal({
                title: "Tem certeza que deseja excluir este diário?",
                text: "Esta ação não pode ser desfeita.",
                type: "info",
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonText: 'Excluir',
                confirmButtonClass: 'btn-danger',
                closeOnConfirm: false,
                showLoaderOnConfirm: true,
            }, function (isConfirm) {
                if (isConfirm){
                    
                    //swal('Excluindo!', 'O agendamento será excluido e a página será atualizada.', "success");
                    swal.close()

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: 'ID='+ID+'&acao=deletar',
                        success: function( data ) {
                            retornoAjax(data);
                            if (data.success == true) {
                                var nRow = $('[ID='+ID+']');
                                oTable.fnDeleteRow(nRow);
                            }
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });
                }
            });

        });

    }

    var DatetimePicker = function () {
        if (!$().datetimepicker) { return false; }

        $(".form_datetime").datetimepicker({
            autoclose: true,
            isRTL: App.isRTL(),
            format: "dd MM yyyy - hh:ii",
            fontAwesome: true,
            pickerPosition: (App.isRTL() ? "bottom-right" : "bottom-left")
        });
    }

    return {

        //main function to initiate the module
        init: function () {
            handleTable();
            DatetimePicker();
        }

    };

}();
jQuery(document).ready(function() {
    TableDatatablesEditable.init();
});

function mascaras() {
    $(".data").inputmask("d/m/y", {
        placeHolder: '_ ',
        keepStatic: true
    });
    $(".hora").inputmask("99:99", {
        placeHolder: '_ ',
        keepStatic: true
    });
}

function select2() {
    $.fn.select2.defaults.set("theme", "bootstrap");
    $.fn.select2.defaults.set('language', 'pt-BR');
    $(".select2").select2({
        selectOnClose: true,
        placeholder: 'Selecione ou digite uma seção',
        selectOnBlur: true,
        tags: false,
    });
} select2();