<?
class Concursos extends APP {
	PRIVATE $APP;

	PUBLIC $concursos;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getConcursos();

		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('concursos_arquivos');
		return true;
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('concursos_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('concursos_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('concursos_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('concursos_arquivos', $legenda);
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('concursos_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		$this->db->OrderBy('data', 'DESC');
		return $this->db->ObjectBuilder()->get('concursos_arquivos');
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('concursos_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->OrderBy('ID', 'DESC');
		return $this->db->ObjectBuilder()->get('concursos_arquivos');
	}
	
	function getConcursos() {
		$this->db->join('concursos_secoes g', 'g.id = t.secao', 'LEFT');
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$this->concursos = $this->db->ObjectBuilder()->get('concursos t', null, 't.*, g.nome as secao');
		return $this->concursos;
	}

	function getConcursoTag($TAG) {
		$this->db->join('concursos_secoes g', 'g.id = secao', 'LEFT');
		$this->db->where('t.tag', $TAG);
		$this->db->where('t.entidade', $this->_auth->entidade->id);
		$concurso = $this->db->ObjectBuilder()->get('concursos t', null, 't.*, g.nome as secao')[0];
		return $concurso;
	}

	function getConcursoID($ID) {
		$this->db->where('id', $ID);
		$concurso = $this->db->ObjectBuilder()->getOne('concursos');
		return $concurso;
	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('concursos'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('concursos', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}


	function excluir($ID) {
		$n = $this::getConcursoID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('concursos');
	}


	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('concursos'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('concursos', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}

	function getSecoes() {
		$this->db->OrderBy('nome', 'ASC');
		$this->db->groupBy('nome');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->get('concursos_secoes');
		return $this->secoes;
	}

	function viewSecoesConcursos($filtros = false, $ordem = false) {
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(c.data)', $filtros->ano);
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('c.entidade', $filtros->ent);
		} else {
			$this->db->where('c.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("c.titulo LIKE '%$filtros->b%'");
		}

		$this->db->join('concursos_secoes s', 's.id = c.secao', 'LEFT');
		$this->db->OrderBy('s.nome', 'ASC');;
		if($ordem) {
			$this->db->orderBy('c.'.$ordem->campo, $ordem->ordem);
		} else {
			$this->db->orderBy('c.data', 'DESC');
		}

		if ( $c = $this->db->ObjectBuilder()->get('concursos c', null, 'c.*, s.nome as secao_nome') ) {
			$this->return = false;
			foreach($c as $c) {
				$c->{'arquivos'} = $this::getArquivosCodigo($c->codigo);
				$this->return->{$c->secao_nome}->{$c->id} = $c;
				$this->return->{$c->secao_nome}->{$c->id} = $c;
			}
			return $this->return;
		} else {
			return null;
		}		
	}

	function getModalidadesCat($cat, $filtros = false) {
		$this->db->where('c.nome', $cat);
		$this->db->join('licitacoes_categorias c', 'l.categoria = c.id', 'INNER');
		# ANO
		if($filtros->ano) {
			$this->db->where('YEAR(l.data)', $filtros->ano);
		}
		# ENTIDADE
		if($filtros->ent) {
			$this->db->where('l.entidade', $filtros->ent);
		} else {
			$this->db->where('l.entidade', $this->_auth->entidade->id);
		}
		# BUSCA
		if($filtros->b) {
			$this->db->where("l.titulo LIKE '%$filtros->b%'");
		}
		$this->db->join('licitacoes_modalidades m', 'l.modalidade = m.id', 'INNER');
		$this->db->groupBy('m.id');
		$m =  $this->db->ObjectBuilder()->get('licitacoes l', null, 'm.*');
		return $m;
	}

}

return $CONCURSOS = new Concursos($isView);

?>