<?
class Classificados extends APP {
	PRIVATE $APP;

	PUBLIC $classificados;
	PUBLIC $secoes;

    function __construct($isView) {
        GLOBAL $_POST;
        if ($isView) { 
            $this->isView = true; 
        }
        parent::__construct($isView);
        $carregar = $_POST['carregar'] ?? null;
        $this::getClassificados($carregar);
        $this::getSecoes();
        if ((int) ENTIDADE !== 0) {
            $this->_auth->entidade = $this::getEntidade(ENTIDADE);
        }
    }


	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
		}
		if( $a->tipo == 'imagem' ) {
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('classificados_arquivos');

		$this->db->where('capa', $ID);
		$this->db->update('classificados', array('capa' => 0));
		return true;
	}

	function addLink($dados) {
		if ($this->db->insert('classificados_links', $dados)) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}
	function addVideo($dados) {
		return $this->db->insert('classificados_videos', $dados);
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('classificados_arquivos', $legenda);
	}

	function getVideos($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('classificados_videos');
	}

	function getLinks($n) {
		$this->db->where('codigo', $n->codigo);
		return $this->db->ObjectBuilder()->get('classificados_links');
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('classificados_arquivos');
	}

	function getArquivosCodigo($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->ObjectBuilder()->get('classificados_arquivos');
	}

	function atualizaCapa($ID, $dados) { 
		$this->db->where('codigo', $dados['codigo']);
		$this->db->where('tipo', 'capa');
		if( $capa = $this->db->ObjectBuilder()->getOne('classificados_arquivos') ) {
			$this->db->where('id', $capa->id);

			if ($this->db->update('classificados_arquivos', $dados) ) {	

				$data = array('capa' => $capa->id);
				$this->db->where('id', $ID);
				if($this->db->update('classificados', $data)) {
					return $capa;
				} else {
					return false;
				}				
			} else {
				return false;
			}
		} else {
			if( $this->db->insert('classificados_arquivos', $dados) ) {
				$capa = $this->db->getInsertID();
		
				$data = array('capa' => $capa);

				$this->db->where('id', $ID);
				if($this->db->update('classificados', $data)) {
					return $capa;
				} else {
					return false;
				}
			}
		}
	}

	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('classificados_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}

	function galeriaImagem($n, $capa = true) {
		if($capa) {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem' OR tipo = 'capa')");
		} else {
			$this->db->where("(codigo = '$n->codigo') AND (tipo = 'imagem')");
		}
		return $this->db->ObjectBuilder()->get('classificados_arquivos');
	}

	function galeriaArquivos($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'arquivo');
		return $this->db->ObjectBuilder()->get('classificados_arquivos');
	}

	function getCapa($n) {
		$this->db->where('codigo', $n->codigo);
		$this->db->where('tipo', 'capa');
		return $this->db->ObjectBuilder()->getOne('classificados_arquivos');
	}

	function getCapaID($ID) {
		$this->db->where('id', $ID);
		if ( $capa = $this->db->ObjectBuilder()->getOne('classificados_arquivos') ){
			return $capa;
		} else {
			return $capa = (object) array(
				'path' => API.HD.'classificados/',
				'arquivo' => 'capa.jpg',
				);
		}
	}
	
	function getClassificados($limitador) {
		if(!$limitador) { $limitador = 300; } else if  ($limitador == 'all') { $limitador = null; }
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('data', 'DESC');
		$this->classificados = $this->db->ObjectBuilder()->get('classificados', $limitador);
        if ($this->isView) {
            if ($not = $this->db->ObjectBuilder()->get('classificados'))  {
                $num = 0;
                foreach ($not as $n) {
                    $arquivos['capa'] = $this::getCapaID($n->capa);
                    $n->{'arquivos'} = (object) $arquivos;
                    /*
                    $arquivos['videos'] = $this::getVideos($n->codigo);
                    $arquivos['arquivos'] = $this::galeriaArquivos($n->codigo);
                    $arquivos['links'] = $this::getLinks($n->codigo);
                    $arquivos['imagens'] = $this::galeriaImagem($n->codigo);
                    */
                    if ($n->destaque == 1 AND $num < LIMITE_CAPA) {
                        $classificados['capas'][] = (object) $n;
                        $num++;
                    } else {
                        $arquivos['capa'] = $this::getArquivo($n->capa);
                        $classificados['classificados'][] = $n;
                    }
                }
                $this->classificados = (object) $classificados;
                return $classificados;
            } else {
                return false;
            }
        }

		return $this->classificados;
	}

    function getClassificadoTag($TAG) {
        $this->db->where('tag', $TAG);
        $this->db->where('entidade', $this->_auth->entidade->id);
        $classificado = $this->db->ObjectBuilder()->getOne('classificados');

        if ($n = $classificado) {
            $arquivos = []; // inicializa o array
            $arquivos['capa'] = $this::getCapaID($n->capa);
            $arquivos['videos'] = $this::getVideos($n);
            $arquivos['arquivos'] = $this::galeriaArquivos($n);
            $arquivos['links'] = $this::getLinks($n);
            $arquivos['imagens'] = $this::galeriaImagem($n);
            $classificado->{'arquivos'} = (object) $arquivos;
        }
        return $classificado;
    }


    function getClassificadoID($ID) {
        $this->db->where('id', $ID);
        $this->db->where('entidade', $this->_auth->entidade->id);
        $classificado = $this->db->ObjectBuilder()->getOne('classificados');

        if ($n = $classificado) {
            $arquivos = []; // inicializa o array
            $arquivos['capa'] = $this::getCapaID($n->capa);
            $arquivos['videos'] = $this::getVideos($n);
            $arquivos['arquivos'] = $this::galeriaArquivos($n);
            $arquivos['links'] = $this::getLinks($n);
            $arquivos['imagens'] = $this::galeriaImagem($n);
            $classificado->{'arquivos'} = (object) $arquivos;
        }
        return $classificado;
    }


	function destacar($ID, $tipo) {
		$n = $this::getClassificadoID($ID);

		if($n->destaque == $tipo) {
			$data['destaque'] = 0;
			$this->db->where('id', $ID);
			if( $this->db->update('classificados', $data) ) {
				$return['status'] = true;
				$return['acao'] = 0;
			} else {
				return false;
			}
		
		} else {
			$data['destaque'] = $tipo;
			$this->db->where('id', $ID);
			if( $this->db->update('classificados', $data) ) {
				$return['status'] = true;
				$return['acao'] = 1;
			} else {
				return false;
			}
		}
		return (object) $return;

	}

	function editar($ID, $dados) {
		$this->db->where('(tag = "'.$dados['tag'].'" AND id != "'.$ID.'")');
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")  AND id != "'.$ID.'"');
		$TAGS = count($this->db->get('classificados'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		if( $this->db->update('classificados', $dados) ) {
			return $dados['tag'];
		} else {
			return false;
		}
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('classificados', $dados);
	}

	function ativar($ID) {
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('classificados', $dados);
	}

	function excluir($ID) {
		$n = $this::getClassificadoID($ID);

		if ($A = $this::getArquivosCodigo($n->codigo)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
			@rmdir($path.'arquivos/');
			$from = array('imagens/', 'arquivos/'); $to = array('', '');
			@rmdir(str_replace($from, $to, $path));
		}

		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('classificados');
	}

	function excluirLink($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('classificados_links');
	}

	function excluirVideo($ID) {
		$this->db->where('id', $ID);
		return $this->db->delete('classificados_videos');
	}

	function editarLink($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('classificados_links', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function editarVideo($ID, $dados) {
		$this->db->where('id', $ID);
		if( $this->db->update('classificados_videos', $dados) ) {
			return true;
		} else {
			return false;
		}
	}

	function criar($dados) {
		$this->db->where('tag', $dados['tag']);
		$this->db->orWhere('tag LIKE ("'.$dados['tag'].'_%")');
		$TAGS = count($this->db->get('classificados'));
		if($TAGS) {	$dados['tag'] = $dados['tag'].'_'.$TAGS; }
		if ($this->db->insert('classificados', $dados)){
			return $dados['tag'];
		} else {
			var_dump($this->db->getLastError());
			return false;
		}
	}
	
	function getSecoes() {
		$this->db->OrderBy('secao', 'ASC');
		$this->db->groupBy('secao');
		$this->db->where('entidade', $this->_auth->entidade->id);
		$this->secoes = $this->db->ObjectBuilder()->getValue('classificados', 'secao', null);
		return $this->secoes;
	}

	function contar($n) {
		$dados['contador'] = ++$n->contador;
		$this->db->where('id', $n->id);
		return $this->db->update('classificados', $dados);
	}

    function getClassificadosNews($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1)
    {
        // Filtra seção específica, se houver
        if ($secao) {
            if (is_array($secao)) {
                $this->db->where('secao', $secao, 'IN');
            } else {
                $this->db->where('secao', $secao);
            }
        }

        // Exclui seções, se necessário
        if ($secaoNao) {
            if (is_array($secaoNao)) {
                $this->db->where('secao', $secaoNao, 'NOT IN');
            } else {
                $this->db->where('secao', $secaoNao, '!=');
            }
        }

        // Restringe por entidade logada
        $this->db->where('entidade', $this->_auth->entidade->id);

        // Ordenação
        if ($orderBy) {
            $this->db->orderBy($orderBy->campo, $orderBy->ordem);
        } else {
            $this->db->orderBy('data', 'DESC');
        }

        // Exclui IDs marcados para remoção (se houver)
        if (isset($this->_remover) && !empty($this->_remover)) {
            $this->db->where('id', $this->_remover, 'NOT IN');
        }

        // Paginação e execução
        $this->db->pageLimit = $limitador;

        if ($not = $this->db->objectBuilder()->paginate('classificados', $pagina)) {
            $this->totalCount = $this->db->totalCount;

            foreach ($not as $n) {
                $arquivos = [];

                $arquivos['capa'] = $this::getCapaID($n->capa);
                $arquivos['videos'] = $this::getVideos($n);
                $arquivos['arquivos'] = $this::galeriaArquivos($n);
                $arquivos['links'] = $this::getLinks($n);
                $arquivos['imagens'] = $this::galeriaImagem($n);

                $n->{'arquivos'} = (object) $arquivos;
            }

            return $not;
        } else {
            return false;
        }
    }


	function getClassificadosDestaque($limitador, $secao = false, $secaoNao = false, $orderBy = false, $pagina = 1) {
		if ($secao) {
			if (is_array($secao)) {
				$this->db->where('secao', $secao, 'IN');
			} else {
				$this->db->where('secao', $secao);
			}
		}
		if ($secaoNao) {
			if (is_array($secaoNao)) {
				$this->db->where('secao', $secaoNao, 'NOT IN');
			} else {
				$this->db->where('secao', $secaoNao, '!=');
			}
		}
		$this->db->where('entidade', $this->_auth->entidade->id);
		if ($orderBy) {
			$this->db->OrderBy($orderBy->campo, $orderBy->ordem);
		} else {
			$this->db->OrderBy('data', 'DESC');
		}
		$this->db->where('destaque', 1);
		$this->db->pageLimit = $limitador;
		if ($not = $this->db->ObjectBuilder()->paginate('classificados', $pagina))  {
			$this->totalCount = $this->db->totalCount;
			foreach($not as $n) {
            $arquivos = []; // inicializa o array
            $arquivos['capa'] = $this::getCapaID($n->capa);
            $arquivos['videos'] = $this::getVideos($n);
            $arquivos['arquivos'] = $this::galeriaArquivos($n);
            $arquivos['links'] = $this::getLinks($n);
            $arquivos['imagens'] = $this::galeriaImagem($n);

            $n->{'arquivos'} = (object) $arquivos;

			}
			return $not;
		} else {
			return false;
		}
	}

}

return $CLASSIFICADOS = new Classificados($isView);

?>