var Editar = function() {
    var vEditar = function(){
        jQuery('#form-editar').each(function() {
            $($(this)).validate({
                errorClass: 'help-block text-right animated fadeInDown',
                errorElement: 'div',
                errorPlacement: function(error, e) {
                    jQuery(e).parents('.form-group > div').append(error);
                },
                highlight: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                    jQuery(e).closest('.help-block').remove();
                },
                success: function(e) {
                    jQuery(e).closest('.form-group').removeClass('has-error');                
                    jQuery(e).closest('.help-block').remove();
                },
                rules: {
                    data: {
                        required: true
                    },
                    hora: {
                        required: true
                    },
                    sessao: {
                        required: true
                    },
                    titulo: {
                        required: true
                    }
                },
                messages: {
                    data: {
                        required: 'Insira uma data válida'
                    },
                    hora: {
                        required: 'Insira uma hora válida'
                    },
                    sessao: {
                        required: 'Selecione ou insira uma seção'
                    },
                    titulo: {
                        required: 'Insira um nome para a galeria'
                    }
                },
                submitHandler: function( form ){
                    
                    var dados = $( form ).serialize();
                    var action = $( form ).attr('action');

                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: action,
                        data: dados,
                        success: function( data ) {
                            retornoAjax(data);
                        },
                        error: function( data ) {
                            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                        }
                    });

                    return false;
                }
            });
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vEditar();
        }
    };
}();
jQuery(function(){ Editar.init(); });

// init cubeportfolio
function imagensAtivas() {
if ($('#js-grid-juicy-projects').length > 0) {
    if($('#js-grid-juicy-projects').attr('iniciado') == 1) {
        $('#js-grid-juicy-projects').cubeportfolio('destroy');
        $('#js-grid-juicy-projects').attr('iniciado', 0);
    }
    if ($('#js-grid-juicy-projects').attr('qtd') > 0) {    
        $('#js-grid-juicy-projects').attr('iniciado', 1);
        var CUBE = $('#js-grid-juicy-projects').cubeportfolio({
            //filters: '#js-filters-juicy-projects',
            //loadMore: '#js-loadMore-juicy-projects',
            loadMoreAction: 'click',
            layoutMode: 'grid',
            defaultFilter: '*',
            animationType: 'quicksand',
            gapHorizontal: 35,
            gapVertical: 30,
            gridAdjustment: 'responsive',
            mediaQueries: [{
                width: 1500,
                cols: 6
            }, {
                width: 1100,
                cols: 5
            }, {
                width: 800,
                cols: 3
            }, {
                width: 480,
                cols: 2
            }, {
                width: 320,
                cols: 1
            }],
            //caption: 'overlayBottomReveal',
            displayType: 'sequentially',
            displayTypeSpeed: 80,

            // lightbox
            lightboxDelegate: '.cbp-lightbox',
            lightboxGallery: true,
            lightboxTitleSrc: 'data-title',
            lightboxCounter: '<div class="cbp-popup-lightbox-counter">{{current}} de {{total}}</div>',
        });
    }
}
}
if(window.location.hash == '#tab-arquivos') {
    imagensAtivas();
}

$('[ativarID]').on('click', function() {
    action = $('[ativarDesativar]').attr('action');
    ID = $(this).attr('ativarID');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=ativar&ID="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[desativarID='+ID+']').show();
                $('[ativarID='+ID+']').hide()
            }
        }
    });
})
$('[desativarID]').on('click', function() {
    action = $('[ativarDesativar]').attr('action');
    ID = $(this).attr('desativarID');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=desativar&ID="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[ativarID='+ID+']').show();
                $('[desativarID='+ID+']').hide()
            }
        }
    });
})

$('[excluirImagem]').on('click', function() {
    action = $('.dropzone').attr('action');
    ID = $(this).attr('excluirImagem');
    $.ajax({
        type: 'POST',
        url: action,
        data: "acao=deletar&arquivo="+ID,
        dataType: "json",
        success: function( data ) {
            retornoAjax(data);
            if(data.success == true) {
                $('[divImagem='+ID+']').fadeTo( "slow", 0.20 );
                $('[btnImagem='+ID+']').html('<h3>Imagem Excluida</h3>').css('color', '#FFF');
                //imagensAtivas()
            }
        }
    });
})

var Legendas = function() {
    var vConfirmar = function(){
        jQuery('.js-legenda').validate({
            errorClass: 'help-block text-right animated fadeInDown',
            errorElement: 'div',
            errorPlacement: function(error, e) {
                jQuery(e).parents('.form-group > div').append(error);
            },
            highlight: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error').addClass('has-error');
                jQuery(e).closest('.help-block').remove();
            },
            success: function(e) {
                jQuery(e).closest('.form-group').removeClass('has-error');                
                jQuery(e).closest('.help-block').remove();
            },
            rules: {
                'alvo-legenda': {
                    required: true,
                },
                legenda: {
                    //required: true,
                },
            },
            messages: {
                
            },
            ignore: ":hidden:not(#texto),.note-editable.panel-body",
            submitHandler: function(form){

                dados = new FormData($(form).get(0));
                reloadOnError = $(form).attr('reloadOnError');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: $(form).attr('action'),
                    data: dados,
                    cache: false,
                    contentType: false,
                    processData: false,
                    timeout: 60000,
                    success: function( data ) {
                        if(data.success == true) {
                            $('[titulo='+data.ID+']').html( (data.titulo.length > 0) ? data.titulo : '- Sem Título -' );
                            $('[subtitulo='+data.ID+']').html( (data.subtitulo.length > 0) ? data.subtitulo : '- Sem Subtítulo -' );
                            $('[texto='+data.ID+']').html( (data.texto.length > 0) ? data.texto : '- Sem Texto -' );
                            $('[link='+data.ID+']').html( (data.link.length > 0) ? data.link : '- Sem Link -' );
                            $('[imagem='+data.ID+']').attr('src_imagem', data.imagem).attr('status', data.imagem_status);
                        }
                        retornoAjax(data);
                    },
                    error: function( data ) {
                        $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
                    }
                });

                return false;
            }
        });
    };

    return {
        init: function () {
            // Init Login Form Validation
            vConfirmar();
        }
    };
}();
jQuery(function(){ Legendas.init(); });


$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    if ( $(e.target).attr('href') == '#tab-informacoes' ) {
        $('.progress-bar').css('width', 50+'%');
        $('[li-informacoes]').addClass('active');
        $('[li-arquivos]').removeClass('done').removeClass('active');

    } else if ( $(e.target).attr('href') == '#tab-arquivos' ) {
        $('.progress-bar').css('width', 100+'%');
        $('[li-informacoes]').addClass('done');
        $('[li-arquivos]').addClass('active');
        imagensAtivas()
    }
})

//## UPLOAD
if($('.dropzone').length) {
    $('.dropzone').each( function() {

        var codigo = $(this).attr('codigo');
        var ID = $(this).attr('ID');
        var action = $(this).attr('action');
        var tipo = $(this).attr('tipo');


        //var controle = $('[controle]');
        var submit = $("[dContinuar]");

        // MaxFiles
        if ($(this).attr('maxFiles').length) {
            _maxFiles = $(this).attr('maxFiles');
        } else {
            _maxFiles = 10;
        }

        // extFilter
        if ($(this).attr('extFilter').length) {
            _extFilter = $(this).attr('extFilter');
        } else {
            _extFilter = '';
        }


        var uploader = new Dropzone(this, { // Make the whole body a dropzone
          url: action, // Set the url
          parallelUploads: 5,
          maxFiles: _maxFiles,
          maxFilesize: 200, //mb
          acceptedFiles: _extFilter, //
          //previewTemplate: previewTemplate,
          autoQueue: true, // Make sure the files aren't queued until manually added
          //previewsContainer: "#previews", // Define the container to display the previews
          //clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.,
          removedfile: function(file) {
            
            if (file.status == 'success') {
                if(file.xhr) {
                    r = JSON.parse(file.xhr.response);
                }
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: "acao=deletar&arquivo="+r.ID,
                    dataType: 'html',
                    success: function( data ) {
                        retornoAjax($.parseJSON(data));
                    }
                });
                //var v = parseInt(controle.val())-parseInt(1);
                //controle.attr('value', v);
            }
            var _ref;
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
          }
        });
        // Start UPLOADS:
        uploader.on('addedfile', function(file, xhr, formData){
            BlockUI('.dropzone');
            submit.prop('disabled', true);
            submit.children('span').html('Aguarde carregar os arquivos.');
        });
        // Envia Informações de Sessão e Usuário
        uploader.on('sending', function(file, xhr, formData){
            formData.append('ID', ID);
            formData.append('codigo', codigo);
            formData.append('acao', 'novo');
            formData.append('tipo', tipo);
            
        });
        // Completar UPLOADS:
        uploader.on('queuecomplete', function(file, xhr, formData){ location.reload();
            unBlockUI('.dropzone');
            submit.prop('disabled', false);
            submit.children('span').html( 'Continuar' );
        });
        // Success
        uploader.on("success", function(file, response) {
            //retornoAjax(response);
        });
    })
}


$('[legendaArquivo]').each( function () {
    $(this).on('click', function() {
        ID = $(this).attr('legendaArquivo');
        titulo = $('[titulo='+ID+']');
        subtitulo = $('[subtitulo='+ID+']');
        texto = $('[texto='+ID+']');
        link = $('[link='+ID+']');
        imagem = $('[imagem='+ID+']').attr('src_imagem');
        imagem_status = $('[imagem='+ID+']').attr('status');

        if(titulo.length > 0) {
            if(titulo.html() != '- Sem Título -') {
                $('#texto-titulo').attr('value', titulo.html());
            }
        } else {
            $('#texto-titulo').attr('value', '');
        }
        if(subtitulo.length > 0) {
            if(subtitulo.html() != '- Sem Subtítulo -') {
                $('#texto-subtitulo').attr('value', subtitulo.html());
            }
        } else {
            $('#texto-subtitulo').attr('value', '');
        }
        if(texto.length > 0) {
            if(texto.html() != '- Sem Texto -') {
                $('#texto-texto').attr('value', texto.html());
            }
        } else {
            $('#texto-texto').attr('value', '');
        }
        if(link.length > 0) {
            if(link.html() != '- Sem Link -') {
                $('#texto-link').attr('value', link.html());
            }
        } else {
            $('#texto-subtitulo').attr('value', '');
        }

        if(imagem.length > 0) {
            $('#imagem_ativa').attr('src', imagem);
        } else {
            $('#imagem_ativa').attr('src', '');
        }

        $('#imagem_status').val(imagem_status);

        $('#modal-legenda').modal('show');

        $('#alvo-legenda').attr('value', ID);

        $('#modal-legenda').on('hidden.bs.modal', function () {
            $('#texto-titulo').attr('value', '');
            $('#texto-subtitulo').attr('value', '');
            $('#texto-texto').attr('value', '');
            $('#texto-link').attr('value', '');
            $('#imagem_ativa').attr('src', ($));
        })
    })
})

$('[ordenar]').on('change', function(e) {
    foco = $(this).attr('ordenar');
    anterior = $(this).attr('value');
    ordem = this.value;
    if (anterior > ordem) {
        acao = '-';
    } else if (anterior < ordem) {
        acao = '+';
    }
    $('[ordenar]').each( function () {
        if ( $(this).attr('ordenar') != foco ) {
            if(acao == '+') {
                if (this.value == ordem) {
                    $(this).attr('value', this.value--)
                }
            } else if (acao == '-') {
                if (this.value == ordem) {
                    $(this).attr('value', this.value++)
                }
            }           
        } else {
            return;
        }
    })

})
$('#ordenar').on('submit', function(e) {
    e.preventDefault();
    action = $(this).attr('action');
    dados = $(this).serialize();
    $.ajax({
        type: "POST",
        dataType: "json",
        url: action,
        data: dados,
        success: function( data ) {
            retornoAjax(data);
        },
        error: function( data ) {
            $toast = toastr['error']('Informações inválidas. Atualize a página para continuar.');
        }
    });
})