<?
class Carrossel extends APP {
	PRIVATE $APP;

	PUBLIC $carrossels;
	PUBLIC $secoes;

	function __construct($isView) {
		if($isView) { $this->isView = true; }
		parent::__construct($isView);
		$this::getCarrosels();
		$this::getSecoes();
		if ((int) ENTIDADE !== 0) {
			$this->_auth->entidade = $this::getEntidade(ENTIDADE);
		}
	}

	function ativarImg($ID) {
		return $this::setSetup('arquivos', $ID, array('status' => 1));
	}
	function desativarImg($ID) {
		return $this::setSetup('arquivos', $ID, array('status' => 0));
	}

	function setSetup($tabela, $ID, $dados) {
		$this->db->where('id', $ID);
		if ( $this->db->update('carrossel_'.$tabela, $dados) ) {
			return $ID;
		} else {
			return false;
		}
	}

	function addSetup($tabela, $ID, $dados) {
		if ( $this->db->insert('carrossel_'.$tabela, $dados) ) {
			return $this->db->getInsertID();
		} else {
			return false;
		}
	}

	function delSetup($tabela, $ID) {
		$this->db->where('id', $ID);
		if ( $this->db->delete('carrossel_'.$tabela) ) {
			return true;
		} else {
			return false;
		}
	}

	function getCarrosels() {
		$this->db->join('carrossel_secoes s', 's.id = c.secao', 'LEFT');
		$this->db->where('c.entidade', $this->_auth->entidade->id);
		$this->carrossels = $this->db->ObjectBuilder()->get('carrossel c', null, 'c.*, s.nome as secao, s.id as secao_id');
		return $this->carrossels;
	}

	function desativar($ID) {
		$dados = array('status' => '0');
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('carrossel', $dados);
	}

	function ativar($ID, $secao) {
		$secoes = $this::desativarCarrosselSecao($secao);
		$dados = array('status' => 1);
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('carrossel', $dados);
	}

	function desativarCarrosselSecao($secao_id) {
		$this->db->where('secao', $secao_id);
		if($secoes = $this->db->ObjectBuilder()->getValue('carrossel', 'id', null)) { 
			$dados = array('status' => '0');
			$this->db->where('id', $secoes, 'IN');
			return $this->db->update('carrossel', $dados);
		}
	}

	function excluirArquivo($ID) {
		$a = $this::getArquivo($ID);
		if( is_file($a->path.$a->arquivo) ) {
			@unlink($a->path.$a->arquivo);
			@unlink($a->path.'min/'.$a->arquivo);
		}
		$this->db->where('id', $ID);
		$this->db->delete('carrossel_arquivos');

		$ordem = count($this::getImagens($a->carrossel));
		if($a->ordem == $ordem) {
			return true;
		} else {
			$this->db->where('carrossel', $a->carrossel);
			$this->db->where('ordem', $a->ordem, '>');
			if( $imgs = $this->db->get('carrossel_arquivos') ) {
				foreach($imgs as $i) {
					$i['ordem'] = ($i['ordem']-1);
					$this->db->where('id', $i['id']);
					$this->db->update('carrossel_arquivos', $i);
				}
				return true;
			} else {
				return true;
			}
		}
	}

	function getArquivo($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('carrossel_arquivos');
	}

	function getImagemID($ID) {
		$this->db->where('id', $ID);
		return $this->db->ObjectBuilder()->getOne('carrossel_arquivos');
	}

	function getImagens($id, $full = false) {
		if($full == false) {
			$this->db->where('status', 1);
		}
		$this->db->where('carrossel', $id);
		$this->db->OrderBy('ordem', 'asc');
		return $this->db->ObjectBuilder()->get('carrossel_arquivos');
	}

	function addImagem($ID, $dados) {
		$dados['ordem'] = count($this::getImagens($ID));
		$this->db->insert('carrossel_arquivos', $dados);
		return $this->db->getInsertID();
	}

	function getCarrossel($ID) {
		$this->db->join('carrossel_secoes s', 's.id = c.secao', 'LEFT');
		$this->db->where('c.entidade', $this->_auth->entidade->id);
		$this->db->where('c.id', $ID);
		return $this->db->ObjectBuilder()->getOne('carrossel c', 'c.*, s.nome as secao, s.id as secao_id');
	}

	function getCarrosselSecao($secao) {
		if(defined('ENTIDADE')) {
			$this->db->where('c.entidade', $this->_auth->entidade->id);
		}
		$this->db->join('carrossel_secoes s', 's.id = c.secao', 'LEFT');
		$this->db->where('s.nome', $secao);
		$this->db->where('c.status', 1);
		return $this->db->ObjectBuilder()->getOne('carrossel c', 'c.*, s.nome as secao, s.id as secao_id');
	}

	function editar($ID, $dados) {
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->update('carrossel', $dados);
	}
	function excluir($ID) {
		if ($A = $this::getImagens($ID)) {
			foreach ($A as $a) {
				$this::excluirArquivo($a->id);
			}
			$path = $A[0]->path;
			@rmdir($path.'min/');
			@rmdir($path);
		}
		$this->db->where('id', $ID);
		$this->db->where('entidade', $this->_auth->entidade->id);
		return $this->db->delete('carrossel');
	}

	function setLegenda($ID, $legenda) {
		$this->db->where('id', $ID);
		return $this->db->update('carrossel_arquivos', $legenda);
	}

	function ordenar($ID, $dados) {
		$o = 0;
		foreach($dados as $alvo => $ordem) {
			$this->db->where('carrossel', $ID);
			$this->db->where('id', $alvo);
			$data = array('ordem' => $o);
			$this->db->update('carrossel_arquivos', $data);
			$o++;
		}
		return true;
	}

	function adicionar($dados) {
		if ($this->db->insert('carrossel', $dados)){
			return $this->db->getInsertId();
		} else {
			return false;
		}
	}
	function getUrlArquivo($ID) {
		$this->db->where('id', $ID);
		$a = $this->db->ObjectBuilder()->getOne('carrossel_arquivos');
		if($a) {
			return DIR.$a->path.$a->arquivo;
		} else {
			return '';
		}
	}
	function getSecoes($check = false, $filtros = false) {
		if($check) {
			$this->db->join('carrossel a', 'a.secao = s.id', 'INNER');
		} 
		if ($filtros->ent) {
			$this->db->where('s.entidade', $filtros->ent);
		} else {
			$this->db->where('s.entidade', $this->_auth->entidade->id);
		}
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('carrossel_secoes s', null, 's.*');
		return $this->secoes;
	}
	function getSecoesDisp($secao = false) {
		$this->db->join('carrossel a', 'a.secao = s.id', 'LEFT');
		if($secao) {
			$this->db->where('(a.id IS NULL OR s.id = "'.$secao.'")');
		} else {
			$this->db->where('a.id IS NULL');
		}
		$this->db->where('s.entidade', $this->_auth->entidade->id);
		$this->db->OrderBy('s.nome', 'ASC');
		$this->db->groupBy('s.nome');
		$this->secoes = $this->db->ObjectBuilder()->get('carrossel_secoes s', null, 's.*');
		return $this->secoes;
	}
}

return $CARROSSEL = new Carrossel($isView);

?>